/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public final class JREvaluationTime
implements Serializable {
    private static final long serialVersionUID = 10200L;
    public static final JREvaluationTime EVALUATION_TIME_REPORT = new JREvaluationTime(EvaluationTimeEnum.REPORT, null, null);
    public static final JREvaluationTime EVALUATION_TIME_PAGE = new JREvaluationTime(EvaluationTimeEnum.PAGE, null, null);
    public static final JREvaluationTime EVALUATION_TIME_COLUMN = new JREvaluationTime(EvaluationTimeEnum.COLUMN, null, null);
    public static final JREvaluationTime EVALUATION_TIME_NOW = new JREvaluationTime(EvaluationTimeEnum.NOW, null, null);
    public static final JREvaluationTime EVALUATION_TIME_MASTER = new JREvaluationTime(EvaluationTimeEnum.MASTER, null, null);
    private final EvaluationTimeEnum type;
    private final String groupName;
    private final int bandId;
    private final int hash;

    public static JREvaluationTime getGroupEvaluationTime(String groupName) {
        return new JREvaluationTime(EvaluationTimeEnum.GROUP, groupName, null);
    }

    public static JREvaluationTime getBandEvaluationTime(JRFillBand band) {
        return new JREvaluationTime(EvaluationTimeEnum.BAND, null, band);
    }

    public static JREvaluationTime getBandEvaluationTime(int bandId) {
        return new JREvaluationTime(EvaluationTimeEnum.BAND, null, bandId);
    }

    public static JREvaluationTime getEvaluationTime(EvaluationTimeEnum type, JRGroup group, JRFillBand band) {
        JREvaluationTime evaluationTime;
        switch (type) {
            case REPORT: {
                evaluationTime = EVALUATION_TIME_REPORT;
                break;
            }
            case MASTER: {
                evaluationTime = EVALUATION_TIME_MASTER;
                break;
            }
            case PAGE: {
                evaluationTime = EVALUATION_TIME_PAGE;
                break;
            }
            case COLUMN: {
                evaluationTime = EVALUATION_TIME_COLUMN;
                break;
            }
            case GROUP: {
                evaluationTime = JREvaluationTime.getGroupEvaluationTime(group.getName());
                break;
            }
            case BAND: {
                evaluationTime = JREvaluationTime.getBandEvaluationTime(band);
                break;
            }
            default: {
                evaluationTime = null;
            }
        }
        return evaluationTime;
    }

    private JREvaluationTime(EvaluationTimeEnum type, String groupName, JRFillBand band) {
        this(type, groupName, band == null ? 0 : band.getId());
    }

    private JREvaluationTime(EvaluationTimeEnum type, String groupName, int bandId) {
        this.type = type;
        this.groupName = groupName;
        this.bandId = bandId;
        this.hash = this.computeHash();
    }

    private int computeHash() {
        int hashCode = this.type.ordinal();
        hashCode = 31 * hashCode + (this.groupName == null ? 0 : this.groupName.hashCode());
        hashCode = 31 * hashCode + this.bandId;
        return hashCode;
    }

    public boolean equals(Object obj) {
        boolean eq;
        if (obj == this) {
            return true;
        }
        JREvaluationTime e = (JREvaluationTime)obj;
        boolean bl = eq = e.type == this.type;
        if (eq) {
            switch (this.type) {
                case GROUP: {
                    eq = this.groupName.equals(e.groupName);
                    break;
                }
                case BAND: {
                    eq = this.bandId == e.bandId;
                }
            }
        }
        return eq;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "{type: " + this.type + ", group: " + this.groupName + ", band: " + this.bandId + "}";
    }

    public EvaluationTimeEnum getType() {
        return this.type;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getBandId() {
        return this.bandId;
    }
}

