/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Glob;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.json.ResponseContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Objects
extends AbstractObjectHandler {
    private Logger log = LoggerFactory.getLogger(AbstractHandler.class);

    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        if (!session.isObjectsSynchronized()) {
            session.syncObjects();
        }
        ArrayList<AbstractObject> objects = session.getAllObjects();
        String areaFilter = query.get("area");
        String classFilter = query.get("class");
        String nameFilter = query.get("name");
        HashMap<String, String> customAttributes = null;
        for (String k : query.keySet()) {
            if (!k.startsWith("@")) continue;
            if (customAttributes == null) {
                customAttributes = new HashMap<String, String>();
            }
            customAttributes.put(k.substring(1), query.get(k));
        }
        if (areaFilter != null || classFilter != null || customAttributes != null || nameFilter != null) {
            double[] area = null;
            if (areaFilter != null) {
                String[] parts = areaFilter.split(",");
                if (parts.length == 4) {
                    try {
                        area = new double[4];
                        for (int i = 0; i < 4; ++i) {
                            area[i] = Double.parseDouble(parts[i]);
                        }
                    }
                    catch (NumberFormatException e) {
                        this.log.warn("Invalid area filter " + areaFilter);
                    }
                } else {
                    this.log.warn("Invalid area filter " + areaFilter);
                }
            }
            String[] classes = null;
            if (classFilter != null && !classFilter.isEmpty()) {
                classes = classFilter.split(",");
            }
            ArrayList<AbstractObject> filteredObjects = new ArrayList<AbstractObject>();
            for (AbstractObject o : objects) {
                boolean match;
                if (nameFilter != null && !nameFilter.isEmpty() && !Glob.matchIgnoreCase((String)nameFilter, (String)o.getObjectName())) continue;
                if (classes != null) {
                    match = false;
                    for (String c : classes) {
                        if (!o.getObjectClassName().equalsIgnoreCase(c)) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                }
                if (area != null && !o.getGeolocation().isWithinArea(area[0], area[1], area[2], area[3])) continue;
                if (customAttributes != null) {
                    if (o.getCustomAttributes().isEmpty()) continue;
                    match = true;
                    for (Map.Entry entry : customAttributes.entrySet()) {
                        String value = (String)o.getCustomAttributes().get(entry.getKey());
                        if (value != null && Glob.matchIgnoreCase((String)((String)entry.getValue()), (String)value)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                }
                filteredObjects.add(o);
            }
            objects = filteredObjects;
        }
        return new ResponseContainer("objects", (Object)objects);
    }

    protected Object get(String id, Map<String, String> query) throws Exception {
        return this.getObject();
    }

    protected String getEntityIdFieldName() {
        return "object-id";
    }
}

