/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Locale;
import org.netxms.client.constants.RCC;

public class NXCException
extends Exception {
    private static final long serialVersionUID = 1453981595988661915L;
    protected int errorCode;
    protected String additionalInfo;

    public NXCException(int errorCode) {
        this.errorCode = errorCode;
        this.additionalInfo = null;
    }

    public NXCException(int errorCode, String additionalInfo) {
        this.errorCode = errorCode;
        this.additionalInfo = additionalInfo;
    }

    protected String getErrorMessage(int code, String lang) {
        return RCC.getText(code, lang, this.additionalInfo);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage(this.errorCode, "en");
    }

    @Override
    public String getLocalizedMessage() {
        Locale locale = Locale.getDefault();
        return this.getErrorMessage(this.errorCode, locale.getLanguage());
    }
}

