/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.base.InetAddressEx;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.tools.ComparatorHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectSearchResultComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        AbstractObject object1 = (AbstractObject)e1;
        AbstractObject object2 = (AbstractObject)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (column) {
            case 0: {
                result = Long.signum(object1.getObjectId() - object2.getObjectId());
                break;
            }
            case 3: {
                InetAddressEx a1 = ObjectSearchResultComparator.getIpAddress(object1);
                InetAddressEx a2 = ObjectSearchResultComparator.getIpAddress(object2);
                result = ComparatorHelper.compareInetAddresses((InetAddress)a1.getAddress(), (InetAddress)a2.getAddress());
                break;
            }
            case 2: {
                result = object1.getObjectName().compareToIgnoreCase(object2.getObjectName());
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                String t1 = ((ITableLabelProvider)((SortableTableViewer)viewer).getLabelProvider()).getColumnText((Object)object1, column);
                String t2 = ((ITableLabelProvider)((SortableTableViewer)viewer).getLabelProvider()).getColumnText((Object)object2, column);
                result = t1.compareToIgnoreCase(t2);
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private static InetAddressEx getIpAddress(AbstractObject object) {
        InetAddressEx addr = null;
        if (object instanceof AbstractNode) {
            addr = ((AbstractNode)object).getPrimaryIP();
        } else if (object instanceof AccessPoint) {
            addr = ((AccessPoint)object).getIpAddress();
        } else if (object instanceof Interface) {
            addr = ((Interface)object).getFirstUnicastAddressEx();
        }
        return addr != null ? addr : new InetAddressEx();
    }
}

