/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class LocalFileSelector
extends AbstractSelector {
    private List<File> fileList = new ArrayList<File>();
    private String[] filterExtensions = new String[]{"*"};
    private String[] filterNames;
    private int selectorType;

    public LocalFileSelector(Composite parent, int style, boolean useHyperlink, int selectorType) {
        super(parent, style, 4 | (useHyperlink ? 1 : 0));
        String[] stringArray = new String[1];
        Messages.get();
        stringArray[0] = Messages.LocalFileSelector_AllFiles;
        this.filterNames = stringArray;
        this.selectorType = selectorType;
        Messages.get();
        this.setText(Messages.LocalFileSelector_None);
    }

    protected void selectionButtonHandler() {
        FileDialog fd = new FileDialog(this.getShell(), this.selectorType);
        Messages.get();
        fd.setText(Messages.LocalFileSelector_SelectFile);
        fd.setFilterExtensions(this.filterExtensions);
        fd.setFilterNames(this.filterNames);
        fd.open();
        String[] files = fd.getFileNames();
        if (files.length > 0) {
            this.fileList.clear();
            int i = 0;
            while (i < files.length) {
                this.fileList.add(new File(fd.getFilterPath(), files[i]));
                ++i;
            }
            this.updateFileList();
        } else {
            this.fileList.clear();
            this.updateFileList();
        }
    }

    protected String getSelectionButtonToolTip() {
        Messages.get();
        return Messages.LocalFileSelector_Tooltip;
    }

    public File getFile() {
        if (this.fileList.size() > 0) {
            return this.fileList.get(0);
        }
        return null;
    }

    public List<File> getFileList() {
        return this.fileList;
    }

    public void setFile(File file) {
        this.fileList.clear();
        this.fileList.add(file);
        this.updateFileList();
    }

    private void updateFileList() {
        StringBuilder fileListString = new StringBuilder();
        int i = 0;
        while (i < this.fileList.size()) {
            fileListString.append(this.fileList.get(i).getName());
            if (i != this.fileList.size() - 1) {
                fileListString.append(", ");
            }
            ++i;
        }
        if (this.fileList.size() == 0) {
            Messages.get();
            fileListString.append(Messages.LocalFileSelector_None);
        }
        this.setText(fileListString.toString());
        this.fireModifyListeners();
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }
}

