/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.configs;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.netxms.base.Glob;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.configs.DCIImageRule;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.xml.XMLTools;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;

@Root(name="dciImageConfiguration")
public class DCIImageConfiguration {
    public static final int OP_LE = 0;
    public static final int OP_LE_EQ = 1;
    public static final int OP_EQ = 2;
    public static final int OP_GT_EQ = 3;
    public static final int OP_GT = 4;
    public static final int OP_NE = 5;
    public static final int OP_LIKE = 6;
    public static final int OP_NOTLIKE = 7;
    @ElementArray(required=true)
    private DCIImageRule[] dciRuleList = new DCIImageRule[0];
    @Element(required=true)
    private SingleDciConfig dci = new SingleDciConfig();
    @Element(required=true)
    private UUID defaultImage = null;

    public static DCIImageConfiguration createFromXml(String xml) throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        return (DCIImageConfiguration)((Object)serializer.read(DCIImageConfiguration.class, xml));
    }

    public String createXml() throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, writer);
        return ((Object)writer).toString();
    }

    public DCIImageRule[] getDciRuleArray() {
        return this.dciRuleList;
    }

    public void setDciRuleArray(DCIImageRule[] dciRuleList) {
        this.dciRuleList = dciRuleList;
    }

    public List<DCIImageRule> getRulesAsList() {
        ArrayList<DCIImageRule> ruleLisr = new ArrayList<DCIImageRule>();
        if (this.containRuleList()) {
            for (DCIImageRule dci : this.dciRuleList) {
                ruleLisr.add(dci);
            }
        }
        return ruleLisr;
    }

    public SingleDciConfig getDci() {
        return this.dci;
    }

    public void setDci(SingleDciConfig dci) {
        this.dci = dci;
    }

    public UUID getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(UUID defaultImage) {
        this.defaultImage = defaultImage;
    }

    public boolean containRuleList() {
        return this.dciRuleList != null && this.dciRuleList.length > 0;
    }

    public UUID getCorrectImage(DciValue dciValue) {
        UUID image2 = null;
        if (this.containRuleList() && dciValue != null) {
            for (int i = 0; i < this.dciRuleList.length; ++i) {
                switch (this.dciRuleList[i].getComparisonType()) {
                    case 0: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) >= 0) break;
                        image2 = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 1: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) > 0) break;
                        image2 = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 2: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) != 0) break;
                        image2 = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 3: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) < 0) break;
                        image2 = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 4: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) <= 0) break;
                        image2 = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 5: {
                        if (this.compareValues(dciValue.getValue(), this.dciRuleList[i].getCompareValue(), dciValue.getDataType()) == 0) break;
                        image2 = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 6: {
                        if (!Glob.matchIgnoreCase(this.dciRuleList[i].getCompareValue(), dciValue.getValue())) break;
                        image2 = this.dciRuleList[i].getImage();
                        break;
                    }
                    case 7: {
                        if (Glob.matchIgnoreCase(this.dciRuleList[i].getCompareValue(), dciValue.getValue())) break;
                        image2 = this.dciRuleList[i].getImage();
                    }
                }
                if (image2 != null) break;
            }
        }
        return image2 != null ? image2 : this.defaultImage;
    }

    private int compareValues(String value1, String value2, int dataType) {
        int result2 = 0;
        try {
            switch (dataType) {
                case 0: 
                case 1: {
                    result2 = new Integer(value1).compareTo(new Integer(value2));
                    break;
                }
                case 5: {
                    result2 = new Float(value1).compareTo(new Float(value2));
                    break;
                }
                case 2: 
                case 3: {
                    result2 = new Long(value1).compareTo(new Long(value2));
                    break;
                }
                default: {
                    result2 = value1.compareTo(value2);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            result2 = value1.compareTo(value2);
        }
        return result2;
    }
}

