/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.python.core.ArgParser;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinClassMethodNarrow;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyByteArray$bytearray___add___exposer;
import org.python.core.PyByteArray$bytearray___eq___exposer;
import org.python.core.PyByteArray$bytearray___getitem___exposer;
import org.python.core.PyByteArray$bytearray_isalpha_exposer;
import org.python.core.PyByteArray$bytearray_isdigit_exposer;
import org.python.core.PyByteArray$bytearray_join_exposer;
import org.python.core.PyByteArray$bytearray_pop_exposer;
import org.python.core.PyByteArray$bytearray_repr_exposer;
import org.python.core.PyByteArray$bytearray_reverse_exposer;
import org.python.core.PyByteArray$bytearray_rjust_exposer;
import org.python.core.PyByteArray$bytearray_rpartition_exposer;
import org.python.core.PyByteArray$bytearray_split_exposer;
import org.python.core.PyByteArray$bytearray_splitlines_exposer;
import org.python.core.PyByteArray$bytearray_startswith_exposer;
import org.python.core.PyByteArray$bytearray_str_exposer;
import org.python.core.PyByteArray$bytearray_strip_exposer;
import org.python.core.PyByteArray$bytearray_swapcase_exposer;
import org.python.core.PyByteArray$bytearray_title_exposer;
import org.python.core.PyByteArray$bytearray_translate_exposer;
import org.python.core.PyByteArray$bytearray_upper_exposer;
import org.python.core.PyByteArray$bytearray_zfill_exposer;
import org.python.core.PyByteArray$exposed___new__;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleWritableBuffer;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="bytearray", base=PyObject.class, doc="bytearray(iterable_of_ints) -> bytearray.\nbytearray(string, encoding[, errors]) -> bytearray.\nbytearray(bytes_or_bytearray) -> mutable copy of bytes_or_bytearray.\nbytearray(memory_view) -> bytearray.\n\nConstruct an mutable bytearray object from:\n  - an iterable yielding integers in range(256)\n  - a text string encoded using the specified encoding\n  - a bytes or a bytearray object\n  - any object implementing the buffer API.\n\nbytearray(int) -> bytearray.\n\nConstruct a zero-initialized bytearray of the given length.")
public class PyByteArray
extends BaseBytes
implements BufferProtocol {
    public static final PyType TYPE;
    private WeakReference<BaseBuffer> export;

    public PyByteArray(PyType type) {
        super(type);
    }

    public PyByteArray() {
        super(TYPE);
    }

    public PyByteArray(int size) {
        super(TYPE);
        this.init(size);
    }

    public PyByteArray(int[] value) {
        super(TYPE, value);
    }

    public PyByteArray(BaseBytes value) {
        super(TYPE);
        this.init(value);
    }

    PyByteArray(PyBuffer value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(BufferProtocol value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(Iterable<? extends PyObject> value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(PyString arg, PyObject encoding, PyObject errors2) {
        super(TYPE);
        this.init(arg, encoding, errors2);
    }

    public PyByteArray(PyString arg, String encoding, String errors2) {
        super(TYPE);
        this.init(arg, encoding, errors2);
    }

    public PyByteArray(PyString arg) {
        super(TYPE);
        this.init(arg, (String)null, (String)null);
    }

    public PyByteArray(byte[] storage) {
        super(TYPE);
        this.setStorage(storage);
    }

    public PyByteArray(byte[] storage, int size) {
        super(TYPE);
        this.setStorage(storage, size);
    }

    public PyByteArray(PyObject arg) throws PyException {
        super(TYPE);
        this.init(arg);
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        BaseBuffer pybuf = this.getExistingBuffer(flags);
        if (pybuf == null) {
            pybuf = new SimpleWritableBuffer(flags, this, this.storage, this.offset, this.size);
            this.export = new WeakReference<BaseBuffer>(pybuf);
        }
        return pybuf;
    }

    private BaseBuffer getExistingBuffer(int flags) throws PyException {
        BaseBuffer pybuf = null;
        if (this.export != null && (pybuf = (BaseBuffer)this.export.get()) != null) {
            pybuf = pybuf.getBufferAgain(flags);
        }
        return pybuf;
    }

    protected void resizeCheck() throws PyException {
        if (this.export != null) {
            PyBuffer pybuf = (PyBuffer)this.export.get();
            if (pybuf != null && !pybuf.isReleased()) {
                throw Py.BufferError("Existing exports of data: object cannot be re-sized");
            }
            this.export = null;
        }
    }

    @Override
    protected synchronized PyByteArray getslice(int start, int stop, int step) {
        if (step == 1) {
            return this.getslice(start, stop);
        }
        int n = PyByteArray.sliceLength(start, stop, step);
        PyByteArray ret = new PyByteArray(n);
        n += ret.offset;
        byte[] dst = ret.storage;
        int io2 = start + this.offset;
        for (int jo = ret.offset; jo < n; ++jo) {
            dst[jo] = this.storage[io2];
            io2 += step;
        }
        return ret;
    }

    @Override
    protected synchronized PyByteArray getslice(int start, int stop) {
        int n = stop - start;
        if (n <= 0) {
            return new PyByteArray();
        }
        PyByteArray ret = new PyByteArray(n);
        System.arraycopy(this.storage, this.offset + start, ret.storage, ret.offset, n);
        return ret;
    }

    @Override
    protected synchronized PyByteArray repeat(int count2) {
        PyByteArray ret = new PyByteArray();
        ret.setStorage(this.repeatImpl(count2));
        return ret;
    }

    protected synchronized void irepeat(int count2) {
        block6: {
            if (this.size == 0 || count2 == 1) break block6;
            if (count2 <= 0) {
                this.resizeCheck();
                this.setStorage(emptyStorage);
            } else {
                int orginalSize = this.size;
                this.storageExtend(orginalSize * (count2 - 1));
                if (orginalSize == 1) {
                    byte b = this.storage[this.offset];
                    int p = this.offset + 1;
                    for (int i = 1; i < count2; ++i) {
                        this.storage[p++] = b;
                    }
                } else {
                    int i = 1;
                    int p = this.offset + orginalSize;
                    while (i < count2) {
                        System.arraycopy(this.storage, this.offset, this.storage, p, orginalSize);
                        ++i;
                        p += orginalSize;
                    }
                }
            }
        }
    }

    @Override
    public synchronized void pyset(int index, PyObject value) throws PyException {
        this.storage[index + this.offset] = PyByteArray.byteCheck(value);
    }

    @Override
    public synchronized void pyinsert(int index, PyObject element) {
        this.storageReplace(index, 0, 1);
        this.storage[this.offset + index] = PyByteArray.byteCheck(element);
    }

    @Override
    protected synchronized void setslice(int start, int stop, int step, PyObject value) {
        if (step == 1 && stop < start) {
            stop = start;
        }
        if (value instanceof PyString) {
            this.setslice(start, stop, step, (PyString)value);
        } else if (value.isIndex()) {
            this.setslice(start, stop, step, value.asIndex(Py.OverflowError));
        } else if (value instanceof BaseBytes) {
            this.setslice(start, stop, step, (BaseBytes)value);
        } else if (value instanceof BufferProtocol) {
            this.setslice(start, stop, step, (BufferProtocol)((Object)value));
        } else {
            this.setslice(start, stop, step, value.asIterable());
        }
    }

    private void setslice(int start, int stop, int step, int len) throws PyException {
        if (step == 1) {
            this.storageReplace(start, stop - start, len);
            Arrays.fill(this.storage, start + this.offset, start + this.offset + len, (byte)0);
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n);
            }
            int io2 = start + this.offset;
            while (n > 0) {
                this.storage[io2] = 0;
                io2 += step;
                --n;
            }
        }
    }

    private void setslice(int start, int stop, int step, PyString value) throws PyException {
        if (value instanceof PyUnicode) {
            throw Py.TypeError("can't set bytearray slice from unicode");
        }
        String v = value.asString();
        int len = v.length();
        if (step == 1) {
            this.storageReplace(start, stop - start, len);
            this.setBytes(start, v);
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n);
            }
            this.setBytes(start, step, v);
        }
    }

    private void setslice(int start, int stop, int step, BufferProtocol value) throws PyException {
        try (PyBuffer view = value.getBuffer(284);){
            int len = view.getLen();
            if (step == 1) {
                this.storageReplace(start, stop - start, len);
                view.copyTo(this.storage, start + this.offset);
            } else {
                int n = PyByteArray.sliceLength(start, stop, step);
                if (n != len) {
                    throw PyByteArray.SliceSizeError("bytes", len, n);
                }
                int io2 = start + this.offset;
                for (int j = 0; j < n; ++j) {
                    this.storage[io2] = view.byteAt(j);
                    io2 += step;
                }
            }
        }
    }

    private void setslice(int start, int stop, int step, BaseBytes value) throws PyException {
        if (value == this) {
            value = new PyByteArray(value);
        }
        int len = value.size;
        if (step == 1) {
            this.storageReplace(start, stop - start, len);
            System.arraycopy(value.storage, value.offset, this.storage, start + this.offset, len);
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n);
            }
            int no = n + value.offset;
            int io2 = start + this.offset;
            for (int jo = value.offset; jo < no; ++jo) {
                this.storage[io2] = value.storage[jo];
                io2 += step;
            }
        }
    }

    private void setslice(int start, int stop, int step, Iterable<? extends PyObject> iter) {
        BaseBytes.FragmentList fragList = new BaseBytes.FragmentList();
        fragList.loadFrom(iter);
        if (step == 1) {
            this.storageReplace(start, stop - start, fragList.totalCount);
            if (fragList.totalCount > 0) {
                fragList.emptyInto(this.storage, start + this.offset);
            }
        } else {
            int n = PyByteArray.sliceLength(start, stop, step);
            if (n != fragList.totalCount) {
                throw PyByteArray.SliceSizeError("bytes", fragList.totalCount, n);
            }
            fragList.emptyInto(this.storage, start + this.offset, step);
        }
    }

    @Override
    protected synchronized void del(int index) {
        this.storageDelete(index, 1);
    }

    @Override
    protected synchronized void delRange(int start, int stop) {
        this.storageDelete(start, stop - start);
    }

    @Override
    protected synchronized void delslice(int start, int stop, int step, int n) {
        this.resizeCheck();
        if (step == 1) {
            this.storageDelete(start, n);
        } else if (step == -1) {
            this.storageDelete(stop + 1, n);
        } else {
            int m;
            int p;
            if (step > 1) {
                p = start;
                m = step - 1;
            } else {
                p = start + (n - 1) * step;
                m = -1 - step;
            }
            p += this.offset;
            for (int i = 1; i < n; ++i) {
                int q = p + i;
                for (int j = 0; j < m; ++j) {
                    this.storage[p++] = this.storage[q++];
                }
            }
            this.storageDelete(p - this.offset, n);
        }
    }

    public static PyException SliceSizeError(String valueType, int valueSize, int sliceSize) {
        String fmt = "attempt to assign %s of size %d to extended slice of size %d";
        return Py.ValueError(String.format(fmt, valueType, valueSize, sliceSize));
    }

    @ExposedNew
    final synchronized void bytearray___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("bytearray", args, kwds, "source", "encoding", "errors");
        PyObject arg = ap.getPyObject(0, null);
        PyObject encoding = ap.getPyObjectByType(1, PyBaseString.TYPE, null);
        PyObject errors2 = ap.getPyObjectByType(2, PyBaseString.TYPE, null);
        if (encoding != null || errors2 != null) {
            if (arg == null || !(arg instanceof PyString)) {
                throw Py.TypeError("encoding or errors without sequence argument");
            }
            this.init((PyString)arg, encoding, errors2);
        } else {
            this.init(arg);
        }
    }

    @Override
    protected BaseBytes.Builder getBuilder(int capacity) {
        return new BaseBytes.Builder(capacity){

            @Override
            PyByteArray getResult() {
                return new PyByteArray(this.getStorage(), this.getSize());
            }
        };
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.basebytes___eq__(other);
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.basebytes___ne__(other);
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.basebytes___lt__(other);
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.basebytes___le__(other);
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.basebytes___ge__(other);
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.basebytes___gt__(other);
    }

    final synchronized PyObject bytearray___eq__(PyObject other) {
        return this.basebytes___eq__(other);
    }

    final synchronized PyObject bytearray___ne__(PyObject other) {
        return this.basebytes___ne__(other);
    }

    final synchronized PyObject bytearray___lt__(PyObject other) {
        return this.basebytes___lt__(other);
    }

    final synchronized PyObject bytearray___le__(PyObject other) {
        return this.basebytes___le__(other);
    }

    final synchronized PyObject bytearray___ge__(PyObject other) {
        return this.basebytes___ge__(other);
    }

    final synchronized PyObject bytearray___gt__(PyObject other) {
        return this.basebytes___gt__(other);
    }

    @Override
    public PyObject __add__(PyObject o) {
        return this.bytearray___add__(o);
    }

    final synchronized PyObject bytearray___add__(PyObject o) {
        PyByteArray sum = null;
        if (o instanceof BaseBytes) {
            BaseBytes ob = (BaseBytes)o;
            sum = new PyByteArray(this.size + ob.size);
            System.arraycopy(this.storage, this.offset, sum.storage, sum.offset, this.size);
            System.arraycopy(ob.storage, ob.offset, sum.storage, sum.offset + this.size, ob.size);
        } else if (o.getType() == PyString.TYPE) {
            PyString os2 = (PyString)o;
            sum = new PyByteArray(this.size + os2.__len__());
            System.arraycopy(this.storage, this.offset, sum.storage, sum.offset, this.size);
            sum.setslice(this.size, sum.size, 1, os2);
        } else {
            throw PyByteArray.ConcatenationTypeError(TYPE, o.getType());
        }
        return sum;
    }

    public int __alloc__() {
        return this.bytearray___alloc__();
    }

    final int bytearray___alloc__() {
        return this.storage.length;
    }

    @Override
    public PyObject __imul__(PyObject n) {
        return this.bytearray___imul__(n);
    }

    final PyObject bytearray___imul__(PyObject n) {
        if (!n.isIndex()) {
            return null;
        }
        this.irepeat(n.asIndex(Py.OverflowError));
        return this;
    }

    @Override
    public PyObject __mul__(PyObject n) {
        return this.bytearray___mul__(n);
    }

    final PyObject bytearray___mul__(PyObject n) {
        if (!n.isIndex()) {
            return null;
        }
        return this.repeat(n.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject n) {
        return this.bytearray___rmul__(n);
    }

    final PyObject bytearray___rmul__(PyObject n) {
        if (!n.isIndex()) {
            return null;
        }
        return this.repeat(n.asIndex(Py.OverflowError));
    }

    public void append(byte element) {
        this.storageExtend(1);
        this.storage[this.offset + this.size - 1] = element;
    }

    public void append(PyObject element) {
        this.bytearray_append(element);
    }

    final synchronized void bytearray_append(PyObject element) {
        this.storageExtend(1);
        this.storage[this.offset + this.size - 1] = PyByteArray.byteCheck(element);
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.basebytes___contains__(o);
    }

    final boolean bytearray___contains__(PyObject o) {
        return this.basebytes___contains__(o);
    }

    final PyObject bytearray_decode(PyObject[] args, String[] keywords) {
        return this.basebytes_decode(args, keywords);
    }

    public PyByteArray center(int width) {
        return (PyByteArray)this.basebytes_center(width, " ");
    }

    public PyByteArray center(int width, String fillchar) {
        return (PyByteArray)this.basebytes_center(width, fillchar);
    }

    final PyByteArray bytearray_center(int width, String fillchar) {
        return (PyByteArray)this.basebytes_center(width, fillchar);
    }

    public int count(PyObject sub) {
        return this.basebytes_count(sub, null, null);
    }

    public int count(PyObject sub, PyObject start) {
        return this.basebytes_count(sub, start, null);
    }

    public int count(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_count(sub, start, end);
    }

    final int bytearray_count(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_count(sub, start, end);
    }

    public boolean endswith(PyObject suffix) {
        return this.basebytes_starts_or_endswith(suffix, null, null, true);
    }

    public boolean endswith(PyObject suffix, PyObject start) {
        return this.basebytes_starts_or_endswith(suffix, start, null, true);
    }

    public boolean endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(suffix, start, end, true);
    }

    final boolean bytearray_endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(suffix, start, end, true);
    }

    public PyByteArray expandtabs() {
        return (PyByteArray)this.basebytes_expandtabs(8);
    }

    public PyByteArray expandtabs(int tabsize) {
        return (PyByteArray)this.basebytes_expandtabs(tabsize);
    }

    final PyByteArray bytearray_expandtabs(int tabsize) {
        return (PyByteArray)this.basebytes_expandtabs(tabsize);
    }

    public void extend(PyObject o) {
        this.bytearray_extend(o);
    }

    final synchronized void bytearray_extend(PyObject o) {
        o.__iter__();
        this.setslice(this.size, this.size, 1, o);
    }

    public int find(PyObject sub) {
        return this.basebytes_find(sub, null, null);
    }

    public int find(PyObject sub, PyObject start) {
        return this.basebytes_find(sub, start, null);
    }

    public int find(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_find(sub, start, end);
    }

    final int bytearray_find(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_find(sub, start, end);
    }

    static PyByteArray fromhex(String hex) throws PyException {
        return PyByteArray.bytearray_fromhex(TYPE, hex);
    }

    static PyByteArray bytearray_fromhex(PyType type, String hex) {
        PyByteArray result2 = new PyByteArray();
        PyByteArray.basebytes_fromhex(result2, hex);
        return result2;
    }

    final synchronized PyObject bytearray___getitem__(PyObject index) {
        return this.delegator.checkIdxAndGetItem(index);
    }

    @Override
    public PyObject __iadd__(PyObject o) {
        return this.bytearray___iadd__(o);
    }

    final synchronized PyObject bytearray___iadd__(PyObject o) {
        PyType oType = o.getType();
        if (oType == TYPE) {
            this.setslice(this.size, this.size, 1, (BaseBytes)o);
        } else if (oType == PyString.TYPE) {
            this.setslice(this.size, this.size, 1, (PyString)o);
        } else {
            throw PyByteArray.ConcatenationTypeError(oType, TYPE);
        }
        return this;
    }

    public int index(PyObject sub) {
        return this.bytearray_index(sub, null, null);
    }

    public int index(PyObject sub, PyObject start) {
        return this.bytearray_index(sub, start, null);
    }

    @Override
    public int hashCode() throws PyException {
        return this.bytearray___hash__();
    }

    final int bytearray___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    public int index(PyObject sub, PyObject start, PyObject end) throws PyException {
        return this.bytearray_index(sub, start, end);
    }

    final int bytearray_index(PyObject sub, PyObject start, PyObject end) {
        int pos = this.basebytes_find(sub, start, end);
        if (pos < 0) {
            throw Py.ValueError("subsection not found");
        }
        return pos;
    }

    public void insert(PyObject index, PyObject value) {
        this.bytearray_insert(index, value);
    }

    final synchronized void bytearray_insert(PyObject index, PyObject value) {
        this.pyinsert(this.boundToSequence(index.asIndex()), value);
    }

    final boolean bytearray_isalnum() {
        return this.basebytes_isalnum();
    }

    final boolean bytearray_isalpha() {
        return this.basebytes_isalpha();
    }

    final boolean bytearray_isdigit() {
        return this.basebytes_isdigit();
    }

    final boolean bytearray_islower() {
        return this.basebytes_islower();
    }

    final boolean bytearray_isspace() {
        return this.basebytes_isspace();
    }

    final boolean bytearray_istitle() {
        return this.basebytes_istitle();
    }

    final boolean bytearray_isupper() {
        return this.basebytes_isupper();
    }

    final PyByteArray bytearray_capitalize() {
        return (PyByteArray)this.basebytes_capitalize();
    }

    final PyByteArray bytearray_lower() {
        return (PyByteArray)this.basebytes_lower();
    }

    final PyByteArray bytearray_swapcase() {
        return (PyByteArray)this.basebytes_swapcase();
    }

    final PyByteArray bytearray_title() {
        return (PyByteArray)this.basebytes_title();
    }

    final PyByteArray bytearray_upper() {
        return (PyByteArray)this.basebytes_upper();
    }

    public PyByteArray join(PyObject iterable) {
        return this.bytearray_join(iterable);
    }

    final PyByteArray bytearray_join(PyObject iterable) {
        return this.basebytes_join(iterable.asIterable());
    }

    final int bytearray___len__() {
        return super.__len__();
    }

    public PyByteArray ljust(int width) {
        return (PyByteArray)this.basebytes_ljust(width, " ");
    }

    public PyByteArray ljust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_ljust(width, fillchar);
    }

    final PyByteArray bytearray_ljust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_ljust(width, fillchar);
    }

    public PyByteArray lstrip() {
        return this.bytearray_lstrip(null);
    }

    public PyByteArray lstrip(PyObject bytes) {
        return this.bytearray_lstrip(bytes);
    }

    final synchronized PyByteArray bytearray_lstrip(PyObject bytes) {
        int left;
        if (bytes == null || bytes == Py.None) {
            left = this.lstripIndex();
        } else {
            BaseBytes.ByteSet byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes));
            left = this.lstripIndex(byteSet);
        }
        return this.getslice(left, this.size);
    }

    final PyTuple bytearray_partition(PyObject sep) {
        return this.basebytes_partition(sep);
    }

    public PyInteger pop() {
        return this.bytearray_pop(-1);
    }

    public PyInteger pop(int i) {
        return this.bytearray_pop(i);
    }

    final synchronized PyInteger bytearray_pop(int i) {
        if (this.size == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (i < 0) {
            i += this.size;
        }
        return this.remove(i);
    }

    final PyObject bytearray___reduce__() {
        return this.basebytes___reduce__();
    }

    public void remove(PyObject o) throws PyException {
        this.bytearray_remove(o);
    }

    final synchronized void bytearray_remove(PyObject o) {
        byte b = PyByteArray.byteCheck(o);
        int pos = this.index(b);
        if (pos < 0) {
            throw Py.ValueError("value not found in bytearray");
        }
        this.storageDelete(pos, 1);
    }

    public PyByteArray replace(PyObject oldB, PyObject newB) {
        return this.basebytes_replace(oldB, newB, -1);
    }

    public PyByteArray replace(PyObject oldB, PyObject newB, int maxcount) {
        return this.basebytes_replace(oldB, newB, maxcount);
    }

    final PyByteArray bytearray_replace(PyObject oldB, PyObject newB, PyObject count2) {
        int maxcount = count2 == null ? -1 : count2.asInt();
        return this.basebytes_replace(oldB, newB, maxcount);
    }

    public void reverse() {
        this.bytearray_reverse();
    }

    final synchronized void bytearray_reverse() {
        int a = this.offset;
        int b = this.offset + this.size;
        while (--b > a) {
            byte t = this.storage[b];
            this.storage[b] = this.storage[a];
            this.storage[a++] = t;
        }
    }

    public int rfind(PyObject sub) {
        return this.basebytes_rfind(sub, null, null);
    }

    public int rfind(PyObject sub, PyObject start) {
        return this.basebytes_rfind(sub, start, null);
    }

    public int rfind(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_rfind(sub, start, end);
    }

    final int bytearray_rfind(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_rfind(sub, start, end);
    }

    public int rindex(PyObject sub) {
        return this.bytearray_rindex(sub, null, null);
    }

    public int rindex(PyObject sub, PyObject start) {
        return this.bytearray_rindex(sub, start, null);
    }

    public PyByteArray rjust(int width) {
        return (PyByteArray)this.basebytes_rjust(width, " ");
    }

    public PyByteArray rjust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_rjust(width, fillchar);
    }

    final PyByteArray bytearray_rjust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_rjust(width, fillchar);
    }

    public int rindex(PyObject sub, PyObject start, PyObject end) {
        return this.bytearray_rindex(sub, start, end);
    }

    final int bytearray_rindex(PyObject sub, PyObject start, PyObject end) {
        int pos = this.basebytes_rfind(sub, start, end);
        if (pos < 0) {
            throw Py.ValueError("subsection not found");
        }
        return pos;
    }

    final PyTuple bytearray_rpartition(PyObject sep) {
        return this.basebytes_rpartition(sep);
    }

    final PyList bytearray_rsplit(PyObject sep, int maxsplit) {
        return this.basebytes_rsplit(sep, maxsplit);
    }

    public PyByteArray rstrip() {
        return this.bytearray_rstrip(null);
    }

    public PyByteArray rstrip(PyObject bytes) {
        return this.bytearray_rstrip(bytes);
    }

    final synchronized PyByteArray bytearray_rstrip(PyObject bytes) {
        int right;
        if (bytes == null || bytes == Py.None) {
            right = this.rstripIndex();
        } else {
            BaseBytes.ByteSet byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes));
            right = this.rstripIndex(byteSet);
        }
        return this.getslice(0, right);
    }

    final PyList bytearray_split(PyObject sep, int maxsplit) {
        return this.basebytes_split(sep, maxsplit);
    }

    final PyList bytearray_splitlines(boolean keepends) {
        return this.basebytes_splitlines(keepends);
    }

    public boolean startswith(PyObject prefix) {
        return this.basebytes_starts_or_endswith(prefix, null, null, false);
    }

    public boolean startswith(PyObject prefix, PyObject start) {
        return this.basebytes_starts_or_endswith(prefix, start, null, false);
    }

    public boolean startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(prefix, start, end, false);
    }

    final boolean bytearray_startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(prefix, start, end, false);
    }

    public PyByteArray strip() {
        return this.bytearray_strip(null);
    }

    public PyByteArray strip(PyObject bytes) {
        return this.bytearray_strip(bytes);
    }

    final synchronized PyByteArray bytearray_strip(PyObject bytes) {
        BaseBytes.ByteSet byteSet;
        int left;
        int right = bytes == null || bytes == Py.None ? ((left = this.lstripIndex()) == this.size ? this.size : this.rstripIndex()) : ((left = this.lstripIndex(byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes)))) == this.size ? this.size : this.rstripIndex(byteSet));
        return this.getslice(left, right);
    }

    final synchronized void bytearray___setitem__(PyObject index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    @Override
    public String toString() {
        return this.bytearray_repr();
    }

    final synchronized String bytearray_repr() {
        return this.basebytes_repr("bytearray(b", ")");
    }

    @Override
    public PyString __str__() {
        return this.bytearray_str();
    }

    final PyString bytearray_str() {
        return new PyString(this.asString());
    }

    public PyByteArray translate(PyObject table) {
        return this.bytearray_translate(table, null);
    }

    public PyByteArray translate(PyObject table, PyObject deletechars) {
        return this.bytearray_translate(table, deletechars);
    }

    final PyByteArray bytearray_translate(PyObject table, PyObject deletechars) {
        try (PyBuffer tab = this.getTranslationTable(table);){
            PyByteArray result2 = new PyByteArray();
            if (deletechars != null) {
                try (PyBuffer d = PyByteArray.getViewOrError(deletechars);){
                    BaseBytes.ByteSet del = new BaseBytes.ByteSet(d);
                    int limit = this.offset + this.size;
                    if (tab == null) {
                        for (int i = this.offset; i < limit; ++i) {
                            int b = this.storage[i] & 0xFF;
                            if (del.contains(b)) continue;
                            result2.append((byte)b);
                        }
                    }
                    for (int i = this.offset; i < limit; ++i) {
                        int b = this.storage[i] & 0xFF;
                        if (del.contains(b)) continue;
                        result2.append(tab.byteAt(b));
                    }
                }
            } else if (tab == null) {
                result2.extend(this);
            } else {
                int limit = this.offset + this.size;
                for (int i = this.offset; i < limit; ++i) {
                    int b = this.storage[i] & 0xFF;
                    result2.append(tab.byteAt(b));
                }
            }
            PyByteArray pyByteArray = result2;
            return pyByteArray;
        }
    }

    private PyBuffer getTranslationTable(PyObject table) throws PyException {
        PyBuffer tab = null;
        if (table != null && table != Py.None && (tab = PyByteArray.getViewOrError(table)).getLen() != 256) {
            throw Py.ValueError("translation table must be 256 bytes long");
        }
        return tab;
    }

    public PyByteArray zfill(int width) {
        return (PyByteArray)this.basebytes_zfill(width);
    }

    final PyByteArray bytearray_zfill(int width) {
        return (PyByteArray)this.basebytes_zfill(width);
    }

    private final int recLength(int needed) {
        int L = this.storage.length;
        if (needed > L || needed * 2 < L) {
            return PyByteArray.roundUp(needed);
        }
        return L;
    }

    @Override
    protected void newStorage(int needed) {
        if (needed > 0) {
            int L = this.recLength(needed);
            try {
                byte[] s = new byte[L];
                this.setStorage(s, needed, (L - needed) / 2);
            }
            catch (OutOfMemoryError e) {
                throw Py.MemoryError(e.getMessage());
            }
        } else {
            this.setStorage(emptyStorage);
        }
    }

    private void storageReplace(int a, int d, int e) {
        int b = this.size - (a + d);
        int c = e - d;
        if (c == 0) {
            return;
        }
        if (c > 0 && b == 0) {
            this.storageExtend(c);
            return;
        }
        this.resizeCheck();
        int L = this.storage.length;
        int f = this.offset;
        int s2 = a + e + b;
        int L2 = this.recLength(s2);
        if (L2 == L) {
            if (a <= b) {
                int f2 = f - c;
                if (f2 >= 0) {
                    if (a > 0) {
                        System.arraycopy(this.storage, f, this.storage, f2, a);
                    }
                    this.offset = f2;
                    this.size = s2;
                } else {
                    this.newStorageAvoided(a, d, b, e);
                }
            } else {
                int g2 = f + a + e;
                if (g2 + b <= L) {
                    if (b > 0) {
                        System.arraycopy(this.storage, g2 - c, this.storage, g2, b);
                    }
                    this.size = s2;
                } else {
                    this.newStorageAvoided(a, d, b, e);
                }
            }
        } else if (L2 > 0) {
            this.newStorage(L2, a, d, b, e);
        } else {
            this.setStorage(emptyStorage);
        }
    }

    private void newStorageAvoided(int a, int d, int b, int e) {
        int f2;
        int f = this.offset;
        int g = f + a + d;
        int s2 = a + e + b;
        if (a == b) {
            f2 = (this.storage.length - s2) / 2;
        } else {
            long spare = this.storage.length - s2;
            f2 = (int)(spare * (long)b / (long)(a + b));
        }
        int g2 = f2 + a + e;
        if (f2 + a > g) {
            if (b > 0) {
                System.arraycopy(this.storage, g, this.storage, g2, b);
            }
            if (a > 0) {
                System.arraycopy(this.storage, f, this.storage, f2, a);
            }
        } else {
            if (a > 0) {
                System.arraycopy(this.storage, f, this.storage, f2, a);
            }
            if (b > 0) {
                System.arraycopy(this.storage, g, this.storage, g2, b);
            }
        }
        this.size = s2;
        this.offset = f2;
    }

    private void newStorage(int L2, int a, int d, int b, int e) {
        int f2;
        int f = this.offset;
        int g = f + a + d;
        int s2 = a + e + b;
        byte[] newStorage = new byte[L2];
        if (a == b) {
            f2 = (L2 - s2) / 2;
        } else {
            long spare = L2 - s2;
            f2 = (int)(spare * (long)b / (long)(a + b));
        }
        if (a > 0) {
            System.arraycopy(this.storage, f, newStorage, f2, a);
        }
        if (b > 0) {
            System.arraycopy(this.storage, g, newStorage, f2 + a + e, b);
        }
        this.setStorage(newStorage, s2, f2);
    }

    private void storageExtend(int e) {
        if (e == 0) {
            return;
        }
        this.resizeCheck();
        int L = this.storage.length;
        int f = this.offset;
        int s2 = this.size + e;
        int L2 = this.recLength(s2);
        if (L2 <= L) {
            int g2 = f + s2;
            if (g2 > L) {
                if (this.size > 0) {
                    System.arraycopy(this.storage, this.offset, this.storage, 0, this.size);
                }
                this.offset = 0;
            }
            this.size = s2;
        } else {
            byte[] newStorage = new byte[L2];
            if (this.size > 0) {
                System.arraycopy(this.storage, f, newStorage, 0, this.size);
            }
            this.setStorage(newStorage, s2);
        }
    }

    private void storageDelete(int a, int d) {
        if (d == 0) {
            return;
        }
        this.resizeCheck();
        int L = this.storage.length;
        int f = this.offset;
        int b = this.size - (a + d);
        int s2 = a + b;
        int L2 = this.recLength(s2);
        if (L2 == L) {
            if (a <= b) {
                int f2 = f + d;
                if (a > 0) {
                    System.arraycopy(this.storage, f, this.storage, f2, a);
                }
                this.offset = f2;
                this.size = s2;
            } else {
                int g2 = f + a;
                if (b > 0) {
                    System.arraycopy(this.storage, g2 + d, this.storage, g2, b);
                }
                this.size = s2;
            }
        } else if (L2 > 0) {
            int g = f + a + d;
            int f2 = (L2 - s2) / 2;
            byte[] newStorage = new byte[L2];
            if (a > 0) {
                System.arraycopy(this.storage, f, newStorage, f2, a);
            }
            if (b > 0) {
                System.arraycopy(this.storage, g, newStorage, f2 + a, b);
            }
            this.setStorage(newStorage, s2, f2);
        } else {
            this.setStorage(emptyStorage);
        }
    }

    static {
        PyType.addBuilder(PyByteArray.class, new PyByteArray$PyExposer());
        TYPE = PyType.fromClass(PyByteArray.class);
    }

    public class PyByteArray$bytearray___init___exposer
    extends PyBuiltinMethod {
        public PyByteArray$bytearray___init___exposer(String string2) {
            super(string2);
            this.doc = "x.__init__(...) initializes x; see help(type(x)) for signature";
        }

        public PyByteArray$bytearray___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__init__(...) initializes x; see help(type(x)) for signature";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyByteArray)this.self).bytearray___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyByteArray$bytearray___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___ne___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__ne__(y) <==> x!=y";
        }

        public PyByteArray$bytearray___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ne__(y) <==> x!=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray___lt___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___lt___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__lt__(y) <==> x<y";
        }

        public PyByteArray$bytearray___lt___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__lt__(y) <==> x<y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___lt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___lt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___le___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__le__(y) <==> x<=y";
        }

        public PyByteArray$bytearray___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__le__(y) <==> x<=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___ge___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyByteArray$bytearray___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__ge__(y) <==> x>=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___gt___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__gt__(y) <==> x>y";
        }

        public PyByteArray$bytearray___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__gt__(y) <==> x>y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray___alloc___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___alloc___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "B.__alloc__() -> int\n\nReturns the number of bytes actually allocated.";
        }

        public PyByteArray$bytearray___alloc___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.__alloc__() -> int\n\nReturns the number of bytes actually allocated.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___alloc___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyByteArray)this.self).bytearray___alloc__());
        }
    }

    public class PyByteArray$bytearray___imul___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___imul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__imul__(y) <==> x*=y";
        }

        public PyByteArray$bytearray___imul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__imul__(y) <==> x*=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___imul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___imul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___mul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__mul__(n) <==> x*n";
        }

        public PyByteArray$bytearray___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mul__(n) <==> x*n";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___rmul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rmul__(n) <==> n*x";
        }

        public PyByteArray$bytearray___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rmul__(n) <==> n*x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray_append_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_append_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "B.append(int) -> None\n\nAppend a single item to the end of B.";
        }

        public PyByteArray$bytearray_append_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.append(int) -> None\n\nAppend a single item to the end of B.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_append_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyByteArray)this.self).bytearray_append(pyObject);
            return Py.None;
        }
    }

    public class PyByteArray$bytearray___contains___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___contains___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__contains__(y) <==> y in x";
        }

        public PyByteArray$bytearray___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__contains__(y) <==> y in x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___contains___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyByteArray)this.self).bytearray___contains__(pyObject));
        }
    }

    public class PyByteArray$bytearray_decode_exposer
    extends PyBuiltinMethod {
        public PyByteArray$bytearray_decode_exposer(String string2) {
            super(string2);
            this.doc = "B.decode([encoding[, errors]]) -> unicode object.\n\nDecodes B using the codec registered for encoding. encoding defaults\nto the default encoding. errors may be given to set a different error\nhandling scheme.  Default is 'strict' meaning that encoding errors raise\na UnicodeDecodeError.  Other possible values are 'ignore' and 'replace'\nas well as any other name registered with codecs.register_error that is\nable to handle UnicodeDecodeErrors.";
        }

        public PyByteArray$bytearray_decode_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.decode([encoding[, errors]]) -> unicode object.\n\nDecodes B using the codec registered for encoding. encoding defaults\nto the default encoding. errors may be given to set a different error\nhandling scheme.  Default is 'strict' meaning that encoding errors raise\na UnicodeDecodeError.  Other possible values are 'ignore' and 'replace'\nas well as any other name registered with codecs.register_error that is\nable to handle UnicodeDecodeErrors.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_decode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyByteArray)this.self).bytearray_decode(pyObjectArray, stringArray);
        }
    }

    public class PyByteArray$bytearray_center_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_center_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "B.center(width[, fillchar]) -> copy of B\n\nReturn B centered in a string of length width.  Padding is\ndone using the specified fill character (default is a space).";
        }

        public PyByteArray$bytearray_center_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.center(width[, fillchar]) -> copy of B\n\nReturn B centered in a string of length width.  Padding is\ndone using the specified fill character (default is a space).";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_center_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyByteArray)this.self).bytearray_center(Py.py2int(pyObject), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyByteArray)this.self).bytearray_center(Py.py2int(pyObject), null);
        }
    }

    public class PyByteArray$bytearray_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_count_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "B.count(sub [,start [,end]]) -> int\n\nReturn the number of non-overlapping occurrences of subsection sub in\nbytes B[start:end].  Optional arguments start and end are interpreted\nas in slice notation.";
        }

        public PyByteArray$bytearray_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.count(sub [,start [,end]]) -> int\n\nReturn the number of non-overlapping occurrences of subsection sub in\nbytes B[start:end].  Optional arguments start and end are interpreted\nas in slice notation.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_count(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_count(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_count(pyObject, null, null));
        }
    }

    public class PyByteArray$bytearray_endswith_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_endswith_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "B.endswith(suffix [,start [,end]]) -> bool\n\nReturn True if B ends with the specified suffix, False otherwise.\nWith optional start, test B beginning at that position.\nWith optional end, stop comparing B at that position.\nsuffix can also be a tuple of strings to try.";
        }

        public PyByteArray$bytearray_endswith_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.endswith(suffix [,start [,end]]) -> bool\n\nReturn True if B ends with the specified suffix, False otherwise.\nWith optional start, test B beginning at that position.\nWith optional end, stop comparing B at that position.\nsuffix can also be a tuple of strings to try.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_endswith_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((PyByteArray)this.self).bytearray_endswith(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newBoolean(((PyByteArray)this.self).bytearray_endswith(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyByteArray)this.self).bytearray_endswith(pyObject, null, null));
        }
    }

    public class PyByteArray$bytearray_expandtabs_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_expandtabs_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "B.expandtabs([tabsize]) -> copy of B\n\nReturn a copy of B where all tab characters are expanded using spaces.\nIf tabsize is not given, a tab size of 8 characters is assumed.";
        }

        public PyByteArray$bytearray_expandtabs_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.expandtabs([tabsize]) -> copy of B\n\nReturn a copy of B where all tab characters are expanded using spaces.\nIf tabsize is not given, a tab size of 8 characters is assumed.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_expandtabs_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyByteArray)this.self).bytearray_expandtabs(Py.py2int(pyObject));
        }

        public PyObject __call__() {
            return ((PyByteArray)this.self).bytearray_expandtabs(8);
        }
    }

    public class PyByteArray$bytearray_extend_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_extend_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "B.extend(iterable int) -> None\n\nAppend all the elements from the iterator or sequence to the\nend of B.";
        }

        public PyByteArray$bytearray_extend_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.extend(iterable int) -> None\n\nAppend all the elements from the iterator or sequence to the\nend of B.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_extend_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyByteArray)this.self).bytearray_extend(pyObject);
            return Py.None;
        }
    }

    public class PyByteArray$bytearray_find_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_find_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "B.find(sub [,start [,end]]) -> int\n\nReturn the lowest index in B where subsection sub is found,\nsuch that sub is contained within s[start,end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyByteArray$bytearray_find_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.find(sub [,start [,end]]) -> int\n\nReturn the lowest index in B where subsection sub is found,\nsuch that sub is contained within s[start,end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_find_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_find(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_find(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_find(pyObject, null, null));
        }
    }

    public class PyByteArray$bytearray_fromhex_exposer
    extends PyBuiltinClassMethodNarrow {
        public PyByteArray$bytearray_fromhex_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "bytearray.fromhex(string) -> bytearray\n\nCreate a bytearray object from a string of hexadecimal numbers.\nSpaces between two numbers are accepted.\nExample: bytearray.fromhex('B9 01EF') -> bytearray(b'\\xb9\\x01\\xef').";
        }

        public PyByteArray$bytearray_fromhex_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "bytearray.fromhex(string) -> bytearray\n\nCreate a bytearray object from a string of hexadecimal numbers.\nSpaces between two numbers are accepted.\nExample: bytearray.fromhex('B9 01EF') -> bytearray(b'\\xb9\\x01\\xef').";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_fromhex_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return PyByteArray.bytearray_fromhex((PyType)this.self, pyObject.asString());
        }
    }

    public class PyByteArray$bytearray___iadd___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___iadd___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__iadd__(y) <==> x+=y";
        }

        public PyByteArray$bytearray___iadd___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__iadd__(y) <==> x+=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___iadd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyByteArray)this.self).bytearray___iadd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyByteArray$bytearray___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___hash___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyByteArray$bytearray___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyByteArray)this.self).bytearray___hash__());
        }
    }

    public class PyByteArray$bytearray_index_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_index_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "B.index(sub [,start [,end]]) -> int\n\nLike B.find() but raise ValueError when the subsection is not found.";
        }

        public PyByteArray$bytearray_index_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.index(sub [,start [,end]]) -> int\n\nLike B.find() but raise ValueError when the subsection is not found.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_index_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_index(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_index(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_index(pyObject, null, null));
        }
    }

    public class PyByteArray$bytearray_insert_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_insert_exposer(String string2) {
            super(string2, 3, 3);
            this.doc = "B.insert(index, int) -> None\n\nInsert a single item into the bytearray before the given index.";
        }

        public PyByteArray$bytearray_insert_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.insert(index, int) -> None\n\nInsert a single item into the bytearray before the given index.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_insert_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyByteArray)this.self).bytearray_insert(pyObject, pyObject2);
            return Py.None;
        }
    }

    public class PyByteArray$bytearray_isalnum_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_isalnum_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "B.isalnum() -> bool\n\nReturn True if all characters in B are alphanumeric\nand there is at least one character in B, False otherwise.";
        }

        public PyByteArray$bytearray_isalnum_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.isalnum() -> bool\n\nReturn True if all characters in B are alphanumeric\nand there is at least one character in B, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_isalnum_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyByteArray)this.self).bytearray_isalnum());
        }
    }

    public class PyByteArray$bytearray_islower_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_islower_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "B.islower() -> bool\n\nReturn True if all cased characters in B are lowercase and there is\nat least one cased character in B, False otherwise.";
        }

        public PyByteArray$bytearray_islower_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.islower() -> bool\n\nReturn True if all cased characters in B are lowercase and there is\nat least one cased character in B, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_islower_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyByteArray)this.self).bytearray_islower());
        }
    }

    public class PyByteArray$bytearray_isspace_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_isspace_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "B.isspace() -> bool\n\nReturn True if all characters in B are whitespace\nand there is at least one character in B, False otherwise.";
        }

        public PyByteArray$bytearray_isspace_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.isspace() -> bool\n\nReturn True if all characters in B are whitespace\nand there is at least one character in B, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_isspace_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyByteArray)this.self).bytearray_isspace());
        }
    }

    public class PyByteArray$bytearray_istitle_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_istitle_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "B.istitle() -> bool\n\nReturn True if B is a titlecased string and there is at least one\ncharacter in B, i.e. uppercase characters may only follow uncased\ncharacters and lowercase characters only cased ones. Return False\notherwise.";
        }

        public PyByteArray$bytearray_istitle_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.istitle() -> bool\n\nReturn True if B is a titlecased string and there is at least one\ncharacter in B, i.e. uppercase characters may only follow uncased\ncharacters and lowercase characters only cased ones. Return False\notherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_istitle_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyByteArray)this.self).bytearray_istitle());
        }
    }

    public class PyByteArray$bytearray_isupper_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_isupper_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "B.isupper() -> bool\n\nReturn True if all cased characters in B are uppercase and there is\nat least one cased character in B, False otherwise.";
        }

        public PyByteArray$bytearray_isupper_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.isupper() -> bool\n\nReturn True if all cased characters in B are uppercase and there is\nat least one cased character in B, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_isupper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyByteArray)this.self).bytearray_isupper());
        }
    }

    public class PyByteArray$bytearray_capitalize_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_capitalize_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "B.capitalize() -> copy of B\n\nReturn a copy of B with only its first character capitalized (ASCII)\nand the rest lower-cased.";
        }

        public PyByteArray$bytearray_capitalize_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.capitalize() -> copy of B\n\nReturn a copy of B with only its first character capitalized (ASCII)\nand the rest lower-cased.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_capitalize_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyByteArray)this.self).bytearray_capitalize();
        }
    }

    public class PyByteArray$bytearray_lower_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_lower_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "B.lower() -> copy of B\n\nReturn a copy of B with all ASCII characters converted to lowercase.";
        }

        public PyByteArray$bytearray_lower_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.lower() -> copy of B\n\nReturn a copy of B with all ASCII characters converted to lowercase.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_lower_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyByteArray)this.self).bytearray_lower();
        }
    }

    public class PyByteArray$bytearray___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___len___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyByteArray$bytearray___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyByteArray)this.self).bytearray___len__());
        }
    }

    public class PyByteArray$bytearray_ljust_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_ljust_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "B.ljust(width[, fillchar]) -> copy of B\n\nReturn B left justified in a string of length width. Padding is\ndone using the specified fill character (default is a space).";
        }

        public PyByteArray$bytearray_ljust_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.ljust(width[, fillchar]) -> copy of B\n\nReturn B left justified in a string of length width. Padding is\ndone using the specified fill character (default is a space).";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_ljust_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyByteArray)this.self).bytearray_ljust(Py.py2int(pyObject), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyByteArray)this.self).bytearray_ljust(Py.py2int(pyObject), null);
        }
    }

    public class PyByteArray$bytearray_lstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_lstrip_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "B.lstrip([bytes]) -> bytearray\n\nStrip leading bytes contained in the argument.\nIf the argument is omitted, strip leading ASCII whitespace.";
        }

        public PyByteArray$bytearray_lstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.lstrip([bytes]) -> bytearray\n\nStrip leading bytes contained in the argument.\nIf the argument is omitted, strip leading ASCII whitespace.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_lstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyByteArray)this.self).bytearray_lstrip(pyObject);
        }

        public PyObject __call__() {
            return ((PyByteArray)this.self).bytearray_lstrip(null);
        }
    }

    public class PyByteArray$bytearray_partition_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_partition_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "B.partition(sep) -> (head, sep, tail)\n\nSearches for the separator sep in B, and returns the part before it,\nthe separator itself, and the part after it.  If the separator is not\nfound, returns B and two empty bytearray objects.";
        }

        public PyByteArray$bytearray_partition_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.partition(sep) -> (head, sep, tail)\n\nSearches for the separator sep in B, and returns the part before it,\nthe separator itself, and the part after it.  If the separator is not\nfound, returns B and two empty bytearray objects.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_partition_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyByteArray)this.self).bytearray_partition(pyObject);
        }
    }

    public class PyByteArray$bytearray___reduce___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___reduce___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Return state information for pickling.";
        }

        public PyByteArray$bytearray___reduce___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Return state information for pickling.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___reduce___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyByteArray)this.self).bytearray___reduce__();
        }
    }

    public class PyByteArray$bytearray_remove_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_remove_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "B.remove(int) -> None\n\nRemove the first occurance of a value in B.";
        }

        public PyByteArray$bytearray_remove_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.remove(int) -> None\n\nRemove the first occurance of a value in B.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_remove_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyByteArray)this.self).bytearray_remove(pyObject);
            return Py.None;
        }
    }

    public class PyByteArray$bytearray_replace_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_replace_exposer(String string2) {
            super(string2, 3, 4);
            this.doc = "B.replace(old, new[, count]) -> bytes\n\nReturn a copy of B with all occurrences of subsection\nold replaced by new.  If the optional argument count is\ngiven, only the first count occurrences are replaced.";
        }

        public PyByteArray$bytearray_replace_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.replace(old, new[, count]) -> bytes\n\nReturn a copy of B with all occurrences of subsection\nold replaced by new.  If the optional argument count is\ngiven, only the first count occurrences are replaced.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_replace_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyByteArray)this.self).bytearray_replace(pyObject, pyObject2, pyObject3);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyByteArray)this.self).bytearray_replace(pyObject, pyObject2, null);
        }
    }

    public class PyByteArray$bytearray_rfind_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_rfind_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "B.rfind(sub [,start [,end]]) -> int\n\nReturn the highest index in B where subsection sub is found,\nsuch that sub is contained within s[start,end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyByteArray$bytearray_rfind_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.rfind(sub [,start [,end]]) -> int\n\nReturn the highest index in B where subsection sub is found,\nsuch that sub is contained within s[start,end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_rfind_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_rfind(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_rfind(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_rfind(pyObject, null, null));
        }
    }

    public class PyByteArray$bytearray_rindex_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_rindex_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "B.rindex(sub [,start [,end]]) -> int\n\nLike B.rfind() but raise ValueError when the subsection is not found.";
        }

        public PyByteArray$bytearray_rindex_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.rindex(sub [,start [,end]]) -> int\n\nLike B.rfind() but raise ValueError when the subsection is not found.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_rindex_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_rindex(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_rindex(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyByteArray)this.self).bytearray_rindex(pyObject, null, null));
        }
    }

    public class PyByteArray$bytearray_rsplit_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_rsplit_exposer(String string2) {
            super(string2, 1, 3);
            this.doc = "B.rsplit(sep[, maxsplit]) -> list of bytearray\n\nReturn a list of the sections in B, using sep as the delimiter,\nstarting at the end of B and working to the front.\nIf sep is not given, B is split on ASCII whitespace characters\n(space, tab, return, newline, formfeed, vertical tab).\nIf maxsplit is given, at most maxsplit splits are done.";
        }

        public PyByteArray$bytearray_rsplit_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.rsplit(sep[, maxsplit]) -> list of bytearray\n\nReturn a list of the sections in B, using sep as the delimiter,\nstarting at the end of B and working to the front.\nIf sep is not given, B is split on ASCII whitespace characters\n(space, tab, return, newline, formfeed, vertical tab).\nIf maxsplit is given, at most maxsplit splits are done.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_rsplit_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyByteArray)this.self).bytearray_rsplit(pyObject, Py.py2int(pyObject2));
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyByteArray)this.self).bytearray_rsplit(pyObject, -1);
        }

        public PyObject __call__() {
            return ((PyByteArray)this.self).bytearray_rsplit(null, -1);
        }
    }

    public class PyByteArray$bytearray_rstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray_rstrip_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "B.rstrip([bytes]) -> bytearray\n\nStrip trailing bytes contained in the argument.\nIf the argument is omitted, strip trailing ASCII whitespace.";
        }

        public PyByteArray$bytearray_rstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "B.rstrip([bytes]) -> bytearray\n\nStrip trailing bytes contained in the argument.\nIf the argument is omitted, strip trailing ASCII whitespace.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray_rstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyByteArray)this.self).bytearray_rstrip(pyObject);
        }

        public PyObject __call__() {
            return ((PyByteArray)this.self).bytearray_rstrip(null);
        }
    }

    public class PyByteArray$bytearray___setitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyByteArray$bytearray___setitem___exposer(String string2) {
            super(string2, 3, 3);
            this.doc = "x.__setitem__(i, y) <==> x[i]=y";
        }

        public PyByteArray$bytearray___setitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__setitem__(i, y) <==> x[i]=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyByteArray$bytearray___setitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyByteArray)this.self).bytearray___setitem__(pyObject, pyObject2);
            return Py.None;
        }
    }

    public class PyByteArray$PyExposer
    extends BaseTypeBuilder {
        public PyByteArray$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyByteArray$bytearray___init___exposer("__init__"), new PyByteArray$bytearray___eq___exposer("__eq__"), new PyByteArray$bytearray___ne___exposer("__ne__"), new PyByteArray$bytearray___lt___exposer("__lt__"), new PyByteArray$bytearray___le___exposer("__le__"), new PyByteArray$bytearray___ge___exposer("__ge__"), new PyByteArray$bytearray___gt___exposer("__gt__"), new PyByteArray$bytearray___add___exposer("__add__"), new PyByteArray$bytearray___alloc___exposer("__alloc__"), new PyByteArray$bytearray___imul___exposer("__imul__"), new PyByteArray$bytearray___mul___exposer("__mul__"), new PyByteArray$bytearray___rmul___exposer("__rmul__"), new PyByteArray$bytearray_append_exposer("append"), new PyByteArray$bytearray___contains___exposer("__contains__"), new PyByteArray$bytearray_decode_exposer("decode"), new PyByteArray$bytearray_center_exposer("center"), new PyByteArray$bytearray_count_exposer("count"), new PyByteArray$bytearray_endswith_exposer("endswith"), new PyByteArray$bytearray_expandtabs_exposer("expandtabs"), new PyByteArray$bytearray_extend_exposer("extend"), new PyByteArray$bytearray_find_exposer("find"), new PyByteArray$bytearray_fromhex_exposer("fromhex"), new PyByteArray$bytearray___getitem___exposer("__getitem__"), new PyByteArray$bytearray___iadd___exposer("__iadd__"), new PyByteArray$bytearray___hash___exposer("__hash__"), new PyByteArray$bytearray_index_exposer("index"), new PyByteArray$bytearray_insert_exposer("insert"), new PyByteArray$bytearray_isalnum_exposer("isalnum"), new PyByteArray$bytearray_isalpha_exposer("isalpha"), new PyByteArray$bytearray_isdigit_exposer("isdigit"), new PyByteArray$bytearray_islower_exposer("islower"), new PyByteArray$bytearray_isspace_exposer("isspace"), new PyByteArray$bytearray_istitle_exposer("istitle"), new PyByteArray$bytearray_isupper_exposer("isupper"), new PyByteArray$bytearray_capitalize_exposer("capitalize"), new PyByteArray$bytearray_lower_exposer("lower"), new PyByteArray$bytearray_swapcase_exposer("swapcase"), new PyByteArray$bytearray_title_exposer("title"), new PyByteArray$bytearray_upper_exposer("upper"), new PyByteArray$bytearray_join_exposer("join"), new PyByteArray$bytearray___len___exposer("__len__"), new PyByteArray$bytearray_ljust_exposer("ljust"), new PyByteArray$bytearray_lstrip_exposer("lstrip"), new PyByteArray$bytearray_partition_exposer("partition"), new PyByteArray$bytearray_pop_exposer("pop"), new PyByteArray$bytearray___reduce___exposer("__reduce__"), new PyByteArray$bytearray_remove_exposer("remove"), new PyByteArray$bytearray_replace_exposer("replace"), new PyByteArray$bytearray_reverse_exposer("reverse"), new PyByteArray$bytearray_rfind_exposer("rfind"), new PyByteArray$bytearray_rjust_exposer("rjust"), new PyByteArray$bytearray_rindex_exposer("rindex"), new PyByteArray$bytearray_rpartition_exposer("rpartition"), new PyByteArray$bytearray_rsplit_exposer("rsplit"), new PyByteArray$bytearray_rstrip_exposer("rstrip"), new PyByteArray$bytearray_split_exposer("split"), new PyByteArray$bytearray_splitlines_exposer("splitlines"), new PyByteArray$bytearray_startswith_exposer("startswith"), new PyByteArray$bytearray_strip_exposer("strip"), new PyByteArray$bytearray___setitem___exposer("__setitem__"), new PyByteArray$bytearray_repr_exposer("__repr__"), new PyByteArray$bytearray_str_exposer("__str__"), new PyByteArray$bytearray_translate_exposer("translate"), new PyByteArray$bytearray_zfill_exposer("zfill")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("bytearray", PyByteArray.class, PyObject.class, true, "bytearray(iterable_of_ints) -> bytearray.\nbytearray(string, encoding[, errors]) -> bytearray.\nbytearray(bytes_or_bytearray) -> mutable copy of bytes_or_bytearray.\nbytearray(memory_view) -> bytearray.\n\nConstruct an mutable bytearray object from:\n  - an iterable yielding integers in range(256)\n  - a text string encoded using the specified encoding\n  - a bytes or a bytearray object\n  - any object implementing the buffer API.\n\nbytearray(int) -> bytearray.\n\nConstruct a zero-initialized bytearray of the given length.", pyBuiltinMethodArray, pyDataDescrArray, new PyByteArray$exposed___new__());
        }
    }
}

