/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyProperty$exposed___new__;
import org.python.core.PyProperty$fget_descriptor;
import org.python.core.PyProperty$property___delete___exposer;
import org.python.core.PyProperty$property___init___exposer;
import org.python.core.PyProperty$property_getter_exposer;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="property", doc="property(fget=None, fset=None, fdel=None, doc=None) -> property attribute\n\nfget is a function to be used for getting an attribute value, and likewise\nfset is a function for setting, and fdel a function for del'ing, an\nattribute.  Typical use is to define a managed attribute x:\nclass C(object):\n    def getx(self): return self._x\n    def setx(self, value): self._x = value\n    def delx(self): del self._x\n    x = property(getx, setx, delx, \"I'm the 'x' property.\")\n\nDecorators make defining new properties or modifying existing ones easy:\nclass C(object):\n    @property\n    def x(self): return self._x\n    @x.setter\n    def x(self, value): self._x = value\n    @x.deleter\n    def x(self): del self._x\n")
public class PyProperty
extends PyObject
implements Traverseproc {
    public static final PyType TYPE;
    protected PyObject fget;
    protected PyObject fset;
    protected PyObject fdel;
    protected boolean docFromGetter;
    protected PyObject doc;

    public PyProperty() {
        this(TYPE);
    }

    public PyProperty(PyType subType) {
        super(subType);
    }

    @ExposedNew
    public void property___init__(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("property", args, keywords, new String[]{"fget", "fset", "fdel", "doc"}, 0);
        this.fget = ap.getPyObject(0, null);
        this.fget = this.fget == Py.None ? null : this.fget;
        this.fset = ap.getPyObject(1, null);
        this.fset = this.fset == Py.None ? null : this.fset;
        this.fdel = ap.getPyObject(2, null);
        this.fdel = this.fdel == Py.None ? null : this.fdel;
        this.doc = ap.getPyObject(3, null);
        if ((this.doc == null || this.doc == Py.None) && this.fget != null) {
            PyObject getDoc = this.fget.__findattr__("__doc__");
            if (this.getType() == TYPE) {
                this.doc = getDoc;
            } else {
                this.__setattr__("__doc__", getDoc);
            }
            this.docFromGetter = true;
        }
    }

    @Override
    public PyObject __call__(PyObject arg1, PyObject[] args, String[] keywords) {
        return this.fget.__call__(arg1);
    }

    @Override
    public PyObject __get__(PyObject obj, PyObject type) {
        return this.property___get__(obj, type);
    }

    final PyObject property___get__(PyObject obj, PyObject type) {
        if (obj == null || obj == Py.None) {
            return this;
        }
        if (this.fget == null) {
            throw Py.AttributeError("unreadable attribute");
        }
        return this.fget.__call__(obj);
    }

    @Override
    public void __set__(PyObject obj, PyObject value) {
        this.property___set__(obj, value);
    }

    final void property___set__(PyObject obj, PyObject value) {
        if (this.fset == null) {
            throw Py.AttributeError("can't set attribute");
        }
        this.fset.__call__(obj, value);
    }

    @Override
    public void __delete__(PyObject obj) {
        this.property___delete__(obj);
    }

    final void property___delete__(PyObject obj) {
        if (this.fdel == null) {
            throw Py.AttributeError("can't delete attribute");
        }
        this.fdel.__call__(obj);
    }

    public PyObject getter(PyObject getter) {
        return this.property_getter(getter);
    }

    final PyObject property_getter(PyObject getter) {
        return this.propertyCopy(getter, null, null);
    }

    public PyObject setter(PyObject setter) {
        return this.property_setter(setter);
    }

    final PyObject property_setter(PyObject setter) {
        return this.propertyCopy(null, setter, null);
    }

    public PyObject deleter(PyObject deleter) {
        return this.property_deleter(deleter);
    }

    final PyObject property_deleter(PyObject deleter) {
        return this.propertyCopy(null, null, deleter);
    }

    private PyObject propertyCopy(PyObject get, PyObject set, PyObject del) {
        if (get == null) {
            PyObject pyObject = get = this.fget != null ? this.fget : Py.None;
        }
        if (set == null) {
            PyObject pyObject = set = this.fset != null ? this.fset : Py.None;
        }
        if (del == null) {
            PyObject pyObject = del = this.fdel != null ? this.fdel : Py.None;
        }
        PyObject doc = this.docFromGetter ? Py.None : (this.doc != null ? this.doc : Py.None);
        return this.getType().__call__(get, set, del, doc);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.fget != null && (retVal = visit.visit(this.fget, arg)) != 0) {
            return retVal;
        }
        if (this.fset != null && (retVal = visit.visit(this.fset, arg)) != 0) {
            return retVal;
        }
        if (this.fdel != null && (retVal = visit.visit(this.fdel, arg)) != 0) {
            return retVal;
        }
        return this.doc == null ? 0 : visit.visit(this.doc, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.fget || ob == this.fset || ob == this.fdel || ob == this.doc);
    }

    static {
        PyType.addBuilder(PyProperty.class, new PyProperty$PyExposer());
        TYPE = PyType.fromClass(PyProperty.class);
    }

    public class PyProperty$property___get___exposer
    extends PyBuiltinMethodNarrow {
        public PyProperty$property___get___exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "descr.__get__(obj[, type]) -> value";
        }

        public PyProperty$property___get___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "descr.__get__(obj[, type]) -> value";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyProperty$property___get___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyProperty)this.self).property___get__(pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyProperty)this.self).property___get__(pyObject, null);
        }
    }

    public class PyProperty$property___set___exposer
    extends PyBuiltinMethodNarrow {
        public PyProperty$property___set___exposer(String string2) {
            super(string2, 3, 3);
            this.doc = "descr.__set__(obj, value)";
        }

        public PyProperty$property___set___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "descr.__set__(obj, value)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyProperty$property___set___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyProperty)this.self).property___set__(pyObject, pyObject2);
            return Py.None;
        }
    }

    public class PyProperty$property_setter_exposer
    extends PyBuiltinMethodNarrow {
        public PyProperty$property_setter_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "Descriptor to change the setter on a property.";
        }

        public PyProperty$property_setter_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Descriptor to change the setter on a property.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyProperty$property_setter_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyProperty)this.self).property_setter(pyObject);
        }
    }

    public class PyProperty$property_deleter_exposer
    extends PyBuiltinMethodNarrow {
        public PyProperty$property_deleter_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "Descriptor to change the deleter on a property.";
        }

        public PyProperty$property_deleter_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Descriptor to change the deleter on a property.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyProperty$property_deleter_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyProperty)this.self).property_deleter(pyObject);
        }
    }

    public class PyProperty$__doc___descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyProperty$__doc___descriptor() {
            super("__doc__", PyObject.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyProperty)pyObject).doc;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyProperty$fdel_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyProperty$fdel_descriptor() {
            super("fdel", PyObject.class, "");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyProperty)pyObject).fdel;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyProperty$fset_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyProperty$fset_descriptor() {
            super("fset", PyObject.class, "");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyProperty)pyObject).fset;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyProperty$PyExposer
    extends BaseTypeBuilder {
        public PyProperty$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyProperty$property___init___exposer("__init__"), new PyProperty$property___get___exposer("__get__"), new PyProperty$property___set___exposer("__set__"), new PyProperty$property___delete___exposer("__delete__"), new PyProperty$property_getter_exposer("getter"), new PyProperty$property_setter_exposer("setter"), new PyProperty$property_deleter_exposer("deleter")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyProperty$__doc___descriptor(), new PyProperty$fdel_descriptor(), new PyProperty$fset_descriptor(), new PyProperty$fget_descriptor()};
            super("property", PyProperty.class, Object.class, true, "property(fget=None, fset=None, fdel=None, doc=None) -> property attribute\n\nfget is a function to be used for getting an attribute value, and likewise\nfset is a function for setting, and fdel a function for del'ing, an\nattribute.  Typical use is to define a managed attribute x:\nclass C(object):\n    def getx(self): return self._x\n    def setx(self, value): self._x = value\n    def delx(self): del self._x\n    x = property(getx, setx, delx, \"I'm the 'x' property.\")\n\nDecorators make defining new properties or modifying existing ones easy:\nclass C(object):\n    @property\n    def x(self): return self._x\n    @x.setter\n    def x(self, value): self._x = value\n    @x.deleter\n    def x(self): del self._x\n", pyBuiltinMethodArray, pyDataDescrArray, new PyProperty$exposed___new__());
        }
    }
}

