/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode$exposed___new__;
import org.python.core.PyUnicode$unicode___add___exposer;
import org.python.core.PyUnicode$unicode___cmp___exposer;
import org.python.core.PyUnicode$unicode___contains___exposer;
import org.python.core.PyUnicode$unicode___eq___exposer;
import org.python.core.PyUnicode$unicode___format___exposer;
import org.python.core.PyUnicode$unicode_isalpha_exposer;
import org.python.core.PyUnicode$unicode_isdecimal_exposer;
import org.python.core.PyUnicode$unicode_islower_exposer;
import org.python.core.PyUnicode$unicode_isspace_exposer;
import org.python.core.PyUnicode$unicode_istitle_exposer;
import org.python.core.PyUnicode$unicode_isunicode_exposer;
import org.python.core.PyUnicode$unicode_ljust_exposer;
import org.python.core.PyUnicode$unicode_lower_exposer;
import org.python.core.PyUnicode$unicode_replace_exposer;
import org.python.core.PyUnicode$unicode_rfind_exposer;
import org.python.core.PyUnicode$unicode_rindex_exposer;
import org.python.core.PyUnicode$unicode_rpartition_exposer;
import org.python.core.PyUnicode$unicode_rsplit_exposer;
import org.python.core.PyUnicode$unicode_rstrip_exposer;
import org.python.core.PyUnicode$unicode_split_exposer;
import org.python.core.PyUnicode$unicode_splitlines_exposer;
import org.python.core.PyUnicode$unicode_startswith_exposer;
import org.python.core.PyUnicode$unicode_strip_exposer;
import org.python.core.PyUnicode$unicode_title_exposer;
import org.python.core.PyUnicode$unicode_translate_exposer;
import org.python.core.PyUnicodeDerived;
import org.python.core.StringFormatter;
import org.python.core.Untraversable;
import org.python.core.codecs;
import org.python.core.stringlib.FieldNameIterator;
import org.python.core.stringlib.MarkupIterator;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.google.common.base.CharMatcher;
import org.python.modules._codecs;
import org.python.util.Generic;

@Untraversable
@ExposedType(name="unicode", base=PyBaseString.class, doc="unicode(object='') -> unicode object\nunicode(string[, encoding[, errors]]) -> unicode object\n\nCreate a new Unicode object from the given encoded string.\nencoding defaults to the current default string encoding.\nerrors can be 'strict', 'replace' or 'ignore' and defaults to 'strict'.")
public class PyUnicode
extends PyString
implements Iterable<Integer> {
    private static final boolean DEBUG_NON_BMP_METHODS = false;
    public static final PyType TYPE;
    private final IndexTranslator translator;
    static final IndexTranslator BASIC;

    public PyUnicode() {
        this(TYPE, "", true);
    }

    public PyUnicode(String string2) {
        this(TYPE, string2, false);
    }

    public PyUnicode(String string2, boolean isBasic) {
        this(TYPE, string2, isBasic);
    }

    public PyUnicode(PyType subtype, String string2) {
        this(subtype, string2, false);
    }

    public PyUnicode(PyString pystring) {
        this(TYPE, pystring);
    }

    public PyUnicode(PyType subtype, PyString pystring) {
        this(subtype, pystring instanceof PyUnicode ? pystring.string : pystring.decode().toString(), pystring.isBasicPlane());
    }

    public PyUnicode(char c) {
        this(TYPE, String.valueOf(c), true);
    }

    public PyUnicode(int codepoint) {
        this(TYPE, new String(new int[]{codepoint}, 0, 1));
    }

    public PyUnicode(int[] codepoints) {
        this(new String(codepoints, 0, codepoints.length));
    }

    PyUnicode(StringBuilder buffer) {
        this(TYPE, buffer.toString());
    }

    private static StringBuilder fromCodePoints(Iterator<Integer> iter) {
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            buffer.appendCodePoint(iter.next());
        }
        return buffer;
    }

    public PyUnicode(Iterator<Integer> iter) {
        this(PyUnicode.fromCodePoints(iter));
    }

    public PyUnicode(Collection<Integer> ucs4) {
        this(ucs4.iterator());
    }

    private PyUnicode(PyType subtype, String string2, boolean isBasic) {
        super(subtype, "");
        this.string = string2;
        this.translator = isBasic ? BASIC : this.chooseIndexTranslator();
    }

    @Override
    public int[] toCodePoints() {
        int n = this.getCodePointCount();
        int[] codePoints = new int[n];
        int i = 0;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            codePoints[i] = iter.next();
            ++i;
        }
        return codePoints;
    }

    private static int[] getSupplementaryCounts(String string2) {
        int p;
        int n = string2.length();
        for (p = 0; p < n && !Character.isSurrogate(string2.charAt(p)); ++p) {
        }
        if (p == n) {
            return null;
        }
        int q = p;
        int k = q >> 4;
        int[] count2 = new int[1 + (n >> 4)];
        while (p < n - 1) {
            p += PyUnicode.calcAdvance(string2, p);
            if ((++q & 0xF) != 0) continue;
            count2[k++] = p - q;
            break;
        }
        while (p + 32 < n) {
            for (int i = 0; i < 16; ++i) {
                p += PyUnicode.calcAdvance(string2, p);
            }
            count2[k++] = p - (q += 16);
        }
        while (p < n - 1) {
            p += PyUnicode.calcAdvance(string2, p);
            if ((++q & 0xF) != 0) continue;
            count2[k++] = p - q;
        }
        if (p < n) {
            char c;
            if (Character.isSurrogate(c = string2.charAt(p++))) {
                throw PyUnicode.unpairedSurrogate(p - 1, c);
            }
            ++q;
        }
        int total = p - q;
        while (k < count2.length) {
            count2[k++] = total;
        }
        return count2;
    }

    private static int calcAdvance(String string2, int p) throws PyException {
        char c = string2.charAt(p);
        if (c >= '\ud800') {
            if (c < '\udc00') {
                if (Character.isLowSurrogate(string2.charAt(p + 1))) {
                    return 2;
                }
                throw PyUnicode.unpairedSurrogate(p, c);
            }
            if (c <= '\udfff') {
                throw PyUnicode.unpairedSurrogate(p, c);
            }
        }
        return 1;
    }

    private static PyException unpairedSurrogate(int p, int c) {
        String fmt = "unpaired surrogate %#4x at code unit %d";
        String msg = String.format(fmt, c, p);
        return Py.ValueError(msg);
    }

    private IndexTranslator chooseIndexTranslator() {
        int[] count2 = PyUnicode.getSupplementaryCounts(this.string);
        return count2 == null ? BASIC : new Supplementary(count2);
    }

    @Override
    protected int[] translateIndices(PyObject start, PyObject end) {
        int[] indices = super.translateIndices(start, end);
        indices[0] = this.translator.utf16Index(indices[0]);
        indices[1] = this.translator.utf16Index(indices[1]);
        return indices;
    }

    @Override
    public String substring(int start, int end) {
        return super.substring(this.translator.utf16Index(start), this.translator.utf16Index(end));
    }

    public static PyUnicode fromInterned(String interned) {
        PyUnicode uni = new PyUnicode(TYPE, interned);
        uni.interned = true;
        return uni;
    }

    @Override
    public boolean isBasicPlane() {
        return this.translator == BASIC;
    }

    public int getCodePointCount() {
        return this.string.length() - this.translator.suppCount();
    }

    public static String checkEncoding(String s) {
        if (s == null || CharMatcher.ascii().matchesAllOf(s)) {
            return s;
        }
        return codecs.PyUnicode_EncodeASCII(s, s.length(), null);
    }

    @ExposedNew
    static final PyObject unicode_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("unicode", args, keywords, new String[]{"string", "encoding", "errors"}, 0);
        PyObject S = ap.getPyObject(0, null);
        String encoding = PyUnicode.checkEncoding(ap.getString(1, null));
        String errors2 = PyUnicode.checkEncoding(ap.getString(2, null));
        if (new_.for_type == subtype) {
            if (S == null) {
                return new PyUnicode("");
            }
            if (S instanceof PyUnicode) {
                return new PyUnicode(((PyUnicode)S).getString());
            }
            if (S instanceof PyString) {
                if (S.getType() != PyString.TYPE && encoding == null && errors2 == null) {
                    return S.__unicode__();
                }
                PyObject decoded = codecs.decode((PyString)S, encoding, errors2);
                if (decoded instanceof PyUnicode) {
                    return new PyUnicode((PyUnicode)decoded);
                }
                throw Py.TypeError("decoder did not return an unicode object (type=" + decoded.getType().fastGetName() + ")");
            }
            return S.__unicode__();
        }
        if (S == null) {
            return new PyUnicodeDerived(subtype, Py.EmptyString);
        }
        if (S instanceof PyUnicode) {
            return new PyUnicodeDerived(subtype, (PyUnicode)S);
        }
        return new PyUnicodeDerived(subtype, S.__str__());
    }

    @Override
    public PyString createInstance(String str) {
        return new PyUnicode(str);
    }

    @Override
    protected PyString createInstance(String string2, boolean isBasic) {
        return new PyUnicode(string2, isBasic);
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.unicode___mod__(other);
    }

    final PyObject unicode___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.getString(), true);
        return fmt.format(other);
    }

    @Override
    public PyUnicode __unicode__() {
        return this;
    }

    @Override
    public PyString __str__() {
        return this.unicode___str__();
    }

    final PyString unicode___str__() {
        return new PyString(this.encode());
    }

    @Override
    public int __len__() {
        return this.unicode___len__();
    }

    final int unicode___len__() {
        return this.getCodePointCount();
    }

    @Override
    public PyString __repr__() {
        return this.unicode___repr__();
    }

    final PyString unicode___repr__() {
        return new PyString("u" + PyUnicode.encode_UnicodeEscape(this.getString(), true));
    }

    final PyObject unicode___getitem__(PyObject index) {
        return this.str___getitem__(index);
    }

    final PyObject unicode___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (this.isBasicPlane()) {
            return super.getslice(start, stop, step);
        }
        if (step > 0 && stop < start) {
            stop = start;
        }
        StringBuilder buffer = new StringBuilder(PyUnicode.sliceLength(start, stop, step));
        Iterator<Integer> iter = this.newSubsequenceIterator(start, stop, step);
        while (iter.hasNext()) {
            buffer.appendCodePoint(iter.next());
        }
        return this.createInstance(buffer.toString());
    }

    final int unicode___cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final PyObject unicode___eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject unicode___ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final int unicode___hash__() {
        return this.str___hash__();
    }

    @Override
    protected PyObject pyget(int i) {
        int codepoint = this.getString().codePointAt(this.translator.utf16Index(i));
        return Py.makeCharacter(codepoint, true);
    }

    @Override
    public int getInt(int i) {
        return this.getString().codePointAt(this.translator.utf16Index(i));
    }

    public Iterator<Integer> newSubsequenceIterator() {
        if (this.isBasicPlane()) {
            return new SubsequenceIteratorBasic();
        }
        return new SubsequenceIteratorImpl();
    }

    public Iterator<Integer> newSubsequenceIterator(int start, int stop, int step) {
        if (this.isBasicPlane()) {
            if (step < 0) {
                return new SteppedIterator<Integer>(step * -1, new ReversedIterator<Integer>(new SubsequenceIteratorBasic(stop + 1, start + 1, 1)));
            }
            return new SubsequenceIteratorBasic(start, stop, step);
        }
        if (step < 0) {
            return new SteppedIterator<Integer>(step * -1, new ReversedIterator<Integer>(new SubsequenceIteratorImpl(stop + 1, start + 1, 1)));
        }
        return new SubsequenceIteratorImpl(start, stop, step);
    }

    private PyUnicode coerceToUnicode(PyObject o) {
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            return new PyUnicode(((PyString)o).getString(), true);
        }
        if (o instanceof BufferProtocol) {
            try (PyBuffer buf = ((BufferProtocol)((Object)o)).getBuffer(284);){
                PyUnicode pyUnicode = new PyUnicode(buf.toString(), true);
                return pyUnicode;
            }
        }
        if (o == null) {
            o = Py.None;
        }
        throw Py.TypeError("coercing to Unicode: need string or buffer, " + o.getType().fastGetName() + " found");
    }

    private PyUnicode coerceToUnicodeOrNull(PyObject o) {
        if (o == null || o == Py.None) {
            return null;
        }
        return this.coerceToUnicode(o);
    }

    final boolean unicode___contains__(PyObject o) {
        return this.str___contains__(o);
    }

    final PyObject unicode___mul__(PyObject o) {
        return this.str___mul__(o);
    }

    final PyObject unicode___rmul__(PyObject o) {
        return this.str___rmul__(o);
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.unicode___add__(other);
    }

    final PyObject unicode___add__(PyObject other) {
        PyUnicode otherUnicode;
        if (other instanceof PyUnicode) {
            otherUnicode = (PyUnicode)other;
        } else if (other instanceof PyString) {
            otherUnicode = (PyUnicode)((PyString)other).decode();
        } else {
            return null;
        }
        return new PyUnicode(this.getString().concat(otherUnicode.getString()));
    }

    final PyObject unicode_lower() {
        return new PyUnicode(this.getString().toLowerCase());
    }

    final PyObject unicode_upper() {
        return new PyUnicode(this.getString().toUpperCase());
    }

    final PyObject unicode_title() {
        StringBuilder buffer = new StringBuilder(this.getString().length());
        boolean previous_is_cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (previous_is_cased) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
            } else {
                buffer.appendCodePoint(Character.toTitleCase(codePoint));
            }
            if (Character.isLowerCase(codePoint) || Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                previous_is_cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_swapcase() {
        StringBuilder buffer = new StringBuilder(this.getString().length());
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isUpperCase(codePoint)) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                buffer.appendCodePoint(Character.toUpperCase(codePoint));
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        return new PyUnicode(buffer);
    }

    private PyUnicode coerceStripSepToUnicode(PyObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            return new PyUnicode(((PyString)o).decode().toString());
        }
        if (o == Py.None) {
            return null;
        }
        throw Py.TypeError("strip arg must be None, unicode or str");
    }

    final PyObject unicode_strip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._strip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._strip(sep.getString()));
            }
        }
        return new PyUnicode(new ReversedIterator<Integer>(new StripIterator(sep, new ReversedIterator<Integer>(new StripIterator(sep, this.newSubsequenceIterator())))));
    }

    final PyObject unicode_lstrip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._lstrip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._lstrip(sep.getString()));
            }
        }
        return new PyUnicode(new StripIterator(sep, this.newSubsequenceIterator()));
    }

    final PyObject unicode_rstrip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane()) {
            if (sep == null) {
                return new PyUnicode(this._rstrip());
            }
            if (sep.isBasicPlane()) {
                return new PyUnicode(this._rstrip(sep.getString()));
            }
        }
        return new PyUnicode(new ReversedIterator<Integer>(new StripIterator(sep, new ReversedIterator<Integer>(this.newSubsequenceIterator()))));
    }

    @Override
    public PyTuple partition(PyObject sep) {
        return this.unicode_partition(sep);
    }

    final PyTuple unicode_partition(PyObject sep) {
        return this.unicodePartition(this.coerceToUnicode(sep));
    }

    private SplitIterator newSplitIterator(PyUnicode sep, int maxsplit) {
        if (sep == null) {
            return new WhitespaceSplitIterator(maxsplit);
        }
        if (sep.getCodePointCount() == 0) {
            throw Py.ValueError("empty separator");
        }
        return new SepSplitIterator(sep, maxsplit);
    }

    @Override
    public PyTuple rpartition(PyObject sep) {
        return this.unicode_rpartition(sep);
    }

    final PyTuple unicode_rpartition(PyObject sep) {
        return this.unicodeRpartition(this.coerceToUnicode(sep));
    }

    final PyList unicode_split(PyObject sepObj, int maxsplit) {
        PyUnicode sep = this.coerceToUnicodeOrNull(sepObj);
        if (sep != null) {
            return this._split(sep.getString(), maxsplit);
        }
        return this._split(null, maxsplit);
    }

    final PyList unicode_rsplit(PyObject sepObj, int maxsplit) {
        PyUnicode sep = this.coerceToUnicodeOrNull(sepObj);
        if (sep != null) {
            return this._rsplit(sep.getString(), maxsplit);
        }
        return this._rsplit(null, maxsplit);
    }

    final PyList unicode_splitlines(boolean keepends) {
        return new PyList(new LineSplitIterator(keepends));
    }

    @Override
    protected PyString fromSubstring(int begin, int end) {
        assert (this.isBasicPlane());
        return new PyUnicode(this.getString().substring(begin, end), true);
    }

    final int unicode_index(PyObject subObj, PyObject start, PyObject end) {
        PyUnicode sub = this.coerceToUnicode(subObj);
        return this.checkIndex(this._find(sub.getString(), start, end));
    }

    final int unicode_rindex(PyObject subObj, PyObject start, PyObject end) {
        PyUnicode sub = this.coerceToUnicode(subObj);
        return this.checkIndex(this._rfind(sub.getString(), start, end));
    }

    final int unicode_count(PyObject subObj, PyObject start, PyObject end) {
        PyUnicode sub = this.coerceToUnicode(subObj);
        if (this.isBasicPlane()) {
            return this._count(sub.getString(), start, end);
        }
        int[] indices = super.translateIndices(start, end);
        int count2 = 0;
        Iterator<Integer> mainIter = this.newSubsequenceIterator(indices[0], indices[1], 1);
        while (mainIter.hasNext()) {
            int matched = sub.getCodePointCount();
            Iterator<Integer> subIter = sub.newSubsequenceIterator();
            while (mainIter.hasNext() && subIter.hasNext() && mainIter.next() == subIter.next()) {
                --matched;
            }
            if (matched != 0) continue;
            ++count2;
        }
        return count2;
    }

    final int unicode_find(PyObject subObj, PyObject start, PyObject end) {
        int found = this._find(this.coerceToUnicode(subObj).getString(), start, end);
        return found < 0 ? -1 : this.translator.codePointIndex(found);
    }

    final int unicode_rfind(PyObject subObj, PyObject start, PyObject end) {
        int found = this._rfind(this.coerceToUnicode(subObj).getString(), start, end);
        return found < 0 ? -1 : this.translator.codePointIndex(found);
    }

    private static String padding(int n, int pad) {
        StringBuilder buffer = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            buffer.appendCodePoint(pad);
        }
        return buffer.toString();
    }

    private static int parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return 32;
        }
        if (fillchar.codePointCount(0, fillchar.length()) != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.codePointAt(0);
    }

    final PyObject unicode_ljust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        return new PyUnicode(this.getString() + PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)));
    }

    final PyObject unicode_rjust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        return new PyUnicode(PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)) + this.getString());
    }

    final PyObject unicode_center(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.getString());
        }
        int half = n / 2;
        if (n % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        int pad = PyUnicode.parse_fillchar("center", padding);
        return new PyUnicode(PyUnicode.padding(half, pad) + this.getString() + PyUnicode.padding(n - half, pad));
    }

    final PyObject unicode_zfill(int width) {
        int n = this.getCodePointCount();
        if (n >= width) {
            return new PyUnicode(this.getString());
        }
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_zfill(width));
        }
        StringBuilder buffer = new StringBuilder(width);
        int nzeros = width - n;
        boolean first = true;
        boolean leadingSign = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (first) {
                first = false;
                if (codePoint == 43 || codePoint == 45) {
                    buffer.appendCodePoint(codePoint);
                    leadingSign = true;
                }
                for (int i = 0; i < nzeros; ++i) {
                    buffer.appendCodePoint(48);
                }
                if (leadingSign) continue;
                buffer.appendCodePoint(codePoint);
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        if (first) {
            for (int i = 0; i < nzeros; ++i) {
                buffer.appendCodePoint(48);
            }
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_expandtabs(int tabsize) {
        return new PyUnicode(this.str_expandtabs(tabsize));
    }

    final PyObject unicode_capitalize() {
        if (this.getString().length() == 0) {
            return this;
        }
        StringBuilder buffer = new StringBuilder(this.getString().length());
        boolean first = true;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (first) {
                buffer.appendCodePoint(Character.toUpperCase(iter.next()));
                first = false;
                continue;
            }
            buffer.appendCodePoint(Character.toLowerCase(iter.next()));
        }
        return new PyUnicode(buffer);
    }

    final PyString unicode_replace(PyObject oldPieceObj, PyObject newPieceObj, int count2) {
        PyUnicode newPiece = this.coerceToUnicode(newPieceObj);
        PyUnicode oldPiece = this.coerceToUnicode(oldPieceObj);
        if (this.isBasicPlane() && newPiece.isBasicPlane() && oldPiece.isBasicPlane()) {
            return this._replace(oldPiece.getString(), newPiece.getString(), count2);
        }
        StringBuilder buffer = new StringBuilder();
        if (oldPiece.getCodePointCount() == 0) {
            Iterator<Integer> iter = this.newSubsequenceIterator();
            for (int i = 1; (count2 == -1 || i < count2) && iter.hasNext(); ++i) {
                if (i == 1) {
                    buffer.append(newPiece.getString());
                }
                buffer.appendCodePoint(iter.next());
                buffer.append(newPiece.getString());
            }
            while (iter.hasNext()) {
                buffer.appendCodePoint(iter.next());
            }
            return new PyUnicode(buffer);
        }
        SplitIterator iter = this.newSplitIterator(oldPiece, count2);
        int numSplits = 0;
        while (iter.hasNext()) {
            buffer.append(((PyUnicode)iter.next()).getString());
            if (iter.hasNext()) {
                buffer.append(newPiece.getString());
            }
            ++numSplits;
        }
        if (iter.getEndsWithSeparator() && (count2 == -1 || numSplits <= count2)) {
            buffer.append(newPiece.getString());
        }
        return new PyUnicode(buffer);
    }

    @Override
    public PyString join(PyObject seq) {
        return this.unicode_join(seq);
    }

    final PyUnicode unicode_join(PyObject seq) {
        return this.unicodeJoin(seq);
    }

    final boolean unicode_startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.str_startswith(prefix, start, end);
    }

    final boolean unicode_endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.str_endswith(suffix, start, end);
    }

    final PyObject unicode_translate(PyObject table) {
        return _codecs.translateCharmap(this, "ignore", table);
    }

    final boolean unicode_islower() {
        boolean cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = iter.next();
            if (Character.isUpperCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isLowerCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isupper() {
        boolean cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = iter.next();
            if (Character.isLowerCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isUpperCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isalpha() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isLetter(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isalnum() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isLetterOrDigit(codePoint) || Character.getType(codePoint) == 10) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdecimal() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.getType(iter.next()) == 9) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdigit() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isDigit(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isnumeric() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int type = Character.getType(iter.next());
            if (type == 9 || type == 10 || type == 11) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_istitle() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    final boolean unicode_isspace() {
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isWhitespace(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        return true;
    }

    final String unicode_encode(PyObject[] args, String[] keywords) {
        return this.str_encode(args, keywords);
    }

    final PyObject unicode_decode(PyObject[] args, String[] keywords) {
        return this.str_decode(args, keywords);
    }

    final PyTuple unicode___getnewargs__() {
        return new PyTuple(new PyUnicode(this.getString()));
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.unicode___format__(formatSpec);
    }

    final PyObject unicode___format__(PyObject formatSpec) {
        return this.str___format__(formatSpec);
    }

    final PyObject unicode__formatter_parser() {
        return new MarkupIterator(this);
    }

    final PyObject unicode__formatter_field_name_split() {
        FieldNameIterator iterator = new FieldNameIterator(this);
        return new PyTuple(iterator.pyHead(), iterator);
    }

    final PyObject unicode_format(PyObject[] args, String[] keywords) {
        try {
            return new PyUnicode(this.buildFormattedString(args, keywords, null, null));
        }
        catch (IllegalArgumentException e) {
            throw Py.ValueError(e.getMessage());
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.newSubsequenceIterator();
    }

    @Override
    public PyComplex __complex__() {
        return new PyString(this.encodeDecimal()).__complex__();
    }

    @Override
    public int atoi(int base2) {
        return new PyString(this.encodeDecimal()).atoi(base2);
    }

    @Override
    public PyLong atol(int base2) {
        return new PyString(this.encodeDecimal()).atol(base2);
    }

    @Override
    public double atof() {
        return new PyString(this.encodeDecimal()).atof();
    }

    private String encodeDecimal() {
        if (this.isBasicPlane()) {
            return this.encodeDecimalBasic();
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isWhitespace(codePoint)) {
                sb.append(' ');
            } else {
                int digit = Character.digit(codePoint, 10);
                if (digit >= 0) {
                    sb.append(digit);
                } else if (0 < codePoint && codePoint < 256) {
                    sb.appendCodePoint(codePoint);
                } else {
                    codecs.encoding_error("strict", "decimal", this.getString(), i, i + 1, "invalid decimal Unicode string");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String encodeDecimalBasic() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getString().length(); ++i) {
            char ch = this.getString().charAt(i);
            if (Character.isWhitespace(ch)) {
                sb.append(' ');
                continue;
            }
            int digit = Character.digit(ch, 10);
            if (digit >= 0) {
                sb.append(digit);
                continue;
            }
            if ('\u0000' < ch && ch < '\u0100') {
                sb.append(ch);
                continue;
            }
            codecs.encoding_error("strict", "decimal", this.getString(), i, i + 1, "invalid decimal Unicode string");
        }
        return sb.toString();
    }

    static {
        PyType.addBuilder(PyUnicode.class, new PyUnicode$PyExposer());
        TYPE = PyType.fromClass(PyUnicode.class);
        BASIC = new IndexTranslator(){

            @Override
            public int suppCount() {
                return 0;
            }

            @Override
            public int codePointIndex(int u) {
                return u;
            }

            @Override
            public int utf16Index(int i) {
                return i;
            }
        };
    }

    private class SepSplitIterator
    extends SplitIterator {
        private final PyUnicode sep;

        SepSplitIterator(PyUnicode sep, int maxsplit) {
            super(maxsplit);
            this.sep = sep;
        }

        @Override
        public PyUnicode next() {
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = true;
            while (this.iter.hasNext()) {
                inSeparator = true;
                Iterator<Integer> sepIter = this.sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    int codepoint = (Integer)this.iter.next();
                    if (codepoint != sepIter.next()) {
                        this.addLookahead(buffer);
                        buffer.appendCodePoint(codepoint);
                        inSeparator = false;
                        break;
                    }
                    this.lookahead.add(codepoint);
                }
                if (!inSeparator) continue;
                this.lookahead.clear();
                break;
            }
            ++this.numSplits;
            this.completeSeparator = inSeparator;
            return new PyUnicode(buffer);
        }
    }

    private class LineSplitIterator
    implements Iterator<PyObject> {
        private final PeekIterator<Integer> iter;
        private final boolean keepends;

        LineSplitIterator(boolean keepends) {
            this.iter = new PeekIterator<Integer>(PyUnicode.this.newSubsequenceIterator());
            this.keepends = keepends;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PyObject next() {
            StringBuilder buffer = new StringBuilder();
            while (this.iter.hasNext()) {
                int codepoint = this.iter.next();
                if (codepoint == 13 && this.iter.peek() != null && this.iter.peek() == 10) {
                    if (this.keepends) {
                        buffer.appendCodePoint(codepoint);
                        buffer.appendCodePoint(this.iter.next());
                        break;
                    }
                    this.iter.next();
                    break;
                }
                if (codepoint == 10 || codepoint == 13 || Character.getType(codepoint) == 13) {
                    if (!this.keepends) break;
                    buffer.appendCodePoint(codepoint);
                    break;
                }
                buffer.appendCodePoint(codepoint);
            }
            return new PyUnicode(buffer);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReversedIterator<T>
    implements Iterator<T> {
        private final List<T> reversed = Generic.list();
        private final Iterator<T> iter;

        ReversedIterator(Iterator<T> iter) {
            while (iter.hasNext()) {
                this.reversed.add(iter.next());
            }
            Collections.reverse(this.reversed);
            this.iter = this.reversed.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PeekIterator<T>
    implements Iterator<T> {
        private T lookahead = null;
        private final Iterator<T> iter;

        public PeekIterator(Iterator<T> iter) {
            this.iter = iter;
            this.next();
        }

        public T peek() {
            return this.lookahead;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        @Override
        public T next() {
            T peeked = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : null;
            return peeked;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class WhitespaceSplitIterator
    extends SplitIterator {
        WhitespaceSplitIterator(int maxsplit) {
            super(maxsplit);
        }

        @Override
        public PyUnicode next() {
            boolean atBeginning;
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = false;
            boolean bl = atBeginning = this.numSplits == 0;
            while (this.iter.hasNext()) {
                int codepoint = (Integer)this.iter.next();
                if (Character.isWhitespace(codepoint)) {
                    this.completeSeparator = true;
                    if (!atBeginning) {
                        inSeparator = true;
                    }
                } else if (!inSeparator) {
                    this.completeSeparator = false;
                    buffer.appendCodePoint(codepoint);
                } else {
                    this.completeSeparator = false;
                    this.lookahead.add(codepoint);
                    break;
                }
                atBeginning = false;
            }
            ++this.numSplits;
            return new PyUnicode(buffer);
        }
    }

    private abstract class SplitIterator
    implements Iterator<PyUnicode> {
        protected final int maxsplit;
        protected final Iterator<Integer> iter;
        protected final LinkedList<Integer> lookahead;
        protected int numSplits;
        protected boolean completeSeparator;

        SplitIterator(int maxsplit) {
            this.iter = PyUnicode.this.newSubsequenceIterator();
            this.lookahead = new LinkedList();
            this.numSplits = 0;
            this.completeSeparator = false;
            this.maxsplit = maxsplit;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead.peek() != null || this.iter.hasNext() && (this.maxsplit == -1 || this.numSplits <= this.maxsplit);
        }

        protected void addLookahead(StringBuilder buffer) {
            Iterator iterator = this.lookahead.iterator();
            while (iterator.hasNext()) {
                int codepoint = (Integer)iterator.next();
                buffer.appendCodePoint(codepoint);
            }
            this.lookahead.clear();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean getEndsWithSeparator() {
            return this.completeSeparator && !this.hasNext();
        }
    }

    private static class StripIterator
    implements Iterator<Integer> {
        private final Iterator<Integer> iter;
        private int lookahead = -1;

        public StripIterator(PyUnicode sep, Iterator<Integer> iter) {
            this.iter = iter;
            if (sep != null) {
                Set<Integer> sepSet = Generic.set();
                Iterator<Integer> sepIter = sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    sepSet.add(sepIter.next());
                }
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (sepSet.contains(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            } else {
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (Character.isWhitespace(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != -1;
        }

        @Override
        public Integer next() {
            int old = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : -1;
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SteppedIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iter;
        private final int step;
        private T lookahead = null;

        public SteppedIterator(int step, Iterator<T> iter) {
            this.iter = iter;
            this.step = step;
            this.lookahead = this.advance();
        }

        private T advance() {
            if (this.iter.hasNext()) {
                T elem = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
                return elem;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        @Override
        public T next() {
            T old = this.lookahead;
            if (this.iter.hasNext()) {
                this.lookahead = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
            } else {
                this.lookahead = null;
            }
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SubsequenceIteratorBasic
    implements Iterator<Integer> {
        protected int current;
        protected int stop;
        protected int step;

        SubsequenceIteratorBasic(int start, int stop, int step) {
            this.current = start;
            this.stop = stop;
            this.step = step;
        }

        SubsequenceIteratorBasic() {
            this(0, pyUnicode.getCodePointCount(), 1);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.stop;
        }

        @Override
        public Integer next() {
            int codePoint = this.nextCodePoint();
            for (int j = 1; j < this.step && this.hasNext(); ++j) {
                this.nextCodePoint();
            }
            return codePoint;
        }

        protected int nextCodePoint() {
            return PyUnicode.this.getString().charAt(this.current++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported on PyUnicode objects (immutable)");
        }
    }

    private class SubsequenceIteratorImpl
    extends SubsequenceIteratorBasic {
        private int k;

        SubsequenceIteratorImpl(int start, int stop, int step) {
            super(start, stop, step);
            this.k = PyUnicode.this.translator.utf16Index(this.current);
        }

        SubsequenceIteratorImpl() {
            this(0, pyUnicode.getCodePointCount(), 1);
        }

        @Override
        protected int nextCodePoint() {
            int U;
            int W1 = PyUnicode.this.getString().charAt(this.k);
            if (W1 >= 55296 && W1 < 56320) {
                char W2 = PyUnicode.this.getString().charAt(this.k + 1);
                U = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                this.k += 2;
            } else {
                U = W1;
                ++this.k;
            }
            ++this.current;
            return U;
        }
    }

    private final class Supplementary
    implements IndexTranslator {
        final int[] count;
        static final int LOG2M = 4;
        static final int M = 16;
        static final int MASK = 15;

        Supplementary(int[] count2) {
            this.count = count2;
        }

        @Override
        public int codePointIndex(int u) {
            int c1;
            int k2 = (u >> 4) + 1;
            int c2 = this.count[k2 - 1];
            int k1 = Math.max(0, u - c2) >> 4;
            int n = c1 = k1 == 0 ? 0 : this.count[k1 - 1];
            while (true) {
                if (c2 == c1) {
                    return u - c1;
                }
                int k = (k1 + k2) / 2;
                if (k == k1) break;
                int c = this.count[k - 1];
                if ((k << 4) + c > u) {
                    k2 = k;
                    c2 = c;
                    continue;
                }
                k1 = k;
                c1 = c;
            }
            int p = (k1 << 4) + c1;
            while (p < u) {
                if (!Character.isHighSurrogate(PyUnicode.this.string.charAt(p++))) continue;
                if (++c1 == c2) break;
                ++p;
            }
            return u - c1;
        }

        @Override
        public int utf16Index(int i) {
            int e;
            int k = i >> 4;
            int d = k == 0 ? 0 : this.count[k - 1];
            if (d == (e = this.count[k])) {
                return i + d;
            }
            for (int q = i & 0xFFFFFFF0; !(q >= i || Character.isHighSurrogate(PyUnicode.this.string.charAt(q + d)) && ++d == e); ++q) {
            }
            return i + d;
        }

        @Override
        public int suppCount() {
            return this.count[this.count.length - 1];
        }
    }

    private static interface IndexTranslator
    extends Serializable {
        public int suppCount();

        public int codePointIndex(int var1);

        public int utf16Index(int var1);
    }

    public class PyUnicode$unicode___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___mod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyUnicode$unicode___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode___mod__(pyObject);
        }
    }

    public class PyUnicode$unicode___str___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___str___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyUnicode$unicode___str___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___str___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode___str__();
        }
    }

    public class PyUnicode$unicode___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___len___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyUnicode$unicode___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyUnicode)this.self).unicode___len__());
        }
    }

    public class PyUnicode$unicode___repr___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___repr___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__repr__() <==> repr(x)";
        }

        public PyUnicode$unicode___repr___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__repr__() <==> repr(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___repr___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode___repr__();
        }
    }

    public class PyUnicode$unicode___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___getitem___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__getitem__(y) <==> x[y]";
        }

        public PyUnicode$unicode___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getitem__(y) <==> x[y]";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode___getitem__(pyObject);
        }
    }

    public class PyUnicode$unicode___getslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___getslice___exposer(String string2) {
            super(string2, 3, 4);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyUnicode$unicode___getslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___getslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyUnicode)this.self).unicode___getslice__(pyObject, pyObject2, pyObject3);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode___getslice__(pyObject, pyObject2, null);
        }
    }

    public class PyUnicode$unicode___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___ne___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyUnicode$unicode___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyUnicode)this.self).unicode___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyUnicode$unicode___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___hash___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyUnicode$unicode___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyUnicode)this.self).unicode___hash__());
        }
    }

    public class PyUnicode$unicode___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___mul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyUnicode$unicode___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyUnicode)this.self).unicode___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyUnicode$unicode___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___rmul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyUnicode$unicode___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyUnicode)this.self).unicode___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyUnicode$unicode_upper_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_upper_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.upper() -> unicode\n\nReturn a copy of S converted to uppercase.";
        }

        public PyUnicode$unicode_upper_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.upper() -> unicode\n\nReturn a copy of S converted to uppercase.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_upper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_upper();
        }
    }

    public class PyUnicode$unicode_swapcase_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_swapcase_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.swapcase() -> unicode\n\nReturn a copy of S with uppercase characters converted to lowercase\nand vice versa.";
        }

        public PyUnicode$unicode_swapcase_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.swapcase() -> unicode\n\nReturn a copy of S with uppercase characters converted to lowercase\nand vice versa.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_swapcase_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_swapcase();
        }
    }

    public class PyUnicode$unicode_lstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_lstrip_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "S.lstrip([chars]) -> unicode\n\nReturn a copy of the string S with leading whitespace removed.\nIf chars is given and not None, remove characters in chars instead.\nIf chars is a str, it will be converted to unicode before stripping";
        }

        public PyUnicode$unicode_lstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.lstrip([chars]) -> unicode\n\nReturn a copy of the string S with leading whitespace removed.\nIf chars is given and not None, remove characters in chars instead.\nIf chars is a str, it will be converted to unicode before stripping";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_lstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_lstrip(pyObject);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_lstrip(null);
        }
    }

    public class PyUnicode$unicode_partition_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_partition_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "S.partition(sep) -> (head, sep, tail)\n\nSearch for the separator sep in S, and return the part before it,\nthe separator itself, and the part after it.  If the separator is not\nfound, return S and two empty strings.";
        }

        public PyUnicode$unicode_partition_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.partition(sep) -> (head, sep, tail)\n\nSearch for the separator sep in S, and return the part before it,\nthe separator itself, and the part after it.  If the separator is not\nfound, return S and two empty strings.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_partition_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_partition(pyObject);
        }
    }

    public class PyUnicode$unicode_index_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_index_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.index(sub [,start [,end]]) -> int\n\nLike S.find() but raise ValueError when the substring is not found.";
        }

        public PyUnicode$unicode_index_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.index(sub [,start [,end]]) -> int\n\nLike S.find() but raise ValueError when the substring is not found.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_index_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyUnicode)this.self).unicode_index(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyUnicode)this.self).unicode_index(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyUnicode)this.self).unicode_index(pyObject, null, null));
        }
    }

    public class PyUnicode$unicode_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_count_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.count(sub[, start[, end]]) -> int\n\nReturn the number of non-overlapping occurrences of substring sub in\nUnicode string S[start:end].  Optional arguments start and end are\ninterpreted as in slice notation.";
        }

        public PyUnicode$unicode_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.count(sub[, start[, end]]) -> int\n\nReturn the number of non-overlapping occurrences of substring sub in\nUnicode string S[start:end].  Optional arguments start and end are\ninterpreted as in slice notation.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyUnicode)this.self).unicode_count(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyUnicode)this.self).unicode_count(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyUnicode)this.self).unicode_count(pyObject, null, null));
        }
    }

    public class PyUnicode$unicode_find_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_find_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.find(sub [,start [,end]]) -> int\n\nReturn the lowest index in S where substring sub is found,\nsuch that sub is contained within s[start:end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyUnicode$unicode_find_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.find(sub [,start [,end]]) -> int\n\nReturn the lowest index in S where substring sub is found,\nsuch that sub is contained within s[start:end].  Optional\narguments start and end are interpreted as in slice notation.\n\nReturn -1 on failure.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_find_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyUnicode)this.self).unicode_find(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyUnicode)this.self).unicode_find(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyUnicode)this.self).unicode_find(pyObject, null, null));
        }
    }

    public class PyUnicode$unicode_rjust_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_rjust_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_rjust_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_rjust_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode_rjust(Py.py2int(pyObject), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_rjust(Py.py2int(pyObject), null);
        }
    }

    public class PyUnicode$unicode_center_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_center_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_center_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_center_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode_center(Py.py2int(pyObject), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_center(Py.py2int(pyObject), null);
        }
    }

    public class PyUnicode$unicode_zfill_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_zfill_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "S.zfill(width) -> unicode\n\nPad a numeric string S with zeros on the left, to fill a field\nof the specified width. The string S is never truncated.";
        }

        public PyUnicode$unicode_zfill_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.zfill(width) -> unicode\n\nPad a numeric string S with zeros on the left, to fill a field\nof the specified width. The string S is never truncated.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_zfill_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_zfill(Py.py2int(pyObject));
        }
    }

    public class PyUnicode$unicode_expandtabs_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_expandtabs_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_expandtabs_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n           \n           Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_expandtabs_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_expandtabs(Py.py2int(pyObject));
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_expandtabs(8);
        }
    }

    public class PyUnicode$unicode_capitalize_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_capitalize_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.capitalize() -> unicode\n\nReturn a capitalized version of S, i.e. make the first character\nhave upper case and the rest lower case.";
        }

        public PyUnicode$unicode_capitalize_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.capitalize() -> unicode\n\nReturn a capitalized version of S, i.e. make the first character\nhave upper case and the rest lower case.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_capitalize_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_capitalize();
        }
    }

    public class PyUnicode$unicode_join_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_join_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "S.join(iterable) -> unicode\n\nReturn a string which is the concatenation of the strings in the\niterable.  The separator between elements is S.";
        }

        public PyUnicode$unicode_join_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.join(iterable) -> unicode\n\nReturn a string which is the concatenation of the strings in the\niterable.  The separator between elements is S.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_join_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_join(pyObject);
        }
    }

    public class PyUnicode$unicode_endswith_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_endswith_exposer(String string2) {
            super(string2, 2, 4);
            this.doc = "S.endswith(suffix[, start[, end]]) -> bool\n\nReturn True if S ends with the specified suffix, False otherwise.\nWith optional start, test S beginning at that position.\nWith optional end, stop comparing S at that position.\nsuffix can also be a tuple of strings to try.";
        }

        public PyUnicode$unicode_endswith_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.endswith(suffix[, start[, end]]) -> bool\n\nReturn True if S ends with the specified suffix, False otherwise.\nWith optional start, test S beginning at that position.\nWith optional end, stop comparing S at that position.\nsuffix can also be a tuple of strings to try.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_endswith_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((PyUnicode)this.self).unicode_endswith(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newBoolean(((PyUnicode)this.self).unicode_endswith(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyUnicode)this.self).unicode_endswith(pyObject, null, null));
        }
    }

    public class PyUnicode$unicode_isupper_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isupper_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isupper() -> bool\n\nReturn True if all cased characters in S are uppercase and there is\nat least one cased character in S, False otherwise.";
        }

        public PyUnicode$unicode_isupper_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isupper() -> bool\n\nReturn True if all cased characters in S are uppercase and there is\nat least one cased character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isupper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isupper());
        }
    }

    public class PyUnicode$unicode_isalnum_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isalnum_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isalnum() -> bool\n\nReturn True if all characters in S are alphanumeric\nand there is at least one character in S, False otherwise.";
        }

        public PyUnicode$unicode_isalnum_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isalnum() -> bool\n\nReturn True if all characters in S are alphanumeric\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isalnum_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isalnum());
        }
    }

    public class PyUnicode$unicode_isdigit_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isdigit_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isdigit() -> bool\n\nReturn True if all characters in S are digits\nand there is at least one character in S, False otherwise.";
        }

        public PyUnicode$unicode_isdigit_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isdigit() -> bool\n\nReturn True if all characters in S are digits\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isdigit_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isdigit());
        }
    }

    public class PyUnicode$unicode_isnumeric_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isnumeric_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "S.isnumeric() -> bool\n\nReturn True if there are only numeric characters in S,\nFalse otherwise.";
        }

        public PyUnicode$unicode_isnumeric_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isnumeric() -> bool\n\nReturn True if there are only numeric characters in S,\nFalse otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isnumeric_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isnumeric());
        }
    }

    public class PyUnicode$unicode_encode_exposer
    extends PyBuiltinMethod {
        public PyUnicode$unicode_encode_exposer(String string2) {
            super(string2);
            this.doc = "S.encode([encoding[,errors]]) -> string or unicode\n\nEncodes S using the codec registered for encoding. encoding defaults\nto the default encoding. errors may be given to set a different error\nhandling scheme. Default is 'strict' meaning that encoding errors raise\na UnicodeEncodeError. Other possible values are 'ignore', 'replace' and\n'xmlcharrefreplace' as well as any other name registered with\ncodecs.register_error that can handle UnicodeEncodeErrors.";
        }

        public PyUnicode$unicode_encode_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.encode([encoding[,errors]]) -> string or unicode\n\nEncodes S using the codec registered for encoding. encoding defaults\nto the default encoding. errors may be given to set a different error\nhandling scheme. Default is 'strict' meaning that encoding errors raise\na UnicodeEncodeError. Other possible values are 'ignore', 'replace' and\n'xmlcharrefreplace' as well as any other name registered with\ncodecs.register_error that can handle UnicodeEncodeErrors.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_encode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            String string2 = ((PyUnicode)this.self).unicode_encode(pyObjectArray, stringArray);
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyUnicode$unicode_decode_exposer
    extends PyBuiltinMethod {
        public PyUnicode$unicode_decode_exposer(String string2) {
            super(string2);
            this.doc = "S.decode([encoding[,errors]]) -> string or unicode\n\nDecodes S using the codec registered for encoding. encoding defaults\nto the default encoding. errors may be given to set a different error\nhandling scheme. Default is 'strict' meaning that encoding errors raise\na UnicodeDecodeError. Other possible values are 'ignore' and 'replace'\nas well as any other name registerd with codecs.register_error that is\nable to handle UnicodeDecodeErrors.";
        }

        public PyUnicode$unicode_decode_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.decode([encoding[,errors]]) -> string or unicode\n\nDecodes S using the codec registered for encoding. encoding defaults\nto the default encoding. errors may be given to set a different error\nhandling scheme. Default is 'strict' meaning that encoding errors raise\na UnicodeDecodeError. Other possible values are 'ignore' and 'replace'\nas well as any other name registerd with codecs.register_error that is\nable to handle UnicodeDecodeErrors.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_decode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyUnicode)this.self).unicode_decode(pyObjectArray, stringArray);
        }
    }

    public class PyUnicode$unicode___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___getnewargs___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyUnicode$unicode___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode___getnewargs__();
        }
    }

    public class PyUnicode$unicode__formatter_parser_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode__formatter_parser_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyUnicode$unicode__formatter_parser_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode__formatter_parser_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode__formatter_parser();
        }
    }

    public class PyUnicode$unicode__formatter_field_name_split_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode__formatter_field_name_split_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyUnicode$unicode__formatter_field_name_split_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode__formatter_field_name_split_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode__formatter_field_name_split();
        }
    }

    public class PyUnicode$unicode_format_exposer
    extends PyBuiltinMethod {
        public PyUnicode$unicode_format_exposer(String string2) {
            super(string2);
            this.doc = "S.format(*args, **kwargs) -> unicode\n\nReturn a formatted version of S, using substitutions from args and kwargs.\nThe substitutions are identified by braces ('{' and '}').";
        }

        public PyUnicode$unicode_format_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.format(*args, **kwargs) -> unicode\n\nReturn a formatted version of S, using substitutions from args and kwargs.\nThe substitutions are identified by braces ('{' and '}').";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_format_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PyUnicode)this.self).unicode_format(pyObjectArray, stringArray);
        }
    }

    public class PyUnicode$PyExposer
    extends BaseTypeBuilder {
        public PyUnicode$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyUnicode$unicode___mod___exposer("__mod__"), new PyUnicode$unicode___str___exposer("__str__"), new PyUnicode$unicode___len___exposer("__len__"), new PyUnicode$unicode___repr___exposer("__repr__"), new PyUnicode$unicode___getitem___exposer("__getitem__"), new PyUnicode$unicode___getslice___exposer("__getslice__"), new PyUnicode$unicode___cmp___exposer("__cmp__"), new PyUnicode$unicode___eq___exposer("__eq__"), new PyUnicode$unicode___ne___exposer("__ne__"), new PyUnicode$unicode___hash___exposer("__hash__"), new PyUnicode$unicode___contains___exposer("__contains__"), new PyUnicode$unicode___mul___exposer("__mul__"), new PyUnicode$unicode___rmul___exposer("__rmul__"), new PyUnicode$unicode___add___exposer("__add__"), new PyUnicode$unicode_lower_exposer("lower"), new PyUnicode$unicode_upper_exposer("upper"), new PyUnicode$unicode_title_exposer("title"), new PyUnicode$unicode_swapcase_exposer("swapcase"), new PyUnicode$unicode_strip_exposer("strip"), new PyUnicode$unicode_lstrip_exposer("lstrip"), new PyUnicode$unicode_rstrip_exposer("rstrip"), new PyUnicode$unicode_partition_exposer("partition"), new PyUnicode$unicode_rpartition_exposer("rpartition"), new PyUnicode$unicode_split_exposer("split"), new PyUnicode$unicode_rsplit_exposer("rsplit"), new PyUnicode$unicode_splitlines_exposer("splitlines"), new PyUnicode$unicode_index_exposer("index"), new PyUnicode$unicode_rindex_exposer("rindex"), new PyUnicode$unicode_count_exposer("count"), new PyUnicode$unicode_find_exposer("find"), new PyUnicode$unicode_rfind_exposer("rfind"), new PyUnicode$unicode_ljust_exposer("ljust"), new PyUnicode$unicode_rjust_exposer("rjust"), new PyUnicode$unicode_center_exposer("center"), new PyUnicode$unicode_zfill_exposer("zfill"), new PyUnicode$unicode_expandtabs_exposer("expandtabs"), new PyUnicode$unicode_capitalize_exposer("capitalize"), new PyUnicode$unicode_replace_exposer("replace"), new PyUnicode$unicode_join_exposer("join"), new PyUnicode$unicode_startswith_exposer("startswith"), new PyUnicode$unicode_endswith_exposer("endswith"), new PyUnicode$unicode_translate_exposer("translate"), new PyUnicode$unicode_islower_exposer("islower"), new PyUnicode$unicode_isupper_exposer("isupper"), new PyUnicode$unicode_isalpha_exposer("isalpha"), new PyUnicode$unicode_isalnum_exposer("isalnum"), new PyUnicode$unicode_isdecimal_exposer("isdecimal"), new PyUnicode$unicode_isdigit_exposer("isdigit"), new PyUnicode$unicode_isnumeric_exposer("isnumeric"), new PyUnicode$unicode_istitle_exposer("istitle"), new PyUnicode$unicode_isspace_exposer("isspace"), new PyUnicode$unicode_isunicode_exposer("isunicode"), new PyUnicode$unicode_encode_exposer("encode"), new PyUnicode$unicode_decode_exposer("decode"), new PyUnicode$unicode___getnewargs___exposer("__getnewargs__"), new PyUnicode$unicode___format___exposer("__format__"), new PyUnicode$unicode__formatter_parser_exposer("_formatter_parser"), new PyUnicode$unicode__formatter_field_name_split_exposer("_formatter_field_name_split"), new PyUnicode$unicode_format_exposer("format")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("unicode", PyUnicode.class, PyBaseString.class, true, "unicode(object='') -> unicode object\nunicode(string[, encoding[, errors]]) -> unicode object\n\nCreate a new Unicode object from the given encoded string.\nencoding defaults to the current default string encoding.\nerrors can be 'strict', 'replace' or 'ignore' and defaults to 'strict'.", pyBuiltinMethodArray, pyDataDescrArray, new PyUnicode$exposed___new__());
        }
    }
}

