/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import com.jcraft.jzlib.Inflater;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.netxms.base.Logger;

final class NXCReceivedFile {
    public static final int OPEN = 0;
    public static final int RECEIVED = 1;
    public static final int FAILED = 2;
    public static final int CANCELED = 3;
    private long id;
    private File file;
    private FileOutputStream stream;
    private int status;
    private long timestamp;
    private long size;
    private Exception exception;
    private Inflater decompressor = null;

    protected NXCReceivedFile(long id) {
        this.id = id;
        try {
            this.file = File.createTempFile("nxc", "data");
            this.file.deleteOnExit();
            this.stream = new FileOutputStream(this.file);
            this.timestamp = System.currentTimeMillis();
            this.status = 0;
            this.size = 0L;
        }
        catch (IOException e) {
            this.exception = e;
            this.status = 2;
        }
    }

    protected int writeData(byte[] data, boolean compressedStream) {
        int bytes = 0;
        if (this.status == 0) {
            try {
                if (compressedStream) {
                    if (data[0] != 2) {
                        throw new IOException("Unsupported stream compression method " + data[0]);
                    }
                    if (this.decompressor == null) {
                        this.decompressor = new Inflater();
                        Logger.debug((String)this.getClass().getName(), (String)("Decompressor created for file " + this.file.getAbsolutePath()));
                    }
                    this.decompressor.setInput(data, 4, data.length - 4, false);
                    int dataLength = data[2] << 8 & 0xFF00 | data[3] & 0xFF;
                    byte[] uncompressedData = new byte[dataLength];
                    this.decompressor.setOutput(uncompressedData);
                    int rc = this.decompressor.inflate(2);
                    if (rc != 0 && rc != 1) {
                        throw new IOException("Decompression error " + rc);
                    }
                    this.stream.write(uncompressedData);
                    bytes = uncompressedData.length;
                } else {
                    this.stream.write(data);
                    bytes = data.length;
                }
                this.size += (long)bytes;
            }
            catch (Exception e) {
                Logger.error((String)this.getClass().getName(), (String)"Exception during file processing", (Throwable)e);
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.status = 2;
                this.exception = e;
            }
            this.timestamp = System.currentTimeMillis();
        }
        return bytes;
    }

    protected void close() {
        if (this.status == 0) {
            try {
                this.stream.close();
                this.status = 1;
            }
            catch (IOException e) {
                this.status = 2;
                this.exception = e;
            }
            this.timestamp = System.currentTimeMillis();
        }
    }

    protected void abortTransfer(boolean isCanceled) {
        if (this.status == 0) {
            try {
                this.stream.close();
                this.status = 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.timestamp = System.currentTimeMillis();
        this.status = isCanceled ? 3 : 2;
        this.exception = new IOException();
    }

    public long getId() {
        return this.id;
    }

    public File getFile() {
        return this.file;
    }

    public int getStatus() {
        return this.status;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSize() {
        return this.size;
    }

    public IOException getException() {
        return this.exception != null && this.exception instanceof IOException ? (IOException)this.exception : new IOException(this.exception);
    }
}

