/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum AgentCompressionMode {
    DEFAULT(0),
    ENABLED(1),
    DISABLED(2);

    private int value;
    private static Map<Integer, AgentCompressionMode> lookupTable;

    private AgentCompressionMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AgentCompressionMode getByValue(int value) {
        AgentCompressionMode element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)AgentCompressionMode.class.getName(), (String)("Unknown element " + value));
            return DEFAULT;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, AgentCompressionMode>();
        for (AgentCompressionMode element : AgentCompressionMode.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

