/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import javax.servlet.ServletContext;
import org.json.JSONObject;
import org.netxms.client.SessionListener;
import org.netxms.websvc.SessionStore;
import org.netxms.websvc.SessionToken;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.handlers.Sessions;
import org.netxms.websvc.json.JsonTools;
import org.restlet.data.CookieSetting;
import org.restlet.data.Header;
import org.restlet.data.MediaType;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sessions
extends AbstractHandler {
    private Logger log = LoggerFactory.getLogger(Sessions.class);

    @Get
    public Representation onGet() throws Exception {
        String id = this.getEntityId();
        if (this.attachToSession()) {
            if ("self".equals(id)) {
                return new StringRepresentation((CharSequence)JsonTools.jsonFromObject((Object)this.getSession(), null), MediaType.APPLICATION_JSON);
            }
            return new StringRepresentation((CharSequence)this.createErrorResponse(28).toString(), MediaType.APPLICATION_JSON);
        }
        return new StringRepresentation((CharSequence)this.createErrorResponse("self".equals(id) ? 89 : 2).toString(), MediaType.APPLICATION_JSON);
    }

    @Post
    public Representation onPost(Representation entity) throws Exception {
        String login = null;
        String password = null;
        boolean attachNotificationHandler = false;
        if (entity != null) {
            JSONObject request = new JsonRepresentation(entity).getJsonObject();
            if (request.has("login")) {
                login = request.getString("login");
            }
            if (request.has("password")) {
                password = request.getString("password");
            }
            if (request.has("attachNotificationHandler")) {
                attachNotificationHandler = request.getBoolean("attachNotificationHandler");
            }
        }
        if (entity == null || login == null && password == null) {
            String[] values;
            this.log.warn("No POST data in login call, looking for authentication data instead...");
            String authHeader = this.getHeader("Authorization");
            if (authHeader != null && !authHeader.isEmpty() && (values = this.decodeBase64(authHeader).split(":", 2)).length == 2) {
                login = values[0];
                password = values[1];
            }
        }
        if (login == null || password == null) {
            this.log.warn("Login or password not specified in login call");
            return new StringRepresentation((CharSequence)this.createErrorResponse(3).toString(), MediaType.APPLICATION_JSON);
        }
        SessionToken token = this.login(login, password);
        if (attachNotificationHandler) {
            this.attachNotificationHandler(token);
        }
        this.log.info("Logged in to NetXMS server, assigned session id " + token.getSessionHandle());
        this.getCookieSettings().add((Object)new CookieSetting(0, "session_handle", token.getSessionHandle().toString(), "/", null));
        this.getResponse().getHeaders().add((Object)new Header("Session-Id", token.getSessionHandle().toString()));
        return new StringRepresentation((CharSequence)JsonTools.jsonFromObject((Object)token, null), MediaType.APPLICATION_JSON);
    }

    protected Object delete(String id) throws Exception {
        if (this.getSessionToken().getSessionHandle().toString().equals(id) || "self".equals(id)) {
            this.log.info("Logout request for session " + id);
            this.getSession().disconnect();
            SessionStore.getInstance((ServletContext)this.getServletContext()).unregisterSession(this.getSessionToken().getSessionHandle());
            return new JSONObject();
        }
        this.log.warn("Logout request for different session (" + this.getSessionToken().getSessionHandle() + " -- " + id);
        return this.createErrorResponse(2);
    }

    private void attachNotificationHandler(SessionToken token) {
        this.log.debug("Listener added");
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        token.getSession().addListener((SessionListener)listener);
    }

    static /* synthetic */ Logger access$000(Sessions x0) {
        return x0.log;
    }
}

