/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.EditPaneWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementLayout;
import org.netxms.ui.eclipse.tools.FontTools;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class ElementWidget
extends DashboardComposite
implements ControlListener {
    protected DashboardElement element;
    protected IViewPart viewPart;
    private DashboardControl dbc;
    private DashboardElementLayout layout;
    private boolean editMode = false;
    private EditPaneWidget editPane = null;

    protected ElementWidget(DashboardControl parent, int style, DashboardElement element, IViewPart viewPart) {
        super((Composite)parent, style);
        this.dbc = parent;
        this.element = element;
        this.viewPart = viewPart;
        this.parseLayout(element.getLayout());
        this.addControlListener(this);
    }

    protected ElementWidget(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super((Composite)parent, 2048);
        this.dbc = parent;
        this.element = element;
        this.viewPart = viewPart;
        this.parseLayout(element.getLayout());
        this.addControlListener(this);
    }

    private void parseLayout(String xml) {
        try {
            this.layout = DashboardElementLayout.createFromXml(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.layout = new DashboardElementLayout();
        }
    }

    public DashboardElementLayout getElementLayout() {
        return this.layout;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        if (editMode) {
            this.editPane = new EditPaneWidget((Composite)this, this.dbc, this.element);
            this.editPane.setLocation(0, 0);
            this.editPane.setSize(this.getSize());
            this.editPane.moveAbove(null);
        } else if (this.editPane != null) {
            this.editPane.dispose();
            this.editPane = null;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.editPane != null) {
            this.editPane.setLocation(0, 0);
            this.editPane.setSize(this.getSize());
            this.editPane.moveAbove(null);
        }
    }

    protected void setSelectionProviderDelegate(ISelectionProvider delegate) {
        this.dbc.getSelectionProvider().setSelectionProviderDelegate(delegate);
    }

    protected IntermediateSelectionProvider getSelectionProvider() {
        return this.dbc.getSelectionProvider();
    }

    protected void requestDashboardLayout() {
        this.dbc.layout(true, true);
    }

    protected Label createTitleLabel(Composite parent, String text) {
        Label title = new Label((Composite)this, 0x1000000);
        final Font font = FontTools.createTitleFont();
        title.setFont(font);
        title.setBackground(parent.getBackground());
        title.setText(text);
        title.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        return title;
    }
}

