/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum RackOrientation {
    FILL(0),
    FRONT(1),
    REAR(2);

    private int value;
    private static Map<Integer, RackOrientation> lookupTable;

    static {
        lookupTable = new HashMap<Integer, RackOrientation>();
        RackOrientation[] rackOrientationArray = RackOrientation.values();
        int n = rackOrientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            RackOrientation element = rackOrientationArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private RackOrientation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RackOrientation getByValue(int value) {
        RackOrientation element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)RackOrientation.class.getName(), (String)("Unknown element " + value));
            return FILL;
        }
        return element;
    }
}

