/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.Messages;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.DataChart;

public abstract class GenericChart
extends Canvas
implements DataChart {
    protected String title;
    protected boolean titleVisible;
    protected boolean legendVisible;
    protected boolean displayIn3D;
    protected boolean useLogScale;
    protected boolean translucent;
    protected ChartColor[] palette;
    protected IPreferenceStore preferenceStore;
    protected int legendPosition;

    public GenericChart(Composite parent, int style) {
        super(parent, style);
        Messages.get();
        this.title = Messages.GenericChart_Title0;
        this.titleVisible = false;
        this.legendVisible = true;
        this.displayIn3D = true;
        this.useLogScale = false;
        this.translucent = false;
        this.palette = null;
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
        this.createDefaultPalette();
    }

    @Override
    public String getChartTitle() {
        return this.title;
    }

    @Override
    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    @Override
    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    @Override
    public void setPalette(ChartColor[] colors) {
        this.palette = colors;
    }

    @Override
    public void setPaletteEntry(int index, ChartColor color) {
        try {
            this.palette[index] = color;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    @Override
    public ChartColor getPaletteEntry(int index) {
        try {
            return this.palette[index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public boolean is3DModeEnabled() {
        return this.displayIn3D;
    }

    @Override
    public boolean isLogScaleEnabled() {
        return this.useLogScale;
    }

    protected void createDefaultPalette() {
        this.palette = new ChartColor[16];
        int i = 0;
        while (i < 16) {
            this.palette[i] = ChartColor.getDefaultColor(i);
            ++i;
        }
    }

    @Override
    public void setLegendPosition(int position) {
        this.legendPosition = position;
    }

    @Override
    public int getLegendPosition() {
        return this.legendPosition;
    }

    @Override
    public boolean isTranslucent() {
        return this.translucent;
    }

    @Override
    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }
}

