/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.views.helpers;

import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.ui.eclipse.usermanager.Messages;

public class UserLabelProvider
extends DecoratingLabelProvider
implements ITableLabelProvider {
    private static final String[] AUTH_METHOD;

    static {
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.UserLabelProvider_Password;
        Messages.get();
        stringArray[1] = Messages.UserLabelProvider_RADIUS;
        Messages.get();
        stringArray[2] = Messages.UserLabelProvider_Certificate;
        Messages.get();
        stringArray[3] = Messages.UserLabelProvider_CertificateOrPassword;
        Messages.get();
        stringArray[4] = Messages.UserLabelProvider_CertificateOrRADIUS;
        AUTH_METHOD = stringArray;
    }

    public UserLabelProvider() {
        super((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return columnIndex == 0 ? this.getImage(element) : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 5: {
                if (!(element instanceof User)) {
                    return "";
                }
                try {
                    return AUTH_METHOD[((User)element).getAuthMethod()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    Messages.get();
                    return Messages.UserLabelProvider_Unknown;
                }
            }
            case 3: {
                return ((AbstractUserObject)element).getDescription();
            }
            case 2: {
                return element instanceof User ? ((User)element).getFullName() : null;
            }
            case 6: {
                return ((AbstractUserObject)element).getGuid().toString();
            }
            case 7: {
                return ((AbstractUserObject)element).getLdapDn();
            }
            case 0: {
                return ((AbstractUserObject)element).getName();
            }
            case 4: {
                String string;
                if ((((AbstractUserObject)element).getFlags() & 0x80) != 0) {
                    Messages.get();
                    string = Messages.UserLabelProvider_LDAP;
                } else {
                    Messages.get();
                    string = Messages.UserLabelProvider_Local;
                }
                return string;
            }
            case 1: {
                String string;
                if (element instanceof User) {
                    Messages.get();
                    string = Messages.UserLabelProvider_User;
                } else {
                    Messages.get();
                    string = Messages.UserLabelProvider_Group;
                }
                return string;
            }
        }
        return null;
    }
}

