/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.ui.eclipse.perfview.views.helpers.GraphFolder;

public class GraphTreeContentProvider
implements ITreeContentProvider {
    private List<GraphSettings> input = null;
    private List<Object> list = new ArrayList<Object>();
    private Map<GraphSettings, GraphFolder> parentFolders = new HashMap<GraphSettings, GraphFolder>();

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GraphFolder) {
            return ((GraphFolder)parentElement).getChildObjects();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof GraphFolder) {
            return ((GraphFolder)element).getParent();
        }
        return this.parentFolders.get(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof GraphFolder) {
            return ((GraphFolder)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        this.updateModel();
        return this.list.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = (List)newInput;
        if (this.input != null) {
            Collections.sort(this.input, new Comparator<GraphSettings>(){

                @Override
                public int compare(GraphSettings arg0, GraphSettings arg1) {
                    return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
                }
            });
        }
        this.updateModel();
    }

    private void updateModel() {
        this.parentFolders.clear();
        this.list.clear();
        if (this.input != null) {
            HashMap<String, GraphFolder> folders = new HashMap<String, GraphFolder>();
            int i = 0;
            while (i < this.input.size()) {
                String[] path = this.input.get(i).getName().split("\\-\\>");
                Object root = null;
                int j = 0;
                while (j < path.length - 1) {
                    String key = String.valueOf(root == null ? "" : String.valueOf(root.hashCode()) + "@") + path[j].replace("&", "");
                    GraphFolder curr = (GraphFolder)folders.get(key);
                    if (curr == null) {
                        curr = new GraphFolder(path[j], (GraphFolder)root);
                        folders.put(key, curr);
                        if (root == null) {
                            this.list.add(curr);
                        } else {
                            ((GraphFolder)root).addFolder(curr);
                        }
                    }
                    root = curr;
                    ++j;
                }
                if (root == null) {
                    this.list.add(this.input.get(i));
                } else {
                    ((GraphFolder)root).addGraph(this.input.get(i));
                }
                this.parentFolders.put(this.input.get(i), (GraphFolder)root);
                ++i;
            }
        }
    }
}

