/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.Iterator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ServiceComponentsConfig;
import org.netxms.ui.eclipse.networkmaps.widgets.NetworkMapWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServiceComponentsElement
extends ElementWidget {
    private NetworkMapWidget mapWidget;
    private NetworkMapPage mapPage;
    private ServiceComponentsConfig config;
    private NXCSession session;

    protected ServiceComponentsElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = ServiceComponentsConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new ServiceComponentsConfig();
        }
        this.session = ConsoleSharedData.getSession();
        AbstractObject rootObject = this.session.findObjectById(this.config.getObjectId());
        this.mapPage = new NetworkMapPage("org.netxms.ui.eclipse.networkmaps.views.ServiceComponents" + rootObject.getObjectId());
        long elementId = this.mapPage.createElementId();
        this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, rootObject.getObjectId()));
        this.addServiceComponents(rootObject, elementId);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (this.mapPage != null) {
            this.mapWidget = new NetworkMapWidget((Composite)this, viewPart, 0);
            this.mapWidget.setLayoutAlgorithm(MapLayoutAlgorithm.SPARSE_VTREE);
            this.mapWidget.setContent(this.mapPage);
            this.mapWidget.zoomTo((double)this.config.getZoomLevel() / 100.0);
        }
        if (this.config.isObjectDoubleClickEnabled()) {
            this.mapWidget.enableObjectDoubleClick();
        }
    }

    private void addServiceComponents(AbstractObject object, long parentElementId) {
        Iterator it = object.getChildren();
        while (it.hasNext()) {
            long objectId = (Long)it.next();
            AbstractObject child = this.session.findObjectById(objectId);
            if (child == null || !(child instanceof Container) && !(child instanceof Cluster) && !(child instanceof Node) && !(child instanceof Condition)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(0, parentElementId, elementId));
            this.addServiceComponents(child, elementId);
        }
    }
}

