/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.ActionExecutionConfiguration;
import org.netxms.client.events.AlarmCategory;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.views.EventProcessingPolicyEditor;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.CGroup;
import org.netxms.ui.eclipse.widgets.helpers.DashboardElementButton;

public class RuleEditor
extends Composite {
    private static final int INDENT = 20;
    private EventProcessingPolicyRule rule;
    private int ruleNumber;
    private EventProcessingPolicyEditor editor;
    private NXCSession session;
    private WorkbenchLabelProvider labelProvider;
    private boolean collapsed = true;
    private boolean verticalLayout = false;
    private Composite leftPanel;
    private Label ruleNumberLabel;
    private Composite header;
    private Label headerLabel;
    private Composite mainArea;
    private CGroup condition;
    private CGroup action;
    private Label expandButton;
    private Label editButton;
    private boolean modified = false;
    private boolean selected = false;
    private boolean isDragged = false;
    private MouseListener ruleMouseListener;

    public RuleEditor(Composite parent, EventProcessingPolicyRule rule, EventProcessingPolicyEditor editor) {
        super(parent, 0);
        this.rule = rule;
        this.ruleNumber = rule.getRuleNumber();
        this.editor = editor;
        this.session = ConsoleSharedData.getSession();
        this.labelProvider = new WorkbenchLabelProvider();
        this.setBackground(SharedColors.getColor((String)"RuleEditor.Border.Rule", (Display)this.getDisplay()));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 1;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        this.setLayout((Layout)layout);
        this.ruleMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (RuleEditor.this.dragDetect(e)) {
                    RuleEditor.this.setDragged(true);
                }
                if (e.button == 3 && !RuleEditor.this.selected) {
                    RuleEditor.this.editor.setSelection(RuleEditor.this);
                }
            }

            public void mouseUp(MouseEvent e) {
                switch (e.button) {
                    case 1: {
                        RuleEditor.this.processRuleMouseEvent(e);
                        break;
                    }
                    default: {
                        if (RuleEditor.this.selected) break;
                        RuleEditor.this.editor.setSelection(RuleEditor.this);
                    }
                }
            }
        };
        this.createLeftPanel();
        this.createHeader();
        this.createMainArea();
        this.createPopupMenu(new Control[]{this.leftPanel, this.ruleNumberLabel, this.header, this.headerLabel});
        Messages.get();
        this.condition = new CGroup(this.mainArea, Messages.RuleEditor_Filter){

            protected Control createClientArea(Composite parent) {
                this.setBorderColor(SharedColors.getColor((String)"RuleEditor.Border.Condition", (Display)this.getDisplay()));
                this.setTitleColor(SharedColors.getColor((String)"RuleEditor.Title.Text", (Display)this.getDisplay()));
                return RuleEditor.this.createConditionControl(parent, RuleEditor.this.rule);
            }
        };
        this.configureLayout((Control)this.condition);
        Action editRuleCondition = new Action(){

            public void run() {
                RuleEditor.this.editRule("org.netxms.ui.eclipse.epp.propertypages.RuleCondition#0");
            }
        };
        Messages.get();
        this.condition.addButton(new DashboardElementButton(Messages.RuleEditor_EditCondition, editor.getImageEdit(), editRuleCondition));
        this.condition.setDoubleClickAction(editRuleCondition);
        Messages.get();
        this.action = new CGroup(this.mainArea, Messages.RuleEditor_Action){

            protected Control createClientArea(Composite parent) {
                this.setBorderColor(SharedColors.getColor((String)"RuleEditor.Border.Action", (Display)this.getDisplay()));
                this.setTitleColor(SharedColors.getColor((String)"RuleEditor.Title.Text", (Display)this.getDisplay()));
                return RuleEditor.this.createActionControl(parent, RuleEditor.this.rule);
            }
        };
        this.configureLayout((Control)this.action);
        Action editRuleAction = new Action(){

            public void run() {
                RuleEditor.this.editRule("org.netxms.ui.eclipse.epp.propertypages.RuleAction#1");
            }
        };
        Messages.get();
        this.action.addButton(new DashboardElementButton(Messages.RuleEditor_EditActions, editor.getImageEdit(), editRuleAction));
        this.action.setDoubleClickAction(editRuleAction);
        this.dragEnable();
        this.dropEnable();
    }

    private void dragEnable() {
        DragSource source = new DragSource((Control)this.headerLabel, 2);
        source.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        source.addDragListener((DragSourceListener)new RuleDragSourceListener(this));
    }

    private void dropEnable() {
        DropTarget target = new DropTarget((Control)this, 2);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new RuleDropTargetListener());
    }

    private void createMainArea() {
        this.mainArea = new Composite((Composite)this, 0);
        this.mainArea.setBackground(SharedColors.getColor((String)"RuleEditor.Background", (Display)this.getDisplay()));
        GridLayout layout = new GridLayout();
        layout.numColumns = this.verticalLayout ? 1 : 2;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        layout.makeColumnsEqualWidth = true;
        this.mainArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.exclude = this.collapsed;
        this.mainArea.setLayoutData((Object)gd);
    }

    private void createLeftPanel() {
        this.leftPanel = new Composite((Composite)this, 0);
        this.leftPanel.setBackground(SharedColors.getColor((String)(this.rule.isDisabled() ? "RuleEditor.Title.Disabled.Background" : "RuleEditor.Title.Normal.Background"), (Display)this.getDisplay()));
        this.leftPanel.addMouseListener(this.ruleMouseListener);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.leftPanel.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalSpan = this.collapsed ? 1 : 2;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.leftPanel.setLayoutData((Object)gd);
        this.ruleNumberLabel = new Label(this.leftPanel, 0);
        this.ruleNumberLabel.setText(Integer.toString(this.ruleNumber));
        this.ruleNumberLabel.setFont(this.editor.getBoldFont());
        this.ruleNumberLabel.setBackground(SharedColors.getColor((String)(this.rule.isDisabled() ? "RuleEditor.Title.Disabled.Background" : "RuleEditor.Title.Normal.Background"), (Display)this.getDisplay()));
        this.ruleNumberLabel.setForeground(SharedColors.getColor((String)"RuleEditor.Title.Text", (Display)this.getDisplay()));
        this.ruleNumberLabel.setAlignment(0x1000000);
        this.ruleNumberLabel.addMouseListener(this.ruleMouseListener);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 30;
        this.ruleNumberLabel.setLayoutData((Object)gd);
    }

    private void createPopupMenu(Control[] controls) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                RuleEditor.this.editor.fillRuleContextMenu(mgr);
            }
        });
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Menu menu = menuMgr.createContextMenu(c);
            c.setMenu(menu);
            ++n2;
        }
    }

    private void createHeader() {
        String string;
        MouseListener headerMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    RuleEditor.this.setCollapsed(!RuleEditor.this.isCollapsed(), true);
                }
            }

            public void mouseDown(MouseEvent e) {
                RuleEditor.this.ruleMouseListener.mouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                RuleEditor.this.ruleMouseListener.mouseUp(e);
            }
        };
        this.header = new Composite((Composite)this, 0);
        this.header.setBackground(SharedColors.getColor((String)(this.rule.isDisabled() ? "RuleEditor.Title.Disabled.Background" : "RuleEditor.Title.Normal.Background"), (Display)this.getDisplay()));
        this.header.addMouseListener(headerMouseListener);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.header.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.header.setLayoutData((Object)gd);
        this.headerLabel = new Label(this.header, 0);
        if (this.rule.isDisabled()) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.rule.getComments()));
            Messages.get();
            this.headerLabel.setText(stringBuilder.append(Messages.RuleEditor_DisabledSuffix).toString());
        } else {
            this.headerLabel.setText(this.rule.getComments());
        }
        this.headerLabel.setBackground(SharedColors.getColor((String)(this.rule.isDisabled() ? "RuleEditor.Title.Disabled.Background" : "RuleEditor.Title.Normal.Background"), (Display)this.getDisplay()));
        this.headerLabel.setForeground(SharedColors.getColor((String)"RuleEditor.Title.Text", (Display)this.getDisplay()));
        this.headerLabel.setFont(this.editor.getNormalFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.headerLabel.setLayoutData((Object)gd);
        this.headerLabel.addMouseListener(headerMouseListener);
        this.editButton = new Label(this.header, 0);
        this.editButton.setBackground(SharedColors.getColor((String)(this.rule.isDisabled() ? "RuleEditor.Title.Disabled.Background" : "RuleEditor.Title.Normal.Background"), (Display)this.getDisplay()));
        this.editButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.editButton.setImage(this.editor.getImageEdit());
        Messages.get();
        this.editButton.setToolTipText(Messages.RuleEditor_Tooltip_EditRule);
        this.editButton.addMouseListener(new MouseListener(){
            private boolean doAction = false;

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && this.doAction) {
                    RuleEditor.this.editRule("org.netxms.ui.eclipse.epp.propertypages.RuleComments#2");
                }
            }
        });
        this.expandButton = new Label(this.header, 0);
        this.expandButton.setBackground(SharedColors.getColor((String)(this.rule.isDisabled() ? "RuleEditor.Title.Disabled.Background" : "RuleEditor.Title.Normal.Background"), (Display)this.getDisplay()));
        this.expandButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.expandButton.setImage(this.collapsed ? this.editor.getImageExpand() : this.editor.getImageCollapse());
        if (this.collapsed) {
            Messages.get();
            string = Messages.RuleEditor_Tooltip_ExpandRule;
        } else {
            Messages.get();
            string = Messages.RuleEditor_Tooltip_CollapseRule;
        }
        this.expandButton.setToolTipText(string);
        this.expandButton.addMouseListener(new MouseListener(){
            private boolean doAction = false;

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && this.doAction) {
                    RuleEditor.this.setCollapsed(!RuleEditor.this.isCollapsed(), true);
                }
            }
        });
    }

    private void configureLayout(Control ctrl) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        ctrl.setLayoutData((Object)gd);
    }

    private MouseListener createMouseListener(final String pageId) {
        return new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                RuleEditor.this.editRule(pageId);
            }
        };
    }

    private Control createConditionControl(Composite parent, EventProcessingPolicyRule rule) {
        MouseListener listener;
        Composite clientArea = new Composite(parent, 0);
        clientArea.setBackground(SharedColors.getColor((String)"RuleEditor.Background", (Display)this.getDisplay()));
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        boolean needAnd = false;
        if (rule.getSources().size() > 0 && rule.isSourceInverted() || rule.getSources().size() == 0 && rule.getEvents().size() > 0 && rule.isEventsInverted()) {
            Messages.get();
            this.createLabel(clientArea, 0, true, Messages.RuleEditor_IF_NOT, null);
        } else {
            Messages.get();
            this.createLabel(clientArea, 0, true, Messages.RuleEditor_IF, null);
        }
        if (rule.getSources().size() > 0) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RuleSourceObjects#0");
            Messages.get();
            this.addConditionGroupLabel(clientArea, Messages.RuleEditor_SourceIs, needAnd, rule.isSourceInverted(), listener);
            for (Long id : rule.getSources()) {
                CLabel clabel = this.createCLabel(clientArea, 2, false);
                clabel.addMouseListener(listener);
                AbstractObject object = this.session.findObjectById(id.longValue());
                if (object != null) {
                    clabel.setText(object.getObjectName());
                    clabel.setImage(this.labelProvider.getImage((Object)object));
                    continue;
                }
                clabel.setText("[" + id.toString() + "]");
                clabel.setImage(SharedIcons.IMG_UNKNOWN_OBJECT);
            }
            needAnd = true;
        }
        if (rule.getEvents().size() > 0) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RuleEvents#10");
            Messages.get();
            this.addConditionGroupLabel(clientArea, Messages.RuleEditor_EventIs, needAnd, rule.isEventsInverted(), listener);
            ArrayList<EventTemplate> sortedEvents = new ArrayList<EventTemplate>(rule.getEvents().size());
            for (Long code : rule.getEvents()) {
                EventTemplate event = this.session.findEventTemplateByCode(code.longValue());
                if (event == null) {
                    event = new EventTemplate(code.longValue());
                    event.setSeverity(Severity.UNKNOWN);
                    event.setName("<" + code.toString() + ">");
                }
                sortedEvents.add(event);
            }
            Collections.sort(sortedEvents, new Comparator<EventTemplate>(){

                @Override
                public int compare(EventTemplate t1, EventTemplate t2) {
                    return t1.getName().compareToIgnoreCase(t2.getName());
                }
            });
            for (EventTemplate e : sortedEvents) {
                CLabel clabel = this.createCLabel(clientArea, 2, false);
                clabel.addMouseListener(listener);
                clabel.setText(e.getName());
                clabel.setImage(StatusDisplayInfo.getStatusImage((Severity)e.getSeverity()));
            }
            needAnd = true;
        }
        if ((rule.getFlags() & 0x1F00) != 7936) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RuleSeverityFilter#20");
            Messages.get();
            this.addConditionGroupLabel(clientArea, Messages.RuleEditor_SeverityIs, needAnd, false, listener);
            if ((rule.getFlags() & 0x100) != 0) {
                this.addSeverityLabel(clientArea, Severity.NORMAL, listener);
            }
            if ((rule.getFlags() & 0x200) != 0) {
                this.addSeverityLabel(clientArea, Severity.WARNING, listener);
            }
            if ((rule.getFlags() & 0x400) != 0) {
                this.addSeverityLabel(clientArea, Severity.MINOR, listener);
            }
            if ((rule.getFlags() & 0x800) != 0) {
                this.addSeverityLabel(clientArea, Severity.MAJOR, listener);
            }
            if ((rule.getFlags() & 0x1000) != 0) {
                this.addSeverityLabel(clientArea, Severity.CRITICAL, listener);
            }
            needAnd = true;
        }
        if (rule.getScript() != null && !rule.getScript().isEmpty()) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RuleFilterScript#30");
            Messages.get();
            this.addConditionGroupLabel(clientArea, Messages.RuleEditor_ScriptIs, needAnd, false, listener);
            ScriptEditor scriptEditor = new ScriptEditor(clientArea, 2048, 0);
            GridData gd = new GridData();
            gd.horizontalIndent = 40;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            scriptEditor.setLayoutData((Object)gd);
            scriptEditor.setText(rule.getScript());
            scriptEditor.getTextWidget().setEditable(false);
            scriptEditor.getTextWidget().addMouseListener(listener);
        }
        return clientArea;
    }

    private Label createLabel(Composite parent, int indent, boolean bold, String text, MouseListener mouseListener) {
        Label label = new Label(parent, 0);
        label.setBackground(SharedColors.getColor((String)"RuleEditor.Background", (Display)this.getDisplay()));
        label.setFont(bold ? this.editor.getBoldFont() : this.editor.getNormalFont());
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 20 * indent;
        label.setLayoutData((Object)gd);
        if (mouseListener != null) {
            label.addMouseListener(mouseListener);
        }
        return label;
    }

    private CLabel createCLabel(Composite parent, int indent, boolean bold) {
        CLabel label = new CLabel(parent, 0);
        label.setBackground(SharedColors.getColor((String)"RuleEditor.Background", (Display)this.getDisplay()));
        label.setFont(bold ? this.editor.getBoldFont() : this.editor.getNormalFont());
        GridData gd = new GridData();
        gd.horizontalIndent = 20 * indent;
        label.setLayoutData((Object)gd);
        return label;
    }

    private void addConditionGroupLabel(Composite parent, String title, boolean needAnd, boolean inverted, MouseListener mouseListener) {
        if (needAnd) {
            String string;
            if (inverted) {
                Messages.get();
                string = Messages.RuleEditor_AND_NOT;
            } else {
                Messages.get();
                string = Messages.RuleEditor_AND;
            }
            this.createLabel(parent, 0, true, string, null);
        }
        this.createLabel(parent, 1, false, title, mouseListener);
    }

    private void addSeverityLabel(Composite parent, Severity severity, MouseListener mouseListener) {
        CLabel clabel = this.createCLabel(parent, 2, false);
        clabel.setText(StatusDisplayInfo.getStatusText((Severity)severity));
        clabel.setImage(StatusDisplayInfo.getStatusImage((Severity)severity));
        clabel.addMouseListener(mouseListener);
    }

    private Control createActionControl(Composite parent, EventProcessingPolicyRule rule) {
        CLabel clabel;
        MouseListener listener;
        Composite clientArea = new Composite(parent, 0);
        clientArea.setBackground(SharedColors.getColor((String)"RuleEditor.Background", (Display)this.getDisplay()));
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        if ((rule.getFlags() & 8) != 0) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RuleAlarm#10");
            if (rule.getAlarmSeverity().compareTo((Enum)Severity.TERMINATE) < 0) {
                Messages.get();
                this.addActionGroupLabel(clientArea, Messages.RuleEditor_GenerateAlarm, this.editor.getImageAlarm(), listener);
                CLabel clabel2 = this.createCLabel(clientArea, 1, false);
                clabel2.setImage(StatusDisplayInfo.getStatusImage((Severity)rule.getAlarmSeverity()));
                clabel2.setText(rule.getAlarmMessage());
                clabel2.addMouseListener(listener);
                if (rule.getAlarmKey() != null && !rule.getAlarmKey().isEmpty()) {
                    Messages.get();
                    this.createLabel(clientArea, 1, false, String.format(Messages.RuleEditor_WithKey, rule.getAlarmKey()), null);
                }
            } else if (rule.getAlarmSeverity() == Severity.TERMINATE) {
                Messages.get();
                this.addActionGroupLabel(clientArea, Messages.RuleEditor_TerminateAlarms, this.editor.getImageTerminate(), listener);
                Messages.get();
                this.createLabel(clientArea, 1, false, String.format(Messages.RuleEditor_WithKey, rule.getAlarmKey()), listener);
                if ((rule.getFlags() & 0x20) != 0) {
                    Messages.get();
                    this.createLabel(clientArea, 1, false, Messages.RuleEditor_UserRegexpForTerminate, listener);
                }
            } else if (rule.getAlarmSeverity() == Severity.RESOLVE) {
                Messages.get();
                this.addActionGroupLabel(clientArea, Messages.RuleEditor_ResolveAlarms, this.editor.getImageTerminate(), listener);
                Messages.get();
                this.createLabel(clientArea, 1, false, String.format(Messages.RuleEditor_WithKey, rule.getAlarmKey()), listener);
                if ((rule.getFlags() & 0x20) != 0) {
                    Messages.get();
                    this.createLabel(clientArea, 1, false, Messages.RuleEditor_UseRegexpForResolve, listener);
                }
            }
            if (rule.getAlarmCategories().size() > 0) {
                this.createLabel(clientArea, 1, false, rule.getAlarmCategories().size() == 1 ? "with category: " : "with categories: ", null);
                for (Long id : rule.getAlarmCategories()) {
                    AlarmCategory category = this.editor.findAlarmCategoryById(id);
                    if (category == null) continue;
                    this.createLabel(clientArea, 2, false, category.getName(), null);
                }
            }
            if ((rule.getFlags() & 0x2000) != 0) {
                this.createLabel(clientArea, 1, false, "creates helpdesk ticket", null);
            }
        }
        if (rule.getPStorageSet().size() != 0 || rule.getPStorageDelete().size() != 0) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RulePStorage#20");
            this.addActionGroupLabel(clientArea, "Update persistent storage entries", this.editor.getImageSituation(), listener);
            if (rule.getPStorageSet().size() != 0) {
                this.createLabel(clientArea, 1, false, "Set Persistent storage values", listener);
                for (Map.Entry e : rule.getPStorageSet().entrySet()) {
                    this.createLabel(clientArea, 2, false, String.valueOf((String)e.getKey()) + " = \"" + (String)e.getValue() + "\"", listener);
                }
            }
            if (rule.getPStorageDelete().size() != 0) {
                this.createLabel(clientArea, 1, false, "Delete persistent storage values", listener);
                List pStorageList = rule.getPStorageDelete();
                int i = 0;
                while (i < pStorageList.size()) {
                    this.createLabel(clientArea, 2, false, (String)pStorageList.get(i), listener);
                    ++i;
                }
            }
        }
        if (!rule.getActions().isEmpty()) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RuleServerActions#30");
            Messages.get();
            this.addActionGroupLabel(clientArea, Messages.RuleEditor_ExecuteActions, this.editor.getImageExecute(), listener);
            for (ActionExecutionConfiguration c : rule.getActions()) {
                clabel = this.createCLabel(clientArea, 1, false);
                clabel.addMouseListener(listener);
                ServerAction action = this.editor.findActionById(c.getActionId());
                if (action != null) {
                    clabel.setText(action.getName());
                    clabel.setImage(this.labelProvider.getImage((Object)action));
                } else {
                    clabel.setText("<" + Long.toString(c.getActionId()) + ">");
                }
                if (c.getTimerDelay() <= 0) continue;
                clabel = this.createCLabel(clientArea, 2, false);
                clabel.addMouseListener(listener);
                if (c.getTimerKey().isEmpty()) {
                    clabel.setText(String.format("Delayed by %d seconds", c.getTimerDelay()));
                    continue;
                }
                clabel.setText(String.format("Delayed by %d seconds with timer key set to \"%s\"", c.getTimerDelay(), c.getTimerKey()));
            }
        }
        if (!rule.getTimerCancellations().isEmpty()) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RuleTimerCancellations#40");
            this.addActionGroupLabel(clientArea, "Cancel the following timers:", this.editor.getImageCancelTimer(), listener);
            for (String tc : rule.getTimerCancellations()) {
                clabel = this.createCLabel(clientArea, 1, false);
                clabel.addMouseListener(listener);
                clabel.setText(tc);
            }
        }
        if ((rule.getFlags() & 1) != 0) {
            listener = this.createMouseListener("org.netxms.ui.eclipse.epp.propertypages.RuleAction#1");
            Messages.get();
            this.addActionGroupLabel(clientArea, Messages.RuleEditor_StopProcessing, this.editor.getImageStop(), listener);
        }
        return clientArea;
    }

    private void addActionGroupLabel(Composite parent, String title, Image image, MouseListener mouseListener) {
        CLabel label = this.createCLabel(parent, 0, true);
        label.setImage(image);
        label.setText(title);
        label.addMouseListener(mouseListener);
    }

    public void dispose() {
        this.labelProvider.dispose();
        super.dispose();
    }

    public int getRuleNumber() {
        return this.ruleNumber;
    }

    public void setRuleNumber(int ruleNumber) {
        this.ruleNumber = ruleNumber;
        if (!this.isDisposed()) {
            this.ruleNumberLabel.setText(Integer.toString(ruleNumber));
            this.leftPanel.layout();
        }
    }

    public void setVerticalLayout(boolean verticalLayout, boolean doLayout) {
        this.verticalLayout = verticalLayout;
        GridLayout layout = (GridLayout)this.mainArea.getLayout();
        int n = layout.numColumns = verticalLayout ? 1 : 2;
        if (doLayout) {
            this.layout();
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed, boolean doLayout) {
        String string;
        this.collapsed = collapsed;
        this.expandButton.setImage(collapsed ? this.editor.getImageExpand() : this.editor.getImageCollapse());
        if (collapsed) {
            Messages.get();
            string = Messages.RuleEditor_Tooltip_ExpandRule;
        } else {
            Messages.get();
            string = Messages.RuleEditor_Tooltip_CollapseRule;
        }
        this.expandButton.setToolTipText(string);
        this.mainArea.setVisible(!collapsed);
        ((GridData)this.mainArea.getLayoutData()).exclude = collapsed;
        int n = ((GridData)this.leftPanel.getLayoutData()).verticalSpan = collapsed ? 1 : 2;
        if (doLayout) {
            this.editor.updateEditorAreaLayout();
        }
    }

    private static PropertyDialog createDialogOn(Shell shell, String propertyPageId, Object element, String name) {
        PropertyPageManager pageManager = new PropertyPageManager();
        String title = "";
        if (element == null) {
            return null;
        }
        PropertyPageContributorManager.getManager().contribute(pageManager, element);
        Iterator pages = pageManager.getElements(0).iterator();
        if (!pages.hasNext()) {
            MessageDialogHelper.openInformation((Shell)shell, (String)WorkbenchMessages.PropertyDialog_messageTitle, (String)NLS.bind((String)WorkbenchMessages.PropertyDialog_noPropertyMessage, (Object)name));
            return null;
        }
        title = NLS.bind((String)WorkbenchMessages.PropertyDialog_propertyMessage, (Object)name);
        PropertyDialog propertyDialog = new PropertyDialog(shell, (PreferenceManager)pageManager, (ISelection)new StructuredSelection(element)){

            protected TreeViewer createTreeViewer(Composite parent) {
                TreeViewer viewer = super.createTreeViewer(parent);
                viewer.expandAll();
                viewer.setAutoExpandLevel(-1);
                return viewer;
            }
        };
        if (propertyPageId != null) {
            propertyDialog.setSelectedNode(propertyPageId);
        }
        propertyDialog.create();
        propertyDialog.getShell().setText(title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)propertyDialog.getShell(), "org.eclipse.ui.property_dialog_context");
        return propertyDialog;
    }

    private void editRule(String pageId) {
        Shell shell = this.editor.getSite().getShell();
        Messages.get();
        PropertyDialog dlg = RuleEditor.createDialogOn(shell, pageId, (Object)this, String.valueOf(Messages.RuleEditor_Rule) + this.ruleNumber);
        if (dlg != null) {
            this.modified = false;
            dlg.open();
            if (this.modified) {
                if (this.rule.isDisabled()) {
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.rule.getComments()));
                    Messages.get();
                    this.headerLabel.setText(stringBuilder.append(Messages.RuleEditor_DisabledSuffix).toString());
                } else {
                    this.headerLabel.setText(this.rule.getComments());
                }
                this.updateBackground();
                this.condition.replaceClientArea();
                this.action.replaceClientArea();
                this.editor.updateEditorAreaLayout();
                this.editor.setModified(true);
            }
        }
    }

    public EventProcessingPolicyRule getRule() {
        return this.rule;
    }

    public boolean isDragged() {
        return this.isDragged;
    }

    public void setDragged(boolean isDragged) {
        this.isDragged = isDragged;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public EventProcessingPolicyEditor getEditorView() {
        return this.editor;
    }

    private void processRuleMouseEvent(MouseEvent e) {
        boolean shiftPressed;
        boolean ctrlPressed = (e.stateMask & 0x40000) != 0;
        boolean bl = shiftPressed = (e.stateMask & 0x20000) != 0;
        if (ctrlPressed) {
            this.editor.addToSelection(this, false);
        } else if (shiftPressed) {
            this.editor.addToSelection(this, true);
        } else {
            this.editor.setSelection(this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        Color color = SharedColors.getColor((String)(selected ? "RuleEditor.Title.Selected.Background" : (this.rule.isDisabled() ? "RuleEditor.Title.Disabled.Background" : "RuleEditor.Title.Normal.Background")), (Display)this.getDisplay());
        this.leftPanel.setBackground(color);
        Control[] controlArray = this.leftPanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBackground(color);
            ++n2;
        }
        this.leftPanel.redraw();
        this.header.setBackground(color);
        this.headerLabel.setBackground(color);
        this.expandButton.setBackground(color);
        this.editButton.setBackground(color);
        this.header.redraw();
    }

    public void enableRule(boolean enabled) {
        if (enabled == !this.rule.isDisabled()) {
            return;
        }
        if (enabled) {
            this.rule.setFlags(this.rule.getFlags() & 0xFFFFFFEF);
            this.headerLabel.setText(this.rule.getComments());
        } else {
            this.rule.setFlags(this.rule.getFlags() | 0x10);
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.rule.getComments()));
            Messages.get();
            this.headerLabel.setText(stringBuilder.append(Messages.RuleEditor_DisabledSuffix).toString());
        }
        this.modified = true;
        this.updateBackground();
        this.editor.setModified(true);
    }

    private void updateBackground() {
        Color color = SharedColors.getColor((String)(this.selected ? "RuleEditor.Title.Selected.Background" : (this.rule.isDisabled() ? "RuleEditor.Title.Disabled.Background" : "RuleEditor.Title.Normal.Background")), (Display)this.getDisplay());
        this.leftPanel.setBackground(color);
        Control[] controlArray = this.leftPanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBackground(color);
            ++n2;
        }
        this.header.setBackground(color);
        this.headerLabel.setBackground(color);
        this.expandButton.setBackground(color);
        this.editButton.setBackground(color);
    }

    private class RuleDragSourceListener
    implements DragSourceListener {
        private RuleEditor editor;

        public RuleDragSourceListener(RuleEditor editor) {
            this.editor = editor;
        }

        public void dragStart(DragSourceEvent event) {
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection((Object)this.editor));
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = LocalSelectionTransfer.getTransfer().getSelection();
        }
    }

    private class RuleDropTargetListener
    implements DropTargetListener {
        private RuleDropTargetListener() {
        }

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (!(event.data instanceof IStructuredSelection)) {
                return;
            }
            Object object = ((IStructuredSelection)event.data).getFirstElement();
            if (!(object instanceof RuleEditor)) {
                return;
            }
            RuleEditor.this.editor.moveSelection(RuleEditor.this);
        }
    }
}

