/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;

public class TableColumnDefinition {
    private String name;
    private String displayName;
    private int dataType;
    private boolean instanceColumn;

    public TableColumnDefinition(String name, String displayName, int dataType, boolean instanceColumn) {
        this.name = name;
        this.displayName = displayName != null ? displayName : name;
        this.dataType = dataType;
        this.instanceColumn = instanceColumn;
    }

    protected TableColumnDefinition(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId);
        this.dataType = msg.getFieldAsInt32(baseId + 1L);
        this.displayName = msg.getFieldAsString(baseId + 2L);
        if (this.displayName == null) {
            this.displayName = this.name;
        }
        this.instanceColumn = msg.getFieldAsBoolean(baseId + 3L);
    }

    protected void fillMessage(NXCPMessage msg, long baseId) {
        msg.setField(baseId, this.name);
        msg.setFieldInt32(baseId + 1L, this.dataType);
        msg.setField(baseId + 2L, this.displayName);
        msg.setFieldInt16(baseId + 3L, this.instanceColumn ? 1 : 0);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean isInstanceColumn() {
        return this.instanceColumn;
    }
}

