/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.client.datacollection.GraphSettings;

public class GraphFolder {
    private String name;
    private GraphFolder parent;
    private List<GraphFolder> subfolders;
    private List<GraphSettings> graphs;

    public GraphFolder(String name, GraphFolder parent) {
        this.name = name;
        this.parent = parent;
        this.subfolders = new ArrayList<GraphFolder>();
        this.graphs = new ArrayList<GraphSettings>();
    }

    public void clear() {
        this.subfolders.clear();
        this.graphs.clear();
    }

    public String getName() {
        return this.name;
    }

    public GraphFolder getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Object[] getChildObjects() {
        int i;
        Object[] objects = new Object[this.subfolders.size() + this.graphs.size()];
        int index = 0;
        for (i = 0; i < this.subfolders.size(); ++i) {
            objects[index++] = this.subfolders.get(i);
        }
        for (i = 0; i < this.graphs.size(); ++i) {
            objects[index++] = this.graphs.get(i);
        }
        return objects;
    }

    public boolean hasChildren() {
        return this.subfolders.size() > 0 || this.graphs.size() > 0;
    }

    public void addGraph(GraphSettings g) {
        this.graphs.add(g);
    }

    public void addFolder(GraphFolder f) {
        this.subfolders.add(f);
    }
}

