/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.util.Arrays;
import java.util.HashSet;
import org.netxms.websvc.WebSvcStatusService;
import org.netxms.websvc.handlers.AccessIntegrationTools;
import org.netxms.websvc.handlers.Alarms;
import org.netxms.websvc.handlers.GrafanaAlarms;
import org.netxms.websvc.handlers.GrafanaDataCollection;
import org.netxms.websvc.handlers.HistoricalData;
import org.netxms.websvc.handlers.LastValues;
import org.netxms.websvc.handlers.NotificationHandler;
import org.netxms.websvc.handlers.ObjectTools;
import org.netxms.websvc.handlers.Objects;
import org.netxms.websvc.handlers.PredefinedGraphs;
import org.netxms.websvc.handlers.Sessions;
import org.netxms.websvc.handlers.SummaryTableAdHoc;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.routing.Router;
import org.restlet.service.CorsService;
import org.restlet.service.Service;
import org.restlet.service.StatusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSvcApplication
extends Application {
    private Logger log = LoggerFactory.getLogger(WebSvcApplication.class);

    public WebSvcApplication() {
        CorsService corsService = new CorsService();
        corsService.setAllowedOrigins(new HashSet<String>(Arrays.asList("*")));
        corsService.setAllowedCredentials(true);
        corsService.setAllowedHeaders(new HashSet<String>(Arrays.asList("Content-Type", "Authorization")));
        corsService.setDefaultAllowedMethods(new HashSet<Method>(Arrays.asList(Method.DELETE, Method.GET, Method.OPTIONS, Method.POST, Method.PUT)));
        this.getServices().add((Service)corsService);
        this.setStatusService((StatusService)new WebSvcStatusService());
    }

    public synchronized Restlet createInboundRoot() {
        this.log.debug("createInboundRoot() called");
        Router router = new Router(this.getContext());
        router.attach("/alarms", Alarms.class);
        router.attach("/alarms/{id}", Alarms.class);
        router.attach("/authenticate", AccessIntegrationTools.class);
        router.attach("/grafana/alarms", GrafanaAlarms.class);
        router.attach("/grafana/datacollection", GrafanaDataCollection.class);
        router.attach("/objects", Objects.class);
        router.attach("/objects/{object-id}", Objects.class);
        router.attach("/objects/{object-id}/lastvalues", LastValues.class);
        router.attach("/objects/{object-id}/datacollection/{id}/values", HistoricalData.class);
        router.attach("/objects/{object-id}/objecttools", ObjectTools.class);
        router.attach("/objects/lastvalues", LastValues.class);
        router.attach("/objects/datacollection/values", HistoricalData.class);
        router.attach("/predefinedgraphs", PredefinedGraphs.class);
        router.attach("/sessions", Sessions.class);
        router.attach("/sessions/{id}", Sessions.class);
        router.attach("/summaryTable/adHoc", SummaryTableAdHoc.class);
        router.attach("/notifications", NotificationHandler.class);
        return router;
    }
}

