/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.policymanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class UninstallPolicy
implements IObjectActionDelegate {
    private Shell shell;
    private Set<AgentPolicy> currentSelection = new HashSet<AgentPolicy>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        ObjectSelectionDialog dlg;
        long[] rootObjects = null;
        Object value = ConsoleSharedData.getProperty((String)"PolicyManager.rootObjects");
        if (value != null && value instanceof long[]) {
            rootObjects = (long[])value;
        }
        if ((dlg = new ObjectSelectionDialog(this.shell, rootObjects, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false))).open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            for (final AgentPolicy policy : this.currentSelection) {
                Messages.get();
                new ConsoleJob(String.format(Messages.UninstallPolicy_JobName, policy.getObjectName()), null, "org.netxms.ui.eclipse.policymanager", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        AbstractObject[] nodeList = dlg.getSelectedObjects(Node.class);
                        StringBuilder sb = new StringBuilder();
                        int i = 0;
                        while (i < nodeList.length) {
                            try {
                                session.uninstallAgentPolicy(policy.getObjectId(), nodeList[i].getObjectId());
                            }
                            catch (NXCException e) {
                                if (e.getErrorCode() == 17 || e.getErrorCode() == 46 || e.getErrorCode() == 2 || e.getErrorCode() == 7) {
                                    if (sb.length() == 0) {
                                        sb.append("Could not apply policy to the node(s):\n");
                                    }
                                    sb.append(nodeList[i].getObjectName());
                                    sb.append(" - ");
                                    sb.append(e.getLocalizedMessage());
                                    sb.append("\n");
                                }
                                throw e;
                            }
                            ++i;
                        }
                        if (sb.length() != 0) {
                            final String error = sb.toString();
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openError((Shell)UninstallPolicy.this.shell, (String)"Error", (String)error);
                                }
                            });
                        }
                    }

                    protected String getErrorMessage() {
                        Messages.get();
                        return String.format(Messages.UninstallPolicy_JobError, policy.getObjectName());
                    }
                }.start();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (o instanceof AgentPolicy) {
                    this.currentSelection.add((AgentPolicy)o);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        } else {
            action.setEnabled(false);
        }
    }
}

