/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum ConnectionPointType {
    INDIRECT(0),
    DIRECT(1),
    WIRELESS(2),
    UNKNOWN(3);

    private int value;
    private static Map<Integer, ConnectionPointType> lookupTable;

    static {
        lookupTable = new HashMap<Integer, ConnectionPointType>();
        ConnectionPointType[] connectionPointTypeArray = ConnectionPointType.values();
        int n = connectionPointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionPointType element = connectionPointTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private ConnectionPointType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ConnectionPointType getByValue(int value) {
        ConnectionPointType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)ConnectionPointType.class.getName(), (String)("Unknown element " + value));
            return UNKNOWN;
        }
        return element;
    }
}

