/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.client.topology.Port;
import org.netxms.client.topology.VlanInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;

public class VlanLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color HIGHLIGHT = new Color((Device)Display.getDefault(), 255, 216, 0);
    private NXCSession session = ConsoleSharedData.getSession();
    private PortInfo selectedPort = null;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        VlanInfo vlan = (VlanInfo)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(vlan.getVlanId());
            }
            case 1: {
                return vlan.getName();
            }
            case 2: {
                return this.buildPortList(vlan);
            }
        }
        return null;
    }

    private String buildPortList(VlanInfo vlan) {
        int lastPort;
        ArrayList<Port> ports = new ArrayList<Port>(Arrays.asList(vlan.getPorts()));
        if (ports.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Port> physicalPorts = new ArrayList<Port>();
        Iterator it = ports.iterator();
        while (it.hasNext()) {
            Port p = (Port)it.next();
            Interface iface = (Interface)this.session.findObjectById(p.getObjectId(), Interface.class);
            if (iface != null) {
                if (!iface.isPhysicalPort()) {
                    Interface parent = iface.getParentInterface();
                    if (parent != null && parent.isPhysicalPort()) {
                        physicalPorts.add(new Port(parent.getObjectId(), (long)parent.getIfIndex(), parent.getSlot(), parent.getPort()));
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(iface.getObjectName());
                    it.remove();
                    continue;
                }
                physicalPorts.add(p);
                continue;
            }
            physicalPorts.add(p);
        }
        if (physicalPorts.size() == 0) {
            return sb.toString();
        }
        Collections.sort(physicalPorts, new Comparator<Port>(){

            @Override
            public int compare(Port p1, Port p2) {
                return p1.getSlot() == p2.getSlot() ? p1.getPort() - p2.getPort() : p1.getSlot() - p2.getSlot();
            }
        });
        int slot = ((Port)physicalPorts.get(0)).getSlot();
        int firstPort = lastPort = ((Port)ports.get(0)).getPort();
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(slot);
        sb.append('/');
        sb.append(firstPort);
        int i = 1;
        while (i < physicalPorts.size()) {
            if (((Port)physicalPorts.get(i)).getSlot() == slot && ((Port)physicalPorts.get(i)).getPort() == lastPort + 1) {
                ++lastPort;
            } else {
                if (((Port)physicalPorts.get(i - 1)).getPort() != firstPort) {
                    if (lastPort - firstPort > 1) {
                        sb.append('-');
                    } else {
                        sb.append(',');
                    }
                    sb.append(slot);
                    sb.append('/');
                    sb.append(lastPort);
                }
                slot = ((Port)physicalPorts.get(i)).getSlot();
                firstPort = lastPort = ((Port)physicalPorts.get(i)).getPort();
                sb.append(',');
                sb.append(slot);
                sb.append('/');
                sb.append(lastPort);
            }
            ++i;
        }
        if (((Port)physicalPorts.get(i - 1)).getPort() != firstPort) {
            if (lastPort - firstPort > 1) {
                sb.append('-');
            } else {
                sb.append(',');
            }
            sb.append(slot);
            sb.append('/');
            sb.append(lastPort);
        }
        return sb.toString();
    }

    public boolean setSelectedPort(PortInfo selectedPort) {
        if (selectedPort == this.selectedPort) {
            return false;
        }
        this.selectedPort = selectedPort;
        return true;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return this.selectedPort != null && ((VlanInfo)element).containsPort(this.selectedPort.getSlot(), this.selectedPort.getPort()) ? HIGHLIGHT : null;
    }
}

