/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;

public class IntegerConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS;
    private Text value1;
    private Text value2;
    private Label andLabel;

    static {
        String[] stringArray = new String[7];
        Messages.get();
        stringArray[0] = Messages.IntegerConditionEditor_Equal;
        Messages.get();
        stringArray[1] = Messages.IntegerConditionEditor_NotEqual;
        stringArray[2] = "<";
        stringArray[3] = "<=";
        stringArray[4] = ">=";
        stringArray[5] = ">";
        Messages.get();
        stringArray[6] = Messages.IntegerConditionEditor_Between;
        OPERATIONS = stringArray;
    }

    public IntegerConditionEditor(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(Composite parent, ColumnFilter initialFilter) {
        Composite group = new Composite((Composite)this, 0);
        RowLayout layout = new RowLayout();
        layout.type = 256;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        this.value1 = this.toolkit.createText(group, "0");
        RowData rd = new RowData();
        rd.width = 90;
        this.value1.setLayoutData((Object)rd);
        Messages.get();
        this.andLabel = this.toolkit.createLabel(group, Messages.IntegerConditionEditor_And);
        this.andLabel.setVisible(false);
        this.value2 = this.toolkit.createText(group, "0");
        rd = new RowData();
        rd.width = 90;
        this.value2.setLayoutData((Object)rd);
        this.value2.setVisible(false);
        if (initialFilter != null) {
            switch (initialFilter.getType()) {
                case EQUALS: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
                    this.value1.setText(Long.toString(initialFilter.getNumericValue()));
                    break;
                }
                case GREATER: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 3 : 5);
                    this.value1.setText(Long.toString(initialFilter.getNumericValue()));
                    break;
                }
                case LESS: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 4 : 2);
                    this.value1.setText(Long.toString(initialFilter.getNumericValue()));
                    break;
                }
                case RANGE: {
                    this.setSelectedOperation(6);
                    this.andLabel.setVisible(true);
                    this.value2.setVisible(true);
                    this.value1.setText(Long.toString(initialFilter.getRangeFrom()));
                    this.value2.setText(Long.toString(initialFilter.getRangeTo()));
                    break;
                }
            }
        }
    }

    @Override
    protected void operationSelectionChanged(int selectionIndex) {
        if (selectionIndex == 6) {
            this.andLabel.setVisible(true);
            this.value2.setVisible(true);
        } else {
            this.andLabel.setVisible(false);
            this.value2.setVisible(false);
        }
    }

    @Override
    public ColumnFilter createFilter() {
        ColumnFilter filter;
        long n1;
        try {
            n1 = Long.parseLong(this.value1.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n1 = 0L;
        }
        switch (this.getSelectedOperation()) {
            case 1: {
                filter = new ColumnFilter(ColumnFilterType.EQUALS, n1);
                filter.setNegated(true);
                break;
            }
            case 2: {
                filter = new ColumnFilter(ColumnFilterType.LESS, n1);
                break;
            }
            case 3: {
                filter = new ColumnFilter(ColumnFilterType.GREATER, n1);
                filter.setNegated(true);
                break;
            }
            case 4: {
                filter = new ColumnFilter(ColumnFilterType.LESS, n1);
                filter.setNegated(true);
                break;
            }
            case 5: {
                filter = new ColumnFilter(ColumnFilterType.GREATER, n1);
                break;
            }
            case 6: {
                long n2;
                try {
                    n2 = Long.parseLong(this.value2.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0L;
                }
                filter = new ColumnFilter(n1, n2);
                break;
            }
            default: {
                filter = new ColumnFilter(ColumnFilterType.EQUALS, n1);
            }
        }
        return filter;
    }
}

