/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.ScheduledTask;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ScheduleTableEntryLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color COLOR_DISABLED = new Color((Device)Display.getDefault(), new RGB(126, 137, 185));
    private static final Color COLOR_SYSTEM = new Color((Device)Display.getDefault(), new RGB(196, 170, 94));
    private static final int EXECUTED = 0;
    private static final int PENDING = 1;
    private static final int DISBALED = 2;
    private NXCSession session = ConsoleSharedData.getSession();
    private WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();
    private Image[] statusImages = new Image[3];

    public ScheduleTableEntryLabelProvider() {
        this.statusImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.statusImages[1] = Activator.getImageDescriptor("icons/pending.gif").createImage();
        this.statusImages[2] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ScheduledTask task = (ScheduledTask)element;
        switch (columnIndex) {
            case 0: {
                if (task.isDisabled()) {
                    return this.statusImages[2];
                }
                if ((task.getFlags() & 2) != 0 || (task.getFlags() & 4) != 0) {
                    return this.statusImages[0];
                }
                return this.statusImages[1];
            }
            case 2: {
                if (task.getObjectId() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(((ScheduledTask)element).getObjectId());
                return object != null ? this.wbLabelProvider.getImage((Object)object) : null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ScheduledTask task = (ScheduledTask)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(task.getId());
            }
            case 1: {
                return task.getTaskHandlerId();
            }
            case 2: {
                if (task.getObjectId() == 0L) {
                    return "";
                }
                AbstractObject object = this.session.findObjectById(task.getObjectId());
                return object != null ? object.getObjectName() : "[" + Long.toString(task.getObjectId()) + "]";
            }
            case 3: {
                return task.getParameters();
            }
            case 4: {
                return task.getSchedule().isEmpty() ? RegionalSettings.getDateTimeFormat().format(task.getExecutionTime()) : task.getSchedule();
            }
            case 5: {
                return task.getLastExecutionTime().getTime() == 0L ? "" : RegionalSettings.getDateTimeFormat().format(task.getLastExecutionTime());
            }
            case 6: {
                return task.getStatus();
            }
            case 7: {
                return task.isDisabled() ? "Disabled" : "Enabled";
            }
            case 8: {
                if ((task.getFlags() & 8) != 0) {
                    return "system";
                }
                AbstractUserObject user = this.session.findUserDBObjectById(task.getOwner());
                return user != null ? user.getName() : "[" + Long.toString(task.getOwner()) + "]";
            }
            case 9: {
                return task.getComments();
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (((ScheduledTask)element).isDisabled()) {
            return COLOR_DISABLED;
        }
        if (((ScheduledTask)element).isSystem()) {
            return COLOR_SYSTEM;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

