/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.api.ObjectDetailsProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.RefreshTimer;
import org.netxms.ui.eclipse.widgets.FilterText;

public abstract class AbstractObjectStatusMap
extends Composite
implements ISelectionProvider {
    protected IViewPart viewPart;
    protected long rootObjectId;
    protected NXCSession session;
    protected FilterText filterTextControl;
    protected ISelection selection = null;
    protected Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    protected MenuManager menuManager;
    protected boolean filterEnabled = true;
    protected int severityFilter = 255;
    protected String textFilter = "";
    protected SortedMap<Integer, ObjectDetailsProvider> detailsProviders = new TreeMap<Integer, ObjectDetailsProvider>();
    protected Set<Runnable> refreshListeners = new HashSet<Runnable>();
    protected RefreshTimer refreshTimer;
    protected boolean fitToScreen;
    private Composite content;
    private ScrolledComposite scroller;

    public AbstractObjectStatusMap(IViewPart viewPart, Composite parent, int style, boolean allowFilterClose) {
        super(parent, style);
        this.initDetailsProviders();
        this.viewPart = viewPart;
        this.session = ConsoleSharedData.getSession();
        final SessionListener sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4) {
                    AbstractObjectStatusMap.this.onObjectChange((AbstractObject)n.getObject());
                } else if (n.getCode() == 99) {
                    AbstractObjectStatusMap.this.onObjectDelete(n.getSubCode());
                }
            }
        };
        this.session.addListener(sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractObjectStatusMap.this.session.removeListener(sessionListener);
            }
        });
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)this.getDisplay()));
        this.filterTextControl = new FilterText((Composite)this, 0, null, allowFilterClose);
        this.filterTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractObjectStatusMap.this.onFilterModify();
            }
        });
        this.filterTextControl.setCloseAction(new Action(){

            public void run() {
                AbstractObjectStatusMap.this.enableFilter(false);
            }
        });
        this.scroller = new ScrolledComposite((Composite)this, 768);
        this.scroller.setBackground(this.getBackground());
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                AbstractObjectStatusMap.this.updateScrollBars();
            }
        });
        this.scroller.getVerticalBar().setIncrement(30);
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractObjectStatusMap.this.fillContextMenu(manager);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterTextControl);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.scroller.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterTextControl.setLayoutData((Object)fd);
        if (this.filterEnabled) {
            this.filterTextControl.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.content = this.createContent((Composite)this.scroller);
        this.scroller.setContent((Control)this.content);
        this.refreshTimer = new RefreshTimer(10000, (Control)this, new Runnable(){

            @Override
            public void run() {
                AbstractObjectStatusMap.this.refresh();
            }
        });
    }

    protected abstract Composite createContent(Composite var1);

    protected void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)(this.viewPart != null ? this.viewPart.getSite() : null), (ISelectionProvider)this);
    }

    public void setRootObject(long objectId) {
        this.rootObjectId = objectId;
        this.refresh();
    }

    protected boolean isAcceptedByFilter(AbstractObject object) {
        if ((1 << object.getStatus().getValue() & this.severityFilter) == 0) {
            return false;
        }
        if (!this.textFilter.isEmpty()) {
            boolean match = false;
            for (String s : object.getStrings()) {
                if (!s.toLowerCase().contains(this.textFilter)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    protected void filterObjects(Collection<AbstractObject> objects) {
        if ((this.severityFilter & 0x3F) == 63 && this.textFilter.isEmpty()) {
            return;
        }
        Iterator<AbstractObject> it = objects.iterator();
        while (it.hasNext()) {
            AbstractObject o = it.next();
            if (this.isAcceptedByFilter(o)) continue;
            it.remove();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener l : this.selectionListeners) {
            l.selectionChanged(event);
        }
    }

    private void initDetailsProviders() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectview.objectDetailsProvider");
        int i = 0;
        while (i < elements.length) {
            try {
                int priority;
                ObjectDetailsProvider provider = (ObjectDetailsProvider)elements[i].createExecutableExtension("class");
                try {
                    priority = Integer.parseInt(elements[i].getAttribute("priority"));
                }
                catch (NumberFormatException numberFormatException) {
                    priority = 65535;
                }
                this.detailsProviders.put(priority, provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void callDetailsProvider(AbstractObject object) {
        for (ObjectDetailsProvider p : this.detailsProviders.values()) {
            if (!p.canProvideDetails(object)) continue;
            p.provideDetails(object, this.viewPart);
            break;
        }
    }

    public int getSeverityFilter() {
        return this.severityFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    public void addRefreshListener(Runnable listener) {
        this.refreshListeners.add(listener);
    }

    public void removeRefreshListener(Runnable listener) {
        this.refreshListeners.remove(listener);
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterTextControl.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.scroller.getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterTextControl) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterTextControl.setFocus();
        } else {
            this.setFilterText("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterCloseAction(Action action) {
        this.filterTextControl.setCloseAction(action);
    }

    public void setFilterText(String text) {
        this.filterTextControl.setText(text);
        this.onFilterModify();
    }

    public String getFilterText() {
        return this.filterTextControl.getText();
    }

    private void onFilterModify() {
        String text = this.filterTextControl.getText().trim().toLowerCase();
        if (!this.textFilter.equals(text)) {
            this.textFilter = text;
            this.refresh();
        }
    }

    public abstract void refresh();

    protected abstract void onObjectChange(AbstractObject var1);

    protected abstract void onObjectDelete(long var1);

    protected abstract Point computeSize();

    protected static boolean isContainerObject(AbstractObject object) {
        return object instanceof Container || object instanceof Cluster || object instanceof Rack || object instanceof Chassis;
    }

    protected static boolean isLeafObject(AbstractObject object) {
        return object instanceof Node || object instanceof MobileDevice;
    }

    public void setFitToScreen(boolean fitToScreen) {
        this.fitToScreen = fitToScreen;
        this.refresh();
        this.updateScrollBars();
    }

    protected void updateScrollBars() {
        this.scroller.setMinSize(this.computeSize());
    }

    protected Rectangle getAvailableClientArea() {
        Rectangle rect = this.scroller.getClientArea();
        ScrollBar sb = this.scroller.getVerticalBar();
        if (sb != null) {
            rect.width -= sb.getSize().x;
        }
        if ((sb = this.scroller.getHorizontalBar()) != null) {
            rect.height -= sb.getSize().y;
        }
        return rect;
    }
}

