/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.PortViewConfig;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.widgets.DeviceView;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortSelectionListener;

public class PortViewElement
extends ElementWidget {
    private ScrolledComposite scroller;
    private Composite content;
    private Map<Long, DeviceView> deviceViews = new HashMap<Long, DeviceView>();
    private PortViewConfig config;
    private NXCSession session;
    private FocusListener focusListener;
    private ISelectionProvider selectionProvider;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private MenuManager popupMenuManager;

    public PortViewElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.session = ConsoleSharedData.getSession();
        try {
            this.config = PortViewConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new PortViewConfig();
        }
        this.selectionProvider = new ISelectionProvider(){

            public void setSelection(ISelection selection) {
                PortViewElement.this.selection = selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                PortViewElement.this.selectionListeners.remove(listener);
            }

            public ISelection getSelection() {
                return PortViewElement.this.selection;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                PortViewElement.this.selectionListeners.add(listener);
            }
        };
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                PortViewElement.this.setSelectionProviderDelegate(PortViewElement.this.selectionProvider);
            }
        };
        this.createPopupMenu();
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.scroller = new ScrolledComposite((Composite)this, 768);
        this.scroller.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)this.getDisplay()));
        this.content = new Composite((Composite)this.scroller, 0);
        this.content.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)this.getDisplay()));
        GridLayout contentLayout = new GridLayout();
        contentLayout.verticalSpacing = 12;
        this.content.setLayout((Layout)contentLayout);
        this.buildView();
        this.scroller.setContent((Control)this.content);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.getHorizontalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PortViewElement.this.scroller.setMinSize(PortViewElement.this.content.computeSize(-1, -1));
            }
        });
        final SessionListener sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() != 4) {
                    return;
                }
                AbstractObject object = (AbstractObject)n.getObject();
                if (n.getSubCode() == PortViewElement.this.config.getRootObjectId() || object.isChildOf(PortViewElement.this.config.getRootObjectId())) {
                    PortViewElement.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (PortViewElement.this.needRebuild()) {
                                for (DeviceView d : PortViewElement.this.deviceViews.values()) {
                                    d.dispose();
                                }
                                PortViewElement.this.deviceViews.clear();
                                PortViewElement.this.buildView();
                                PortViewElement.this.content.layout(true, true);
                                PortViewElement.this.scroller.setMinSize(PortViewElement.this.content.computeSize(-1, -1));
                            }
                        }
                    });
                }
            }
        };
        this.session.addListener(sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PortViewElement.this.session.removeListener(sessionListener);
            }
        });
    }

    private void buildView() {
        AbstractObject root = this.session.findObjectById(this.config.getRootObjectId());
        if (root instanceof Node) {
            if (((Node)root).isBridge()) {
                this.addDeviceView((Node)root);
            }
        } else {
            ArrayList nodes = new ArrayList(root.getAllChilds(2));
            Collections.sort(nodes, new Comparator<AbstractObject>(){

                @Override
                public int compare(AbstractObject o1, AbstractObject o2) {
                    return o1.getObjectName().compareToIgnoreCase(o2.getObjectName());
                }
            });
            for (AbstractObject o : nodes) {
                if (!((Node)o).isBridge()) continue;
                this.addDeviceView((Node)o);
            }
        }
    }

    private boolean needRebuild() {
        AbstractObject root = this.session.findObjectById(this.config.getRootObjectId());
        if (root instanceof Node) {
            return !this.deviceViews.containsKey(root.getObjectId()) && ((Node)root).isBridge() || this.deviceViews.containsKey(root.getObjectId()) && !((Node)root).isBridge();
        }
        Set nodes = root.getAllChilds(2);
        for (AbstractObject o : nodes) {
            if (!(((Node)o).isBridge() ? !this.deviceViews.containsKey(o.getObjectId()) : this.deviceViews.containsKey(o.getObjectId()))) continue;
            return true;
        }
        for (Long id : this.deviceViews.keySet()) {
            boolean found = false;
            for (AbstractObject o : nodes) {
                if (o.getObjectId() != id.longValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private void createPopupMenu() {
        this.popupMenuManager = new MenuManager();
        this.popupMenuManager.setRemoveAllWhenShown(true);
        this.popupMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectContextMenu.fill((IMenuManager)mgr, (IShellProvider)PortViewElement.this.viewPart.getSite(), (ISelectionProvider)PortViewElement.this.selectionProvider);
            }
        });
        this.viewPart.getSite().registerContextMenu(this.popupMenuManager, this.selectionProvider);
    }

    private void addDeviceView(Node n) {
        DeviceView d = new DeviceView(this.content, 0);
        d.setHeaderVisible(true);
        d.setNodeId(n.getObjectId());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        d.setLayoutData((Object)gd);
        Menu menu = this.popupMenuManager.createContextMenu((Control)d);
        d.setMenu(menu);
        d.addFocusListener(this.focusListener);
        d.addSelectionListener(new PortSelectionListener(){

            public void portSelected(PortInfo port) {
                if (port != null) {
                    Interface iface = (Interface)PortViewElement.this.session.findObjectById(port.getInterfaceObjectId(), Interface.class);
                    if (iface != null) {
                        PortViewElement.this.selection = (ISelection)new StructuredSelection((Object)iface);
                    } else {
                        PortViewElement.this.selection = (ISelection)new StructuredSelection();
                    }
                } else {
                    PortViewElement.this.selection = (ISelection)new StructuredSelection();
                }
                for (ISelectionChangedListener listener : PortViewElement.this.selectionListeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)PortViewElement.this.getSelectionProvider(), PortViewElement.this.selection));
                }
            }
        });
        this.deviceViews.put(n.getObjectId(), d);
    }
}

