/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.events.AlarmCategory;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmCategoryList;

public class AlarmCategorySelectionDialog
extends Dialog {
    public static final String JOB_FAMILY = "AlarmCategorySelectorJob";
    private static final String TABLE_CONFIG_PREFIX = "AlarmCategorySelectionDialog";
    private AlarmCategoryList alarmCategoryList;
    private IDialogSettings settings;
    private AlarmCategory[] selectedEvents;

    public AlarmCategorySelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select category");
        this.settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(this.settings.getInt("AlarmCategorySelectionDialog.cx"), this.settings.getInt("AlarmCategorySelectionDialog.cy"));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FormLayout());
        this.alarmCategoryList = new AlarmCategoryList(dialogArea, 0, TABLE_CONFIG_PREFIX, false);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.alarmCategoryList.setLayoutData(fd);
        this.alarmCategoryList.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AlarmCategorySelectionDialog.this.okPressed();
            }
        });
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button newButton = this.createButton(parent, 3, "New category...", false);
        newButton.setLayoutData((Object)new GridData(16384, 4, true, false));
        newButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                AlarmCategorySelectionDialog.this.alarmCategoryList.createCategory();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 1, "Cancel", true);
        this.createButton(parent, 0, "OK", true);
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmCategoryList.getSelection();
        List list = selection.toList();
        this.selectedEvents = list.toArray(new AlarmCategory[list.size()]);
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        this.settings.put("AlarmCategorySelectionDialog.cx", size.x);
        this.settings.put("AlarmCategorySelectionDialog.cy", size.y);
        this.settings.put("AlarmCategorySelectionDialog.Filter", this.alarmCategoryList.getFilterText());
    }

    public AlarmCategory[] getSelectedCategories() {
        return this.selectedEvents;
    }
}

