/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.layout.impl;

import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.LayoutFactory;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.impl.BlockImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class LabelBlockImpl
extends BlockImpl
implements LabelBlock {
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    protected Label label;

    protected LabelBlockImpl() {
    }

    protected EClass eStaticClass() {
        return LayoutPackage.Literals.LABEL_BLOCK;
    }

    public Label getLabel() {
        return this.label;
    }

    public NotificationChain basicSetLabel(Label newLabel, NotificationChain msgs) {
        Label oldLabel = this.label;
        this.label = newLabel;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldLabel, (Object)newLabel);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setLabel(Label newLabel) {
        if (newLabel != this.label) {
            NotificationChain msgs = null;
            if (this.label != null) {
                msgs = ((InternalEObject)this.label).eInverseRemove((InternalEObject)this, -18, null, msgs);
            }
            if (newLabel != null) {
                msgs = ((InternalEObject)newLabel).eInverseAdd((InternalEObject)this, -18, null, msgs);
            }
            if ((msgs = this.basicSetLabel(newLabel, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)newLabel, (Object)newLabel));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 17: {
                return this.basicSetLabel(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 17: {
                return this.getLabel();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 17: {
                this.setLabel((Label)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 17: {
                this.setLabel(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 17: {
                return this.label != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public static Block create() {
        LabelBlock lb = LayoutFactory.eINSTANCE.createLabelBlock();
        ((LabelBlockImpl)lb).initialize();
        return lb;
    }

    protected void initialize() {
        super.initialize();
        this.setLabel(LabelImpl.create());
    }

    public static Block createDefault() {
        LabelBlock lb = LayoutFactory.eINSTANCE.createLabelBlock();
        ((LabelBlockImpl)lb).initDefault();
        return lb;
    }

    protected void initDefault() {
        super.initDefault();
        this.setLabel(LabelImpl.createDefault());
    }

    public final Size getPreferredSize(IDisplayServer xs, Chart cm, RunTimeContext rtc) throws ChartException {
        BoundingBox bb = this.computeBox(xs, rtc);
        Size sz = SizeImpl.create(bb.getWidth(), bb.getHeight());
        sz.scale(72.0 / (double)xs.getDpiResolution());
        Insets ins = this.getInsets();
        sz.setHeight(sz.getHeight() + ins.getTop() + ins.getBottom());
        sz.setWidth(sz.getWidth() + ins.getLeft() + ins.getRight());
        return sz;
    }

    protected BoundingBox computeBox(IDisplayServer xs, RunTimeContext rtc) throws ChartException {
        Label la = this.getLabel().copyInstance();
        String sPreviousValue = this.getLabel().getCaption().getValue();
        la.getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
        IChartComputation cComp = rtc.getState(RunTimeContext.StateKey.CHART_COMPUTATION_KEY);
        return cComp.computeBox(xs, 4, la, 0.0, 0.0);
    }

    public LabelBlock copyInstance() {
        LabelBlockImpl dest = new LabelBlockImpl();
        dest.set(this);
        return dest;
    }

    protected void set(LabelBlock src) {
        super.set(src);
        if (src.getLabel() != null) {
            this.setLabel(src.getLabel().copyInstance());
        }
    }
}

