/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.IContainer;
import org.eclipse.gef4.zest.core.widgets.InternalLayoutContext;
import org.eclipse.gef4.zest.core.widgets.internal.AspectRatioFreeformLayer;
import org.eclipse.gef4.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.gef4.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class GraphContainer
extends GraphNode
implements IContainer {
    static final double SCALED_WIDTH = 300.0;
    static final double SCALED_HEIGHT = 200.0;
    private static final int CONTAINER_HEIGHT = 200;
    private static final int MIN_WIDTH = 250;
    private static final int MIN_HEIGHT = 30;
    private static final int ANIMATION_TIME = 100;
    private static final int SUBLAYER_OFFSET = 2;
    private static SelectionListener selectionListener;
    private ExpandGraphLabel expandGraphLabel;
    private List childNodes = null;
    private int childAreaHeight = 200;
    private ZestRootLayer zestLayer;
    private ScrollPane scrollPane;
    private LayoutAlgorithm layoutAlgorithm;
    private boolean isExpanded = false;
    private AspectRatioFreeformLayer scalledLayer;
    private InternalLayoutContext layoutContext;

    public GraphContainer(Graph graph, int style) {
        super(graph, style);
        this.initModel(graph, "", null);
        this.close(false);
        this.childNodes = new ArrayList();
        this.registerToParent(graph);
    }

    public GraphContainer(Graph graph, int style, String text, Image image) {
        this(graph, style);
        this.setText(text);
        this.setImage(image);
    }

    public GraphContainer(GraphContainer container, int style) {
        this(container.getGraph(), style);
    }

    public void setCustomFigure(IFigure nodeFigure) {
        throw new RuntimeException("Operation not supported:  Containers cannot have custom figures");
    }

    public void close(boolean animate) {
        if (animate) {
            Animation.markBegin();
        }
        this.isExpanded = false;
        this.expandGraphLabel.setExpandedState(false);
        Rectangle newBounds = this.scrollPane.getBounds().getCopy();
        newBounds.height = 0;
        this.scrollPane.setSize(this.scrollPane.getSize().width, 0);
        this.updateFigureForModel((IFigure)this.zestLayer);
        this.scrollPane.setVisible(false);
        List children = this.zestLayer.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            IFigure child = (IFigure)iterator.next();
            GraphItem item = this.getGraph().getGraphItem(child);
            item.setVisible(false);
        }
        Rectangle containerBounds = new Rectangle(this.getLocation(), new Dimension(this.getSize().width, 200 + this.expandGraphLabel.getSize().height));
        this.moveNodesUp(containerBounds, this);
        if (animate) {
            Animation.run((int)100);
        }
        this.updateFigureForModel(this.nodeFigure);
    }

    private static void addNodeToOrderedList(List orderedNodeList, GraphNode node) {
        Iterator orderedNodeIterator = orderedNodeList.iterator();
        int counter = 0;
        while (orderedNodeIterator.hasNext()) {
            GraphNode nextOrderedNode = (GraphNode)((Object)orderedNodeIterator.next());
            if (nextOrderedNode.getLocation().y + nextOrderedNode.getBounds().height > node.getLocation().y + node.getBounds().height) break;
            ++counter;
        }
        orderedNodeList.add(counter, node);
    }

    private static List getOrderedNodesBelowY(List nodes, int yValue, GraphNode yValueNode) {
        Iterator iterator = nodes.iterator();
        LinkedList orderedNode = new LinkedList();
        while (iterator.hasNext()) {
            GraphNode node = (GraphNode)((Object)iterator.next());
            if (node == yValueNode || node.getLocation().y + node.getBounds().height <= yValue) continue;
            GraphContainer.addNodeToOrderedList(orderedNode, node);
        }
        ArrayList arrayList = new ArrayList();
        iterator = orderedNode.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    private static boolean nodeInStripe(int left, int right, GraphNode node) {
        return node.getBounds().x < right && node.getBounds().x + node.getBounds().width > left;
    }

    void pack(Graph g) {
        GraphNode highestNode = GraphContainer.getHighestNode(g);
        this.moveNodesUp(highestNode.getBounds(), highestNode);
    }

    static GraphNode getHighestNode(Graph g) {
        Iterator iterator = g.getNodes().iterator();
        GraphNode lowest = null;
        while (iterator.hasNext()) {
            GraphNode node = (GraphNode)((Object)iterator.next());
            if (lowest != null && lowest.getBounds().y <= node.getBounds().y) continue;
            lowest = node;
        }
        return lowest;
    }

    private void moveNodesUp(Rectangle containerBounds, GraphNode graphContainer) {
        List orderedNodesBelowY = GraphContainer.getOrderedNodesBelowY(this.parent.getGraph().getNodes(), containerBounds.y, graphContainer);
        int leftSide = containerBounds.x;
        int rightSide = containerBounds.x + containerBounds.width;
        LinkedList nodesToConsider = new LinkedList();
        int i = 0;
        while (i < orderedNodesBelowY.size()) {
            nodesToConsider.add(orderedNodesBelowY.get(i));
            ++i;
        }
        GraphContainer.addNodeToOrderedList(orderedNodesBelowY, graphContainer);
        while (nodesToConsider.size() > 0) {
            GraphNode node = (GraphNode)((Object)nodesToConsider.get(0));
            if (GraphContainer.nodeInStripe(leftSide, rightSide, node)) {
                leftSide = Math.min(leftSide, node.getBounds().x);
                rightSide = Math.max(rightSide, node.getBounds().x + node.getBounds().width);
                GraphNode previousNode = null;
                int i2 = 0;
                while (i2 < orderedNodesBelowY.size()) {
                    if (orderedNodesBelowY.get(i2) == node) break;
                    ++i2;
                }
                int j = i2 - 1;
                while (j >= 0) {
                    GraphNode pastNode = (GraphNode)((Object)orderedNodesBelowY.get(j));
                    if (GraphContainer.nodeInStripe(node.getBounds().x, node.getBounds().x + node.getBounds().width, pastNode)) {
                        previousNode = pastNode;
                        break;
                    }
                    --j;
                }
                if (previousNode == null) {
                    previousNode = graphContainer;
                }
                int previousLocation = previousNode.getBounds().y + previousNode.getBounds().height + 2;
                orderedNodesBelowY.remove(i2);
                node.setLocation(node.getLocation().x, previousLocation);
                GraphContainer.addNodeToOrderedList(orderedNodesBelowY, node);
            }
            nodesToConsider.remove((Object)node);
        }
    }

    public void open(boolean animate) {
        if (animate) {
            Animation.markBegin();
        }
        this.isExpanded = true;
        this.expandGraphLabel.setExpandedState(true);
        this.scrollPane.setSize(this.computeChildArea());
        this.scrollPane.setVisible(true);
        List children = this.zestLayer.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            IFigure child = (IFigure)iterator.next();
            GraphItem item = this.getGraph().getGraphItem(child);
            item.setVisible(true);
        }
        this.updateFigureForModel(this.nodeFigure);
        Rectangle containerBounds = new Rectangle(this.getLocation(), new Dimension(this.getSize().width, 200 + this.expandGraphLabel.getSize().height));
        this.moveNodesDown(containerBounds, this);
        this.moveNodesUp(containerBounds, this);
        if (animate) {
            Animation.run((int)100);
        }
        this.getFigure().getUpdateManager().performValidation();
    }

    private void moveNodesDown(Rectangle containerBounds, GraphContainer graphContainer) {
        List nodesBelowHere = GraphContainer.getOrderedNodesBelowY(this.parent.getGraph().getNodes(), containerBounds.y, graphContainer);
        Iterator nodesBelowHereIterator = nodesBelowHere.iterator();
        LinkedList<GraphNode> nodesToMove = new LinkedList<GraphNode>();
        int left = containerBounds.x;
        int right = containerBounds.x + containerBounds.width;
        while (nodesBelowHereIterator.hasNext()) {
            GraphNode node = (GraphNode)((Object)nodesBelowHereIterator.next());
            if (!GraphContainer.nodeInStripe(left, right, node)) continue;
            nodesToMove.add(node);
            left = Math.min(left, node.getBounds().x);
            right = Math.max(right, node.getBounds().x + node.getBounds().width);
        }
        List intersectingNodes = this.intersectingNodes(containerBounds, nodesToMove, graphContainer);
        int delta = this.getMaxMovement(containerBounds, intersectingNodes);
        if (delta > 0) {
            this.shiftNodesDown(nodesToMove, delta);
        }
    }

    private List intersectingNodes(Rectangle bounds, List nodesToCheck, GraphNode node) {
        LinkedList<GraphNode> result = new LinkedList<GraphNode>();
        Iterator nodes = nodesToCheck.iterator();
        while (nodes.hasNext()) {
            GraphNode nodeToCheck = (GraphNode)((Object)nodes.next());
            if (node == nodeToCheck || !bounds.intersects(nodeToCheck.getBounds())) continue;
            result.add(nodeToCheck);
        }
        return result;
    }

    private int getMaxMovement(Rectangle bounds, List nodesToMove) {
        Iterator iterator = nodesToMove.iterator();
        int maxMovement = 0;
        while (iterator.hasNext()) {
            GraphNode node = (GraphNode)((Object)iterator.next());
            int yValue = node.getLocation().y;
            int distanceFromBottom = bounds.y + bounds.height - yValue;
            maxMovement = Math.max(maxMovement, distanceFromBottom);
        }
        return maxMovement + 3;
    }

    private void shiftNodesDown(List nodesToShift, int amount) {
        Iterator iterator = nodesToShift.iterator();
        while (iterator.hasNext()) {
            GraphNode node = (GraphNode)((Object)iterator.next());
            node.setLocation(node.getLocation().x, node.getLocation().y + amount);
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Widget getItem() {
        return this;
    }

    public int getItemType() {
        return 3;
    }

    public void setLayoutAlgorithm(LayoutAlgorithm algorithm, boolean applyLayout) {
        this.layoutAlgorithm = algorithm;
        this.layoutAlgorithm.setLayoutContext((LayoutContext)this.getLayoutContext());
        if (applyLayout) {
            this.applyLayout();
        }
    }

    public InternalLayoutContext getLayoutContext() {
        if (this.layoutContext == null) {
            this.layoutContext = new InternalLayoutContext(this);
        }
        return this.layoutContext;
    }

    public DisplayIndependentRectangle getLayoutBounds() {
        double width = 290.0;
        double height = 190.0;
        return new DisplayIndependentRectangle(25.0, 25.0, width - 50.0, height - 50.0);
    }

    public void applyLayout() {
        if (this.layoutAlgorithm == null) {
            this.setLayoutAlgorithm((LayoutAlgorithm)new TreeLayoutAlgorithm(), false);
        }
        if (this.getGraph().animate) {
            Animation.markBegin();
        }
        this.layoutAlgorithm.applyLayout(true);
        this.layoutContext.flushChanges(false);
        if (this.getGraph().animate) {
            Animation.run((int)100);
        }
        this.getFigure().getUpdateManager().performUpdate();
    }

    public double getScale() {
        return this.scalledLayer.getScale();
    }

    public void setScale(double scale) {
        this.scalledLayer.setScale(scale);
    }

    protected void initFigure() {
        this.nodeFigure = this.createContainerFigure();
    }

    private Dimension computeChildArea() {
        ContainerDimension containerDimension = this.computeContainerSize();
        Dimension dimension = new Dimension();
        dimension.width = containerDimension.width;
        dimension.height = containerDimension.expandedHeight - containerDimension.labelHeight + 2;
        return dimension;
    }

    private ContainerDimension computeContainerSize() {
        ContainerDimension dimension = new ContainerDimension();
        int labelHeight = this.expandGraphLabel.getPreferredSize().height;
        int labelWidth = this.expandGraphLabel.getPreferredSize().width;
        if (labelWidth < 250) {
            labelWidth = 250;
            this.expandGraphLabel.setPreferredSize(labelWidth, labelHeight);
        }
        dimension.labelHeight = Math.max(labelHeight, 30);
        dimension.width = Math.max(labelWidth, this.size.width);
        dimension.expandedHeight = Math.max(dimension.labelHeight + this.childAreaHeight - 2, this.size.height);
        return dimension;
    }

    private double computeHeightScale() {
        Dimension childArea = this.computeChildArea();
        double heightScale = (double)childArea.height / 200.0;
        return heightScale;
    }

    private double computeWidthScale() {
        Dimension childArea = this.computeChildArea();
        double widthScale = (double)childArea.width / 300.0;
        return widthScale;
    }

    private IFigure createContainerFigure() {
        GraphContainer node = this;
        ContainerFigure containerFigure = new ContainerFigure();
        containerFigure.setOpaque(true);
        containerFigure.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        containerFigure.setLayoutManager((LayoutManager)new FreeformLayout());
        this.expandGraphLabel = new ExpandGraphLabel(this, node.getText(), node.getImage(), false);
        this.expandGraphLabel.setText(this.getText());
        this.expandGraphLabel.setImage(this.getImage());
        ContainerDimension containerDimension = this.computeContainerSize();
        this.scrollPane = new ScrollPane();
        this.scrollPane.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        FreeformViewport viewport = new FreeformViewport();
        this.scrollPane.setViewport((Viewport)viewport);
        viewport.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.scrollPane.setScrollBarVisibility(1);
        this.scalledLayer = new AspectRatioFreeformLayer("debug label");
        this.scalledLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.scalledLayer.setScale(this.computeWidthScale(), this.computeHeightScale());
        this.zestLayer = new ZestRootLayer();
        this.zestLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.scalledLayer.add((IFigure)this.zestLayer);
        this.zestLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.scrollPane.setSize(this.computeChildArea());
        this.scrollPane.setLocation(new Point(0, containerDimension.labelHeight - 2));
        this.scrollPane.setForegroundColor(ColorConstants.gray);
        this.expandGraphLabel.setBackgroundColor(this.getBackgroundColor());
        this.expandGraphLabel.setForegroundColor(this.getForegroundColor());
        this.expandGraphLabel.setLocation(new Point(0, 0));
        containerFigure.add((IFigure)this.scrollPane);
        containerFigure.add((IFigure)this.expandGraphLabel);
        this.scrollPane.getViewport().setContents((IFigure)this.scalledLayer);
        this.scrollPane.setBorder((Border)new LineBorder());
        return containerFigure;
    }

    private void registerToParent(IContainer parent) {
        if (parent.getItemType() == 0) {
            this.createSelectionListener();
            parent.getGraph().addSelectionListener(selectionListener);
        }
    }

    private void createSelectionListener() {
        if (selectionListener == null) {
            selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.item instanceof GraphContainer) {
                        ((GraphContainer)e.item).expandGraphLabel.setFocus();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
        }
    }

    protected void updateFigureForModel(IFigure currentFigure) {
        if (this.expandGraphLabel == null) {
            this.initFigure();
        }
        this.expandGraphLabel.setTextT(this.getText());
        this.expandGraphLabel.setImage(this.getImage());
        this.expandGraphLabel.setFont(this.getFont());
        if (this.highlighted == 1) {
            this.expandGraphLabel.setForegroundColor(this.getForegroundColor());
            this.expandGraphLabel.setBackgroundColor(this.getHighlightColor());
        } else {
            this.expandGraphLabel.setForegroundColor(this.getForegroundColor());
            this.expandGraphLabel.setBackgroundColor(this.getBackgroundColor());
        }
        ContainerDimension containerDimension = this.computeContainerSize();
        this.expandGraphLabel.setSize(containerDimension.width, containerDimension.labelHeight);
        if (this.isExpanded) {
            this.setSize(containerDimension.width, containerDimension.expandedHeight);
        } else {
            this.setSize(containerDimension.width, containerDimension.labelHeight);
        }
        this.scrollPane.setLocation(new Point(this.expandGraphLabel.getLocation().x, this.expandGraphLabel.getLocation().y + containerDimension.labelHeight - 2));
    }

    void refreshBounds() {
        if (this.nodeFigure == null || this.nodeFigure.getParent() == null) {
            return;
        }
        GraphContainer node = this;
        Point loc = node.getLocation();
        ContainerDimension containerDimension = this.computeContainerSize();
        Dimension size = new Dimension();
        this.expandGraphLabel.setSize(containerDimension.width, containerDimension.labelHeight);
        this.childAreaHeight = this.computeChildArea().height;
        if (this.isExpanded) {
            size.width = containerDimension.width;
            size.height = containerDimension.expandedHeight;
        } else {
            size.width = containerDimension.width;
            size.height = containerDimension.labelHeight;
        }
        Rectangle bounds = new Rectangle(loc, size);
        this.nodeFigure.getParent().setConstraint(this.nodeFigure, (Object)bounds);
        this.scrollPane.setLocation(new Point(this.expandGraphLabel.getLocation().x, this.expandGraphLabel.getLocation().y + containerDimension.labelHeight - 2));
        this.scrollPane.setSize(this.computeChildArea());
        this.scalledLayer.setScale(this.computeWidthScale(), this.computeHeightScale());
    }

    public void addSubgraphFigure(IFigure figure) {
        this.zestLayer.addSubgraph(figure);
        this.graph.subgraphFigures.add(figure);
    }

    void addConnectionFigure(IFigure figure) {
        this.nodeFigure.add(figure);
    }

    public void addNode(GraphNode node) {
        this.zestLayer.addNode(node.getNodeFigure());
        this.childNodes.add(node);
        node.setVisible(this.isExpanded);
    }

    public List getNodes() {
        return this.childNodes;
    }

    public List getConnections() {
        return this.filterConnections(this.getGraph().getConnections());
    }

    private List filterConnections(List connections) {
        ArrayList<GraphConnection> result = new ArrayList<GraphConnection>();
        Iterator iterator = connections.iterator();
        while (iterator.hasNext()) {
            GraphConnection connection = (GraphConnection)((Object)iterator.next());
            if (connection.getSource().getParent() != this || connection.getDestination().getParent() != this) continue;
            result.add(connection);
        }
        return result;
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    class ContainerDimension {
        int width;
        int labelHeight;
        int expandedHeight;

        ContainerDimension() {
        }
    }

    class ExpandGraphLabel
    extends Figure
    implements ActionListener {
        private boolean isExpanded;
        private Expander expander = new Expander();
        private Color darkerBackground;
        private final int arcWidth = 8;
        private final Label label;
        private final GraphContainer container;
        private final ToolbarLayout layout;

        public void setExpandedState(boolean expanded) {
            if (expanded) {
                this.expander.open();
            } else {
                this.expander.close();
            }
            this.isExpanded = expanded;
        }

        public void actionPerformed(ActionEvent event) {
            if (this.isExpanded) {
                this.container.close(GraphContainer.this.getGraph().animate);
            } else {
                this.container.open(GraphContainer.this.getGraph().animate);
            }
        }

        public ExpandGraphLabel(GraphContainer container, String text, Image image, boolean cacheLabel) {
            this.label = new Label(this, text){
                final /* synthetic */ ExpandGraphLabel this$1;
                {
                    this.this$1 = expandGraphLabel;
                }

                protected void paintFigure(Graphics graphics) {
                    if (this.isOpaque()) {
                        super.paintFigure(graphics);
                    }
                    Rectangle bounds = this.getBounds();
                    graphics.translate(bounds.x, bounds.y);
                    if (this.getIcon() != null) {
                        graphics.drawImage(this.getIcon(), this.getIconLocation());
                    }
                    if (!this.isEnabled()) {
                        graphics.translate(1, 1);
                        graphics.setForegroundColor(ColorConstants.buttonLightest);
                        graphics.drawText(this.getSubStringText(), this.getTextLocation());
                        graphics.translate(-1, -1);
                        graphics.setForegroundColor(ColorConstants.buttonDarker);
                    }
                    graphics.drawText(this.getText(), this.getTextLocation());
                    graphics.translate(-bounds.x, -bounds.y);
                }
            };
            this.setText(text);
            this.setImage(image);
            this.container = container;
            this.setFont(Display.getDefault().getSystemFont());
            this.layout = new ToolbarLayout(true);
            this.layout.setSpacing(5);
            this.layout.setMinorAlignment(0);
            this.setLayoutManager((LayoutManager)this.layout);
            this.add((IFigure)this.expander);
            this.add((IFigure)this.label);
        }

        private Color getDarkerBackgroundColor() {
            if (this.darkerBackground == null) {
                Color baseColor = this.getBackgroundColor();
                int blue = (int)((double)baseColor.getBlue() * 0.8 + 0.5);
                int red = (int)((double)baseColor.getRed() * 0.8 + 0.5);
                int green = (int)((double)baseColor.getGreen() * 0.8 + 0.5);
                this.darkerBackground = new Color((Device)Display.getCurrent(), new RGB(red, green, blue));
            }
            return this.darkerBackground;
        }

        public void paint(Graphics graphics) {
            graphics.setForegroundColor(this.getDarkerBackgroundColor());
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.pushState();
            Rectangle bounds = this.getBounds().getCopy();
            Rectangle r = bounds.getCopy();
            r.y += 4;
            r.height -= 8;
            Rectangle top = bounds.getCopy();
            top.height /= 2;
            graphics.setForegroundColor(this.getBackgroundColor());
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.fillRoundRectangle(top, 8, 8);
            top.y += top.height;
            graphics.setForegroundColor(this.darkerBackground);
            graphics.setBackgroundColor(this.darkerBackground);
            graphics.fillRoundRectangle(top, 8, 8);
            graphics.setBackgroundColor(this.darkerBackground);
            graphics.setForegroundColor(this.getBackgroundColor());
            graphics.fillGradient(r, true);
            super.paint(graphics);
            graphics.popState();
            graphics.setForegroundColor(this.darkerBackground);
            graphics.setBackgroundColor(this.darkerBackground);
            bounds.setSize(bounds.width - 1, bounds.height - 1);
            graphics.drawRoundRectangle(bounds, 8, 8);
        }

        public void setBackgroundColor(Color bg) {
            super.setBackgroundColor(bg);
            if (this.darkerBackground != null) {
                this.darkerBackground.dispose();
            }
            this.darkerBackground = null;
        }

        public void setTextT(String string) {
            this.setPreferredSize(null);
            this.label.setText(string);
            this.add((IFigure)this.label);
            this.layout.layout((IFigure)this);
            this.invalidate();
            this.revalidate();
            this.validate();
        }

        public void setText(String string) {
            this.label.setText(string);
        }

        public void setImage(Image image) {
            this.label.setIcon(image);
        }

        public void setFocus() {
            this.expander.requestFocus();
        }

        class Expander
        extends Clickable {
            private Triangle triangle;

            public Expander() {
                this.setStyle(Clickable.STYLE_TOGGLE);
                this.triangle = new Triangle();
                this.triangle.setSize(10, 10);
                this.triangle.setBackgroundColor(ColorConstants.black);
                this.triangle.setForegroundColor(ColorConstants.black);
                this.triangle.setFill(true);
                this.triangle.setDirection(16);
                this.triangle.setLocation(new Point(5, 3));
                this.setLayoutManager((LayoutManager)new FreeformLayout());
                this.add((IFigure)this.triangle);
                this.setPreferredSize(15, 15);
                this.addActionListener(ExpandGraphLabel.this);
            }

            public void open() {
                this.triangle.setDirection(4);
            }

            public void close() {
                this.triangle.setDirection(16);
            }
        }
    }
}

