/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.animation;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.nebula.animation.AnimationRunner;
import org.netxms.nebula.animation.effects.IEffect;
import org.netxms.nebula.animation.effects.MoveScrollBarEffect;
import org.netxms.nebula.animation.movement.IMovement;

public class ScrollingSmoother {
    Scrollable component;
    ScrollBar verticalScrollBar;
    ScrollBar horizontalScrollBar;
    IMovement movement = null;
    int duration = 2000;
    AnimationRunner animationRunner = new AnimationRunner();
    Listener mouseWheelListener = new Listener(){

        public void handleEvent(Event event) {
            int start;
            event.doit = false;
            ScrollBar currentScrollBar = ScrollingSmoother.this.getScrollbar(event);
            int end = start = currentScrollBar.getSelection();
            IEffect current = ScrollingSmoother.this.animationRunner.getEffect();
            if (current instanceof MoveScrollBarEffect) {
                MoveScrollBarEffect mseffect = (MoveScrollBarEffect)current;
                start = mseffect.getCurrent();
                end = mseffect.getEnd();
            }
            if ((end -= event.count * currentScrollBar.getIncrement()) > currentScrollBar.getMaximum() - currentScrollBar.getThumb()) {
                end = currentScrollBar.getMaximum() - currentScrollBar.getThumb();
            }
            if (end < currentScrollBar.getMinimum()) {
                end = currentScrollBar.getMinimum();
            }
            ScrollingSmoother.this.animationRunner.runEffect(new MoveScrollBarEffect(currentScrollBar, start, end, ScrollingSmoother.this.duration, ScrollingSmoother.this.movement, null, null));
        }
    };
    SelectionListener cancelEffectIfUserSelection = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (!(e.data instanceof MoveScrollBarEffect)) {
                ScrollingSmoother.this.animationRunner.cancel();
            }
        }
    };

    public ScrollingSmoother(Scrollable c2, IMovement movement) {
        this.component = c2;
        this.verticalScrollBar = c2.getVerticalBar();
        this.horizontalScrollBar = c2.getHorizontalBar();
        this.movement = movement;
    }

    public ScrollingSmoother(Scrollable c2, IMovement movement, int duration) {
        this(c2, movement);
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setFPS(int fps) {
        this.animationRunner = new AnimationRunner(fps);
    }

    protected ScrollBar getScrollbar(Event event) {
        ScrollBar result = this.verticalScrollBar;
        if (result == null) {
            result = this.horizontalScrollBar;
        }
        return result;
    }

    public void smoothControl(boolean enable) {
        if (enable) {
            this.component.addListener(37, this.mouseWheelListener);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.addSelectionListener(this.cancelEffectIfUserSelection);
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.addSelectionListener(this.cancelEffectIfUserSelection);
            }
        } else {
            this.component.removeListener(37, this.mouseWheelListener);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.removeSelectionListener(this.cancelEffectIfUserSelection);
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.removeSelectionListener(this.cancelEffectIfUserSelection);
            }
        }
    }
}

