/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum AuthenticationType {
    PASSWORD(0),
    CERTIFICATE(1),
    SSO_TICKET(2);

    private int value;
    private static Map<Integer, AuthenticationType> lookupTable;

    private AuthenticationType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AuthenticationType getByValue(int value) {
        AuthenticationType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning(AuthenticationType.class.getName(), "Unknown element " + value);
            return PASSWORD;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, AuthenticationType>();
        for (AuthenticationType element : AuthenticationType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

