/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpTrapParameterMapping;

public class SnmpTrap {
    private long id;
    private String description;
    private SnmpObjectId objectId;
    private int eventCode;
    private String userTag;
    private List<SnmpTrapParameterMapping> parameterMapping;

    public SnmpTrap() {
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>();
    }

    public SnmpTrap(NXCPMessage msg) {
        this.id = msg.getFieldAsInt64(117L);
        this.description = msg.getFieldAsString(27L);
        this.objectId = new SnmpObjectId(msg.getFieldAsUInt32Array(118L));
        this.eventCode = msg.getFieldAsInt32(24L);
        this.userTag = msg.getFieldAsString(298L);
        int count2 = msg.getFieldAsInt32(120L);
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>(count2);
        long base2 = 36864L;
        int i = 0;
        while (i < count2) {
            this.parameterMapping.add(new SnmpTrapParameterMapping(msg, base2));
            ++i;
            base2 += 10L;
        }
    }

    public SnmpTrap(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.description = msg.getFieldAsString(baseId + 1L);
        this.objectId = new SnmpObjectId(msg.getFieldAsUInt32Array(baseId + 2L));
        this.eventCode = msg.getFieldAsInt32(baseId + 3L);
        this.parameterMapping = new ArrayList<SnmpTrapParameterMapping>(0);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(117L, (int)this.id);
        msg.setFieldInt32(24L, this.eventCode);
        msg.setField(27L, this.description);
        msg.setField(298L, this.userTag);
        msg.setFieldInt32(119L, this.objectId.getLength());
        this.objectId.setNXCPVariable(msg, 118L);
        msg.setFieldInt32(120L, this.parameterMapping.size());
        long base2 = 36864L;
        int i = 0;
        while (i < this.parameterMapping.size()) {
            this.parameterMapping.get(i).fillMessage(msg, base2);
            ++i;
            base2 += 10L;
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SnmpObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(SnmpObjectId objectId) {
        this.objectId = objectId;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(int eventCode) {
        this.eventCode = eventCode;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public void setUserTag(String userTag) {
        this.userTag = userTag;
    }

    public List<SnmpTrapParameterMapping> getParameterMapping() {
        return this.parameterMapping;
    }
}

