/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import org.python.core.AbstractArray;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyArray$array___add___exposer;
import org.python.core.PyArray$array___delitem___exposer;
import org.python.core.PyArray$array___delslice___exposer;
import org.python.core.PyArray$array___ge___exposer;
import org.python.core.PyArray$array___getslice___exposer;
import org.python.core.PyArray$array___gt___exposer;
import org.python.core.PyArray$array___hash___exposer;
import org.python.core.PyArray$array___iadd___exposer;
import org.python.core.PyArray$array___imul___exposer;
import org.python.core.PyArray$array___iter___exposer;
import org.python.core.PyArray$array___le___exposer;
import org.python.core.PyArray$array___lt___exposer;
import org.python.core.PyArray$array___mul___exposer;
import org.python.core.PyArray$array___nonzero___exposer;
import org.python.core.PyArray$array___reduce___exposer;
import org.python.core.PyArray$array___setitem___exposer;
import org.python.core.PyArray$array___setslice___exposer;
import org.python.core.PyArray$array_byteswap_exposer;
import org.python.core.PyArray$array_extend_exposer;
import org.python.core.PyArray$array_fromfile_exposer;
import org.python.core.PyArray$array_fromstring_exposer;
import org.python.core.PyArray$array_fromunicode_exposer;
import org.python.core.PyArray$array_index_exposer;
import org.python.core.PyArray$array_pop_exposer;
import org.python.core.PyArray$array_remove_exposer;
import org.python.core.PyArray$array_reverse_exposer;
import org.python.core.PyArray$array_tofile_exposer;
import org.python.core.PyArray$array_tolist_exposer;
import org.python.core.PyArray$array_tostring_exposer;
import org.python.core.PyArray$array_tounicode_exposer;
import org.python.core.PyArray$array_write_exposer;
import org.python.core.PyArray$exposed___new__;
import org.python.core.PyArray$typecode_descriptor;
import org.python.core.PyArrayDerived;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleStringBuffer;
import org.python.core.buffer.SimpleWritableBuffer;
import org.python.core.util.ByteSwapper;
import org.python.core.util.StringUtil;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.gc;

@ExposedType(name="array.array", base=PyObject.class)
public class PyArray
extends PySequence
implements Cloneable,
BufferProtocol,
Traverseproc {
    public static final PyType TYPE;
    private Object data;
    private Class<?> type;
    private String typecode;
    private ArrayDelegate delegate;
    private WeakReference<BaseBuffer> export;

    public PyArray(PyType type) {
        super(type);
    }

    public PyArray(Class<?> type, Object data) {
        this(TYPE);
        this.setup(type, data);
    }

    public PyArray(Class<?> type, PyObject initial) {
        this(TYPE);
        this.type = type;
        this.typecode = PyArray.class2char(type);
        this.data = Array.newInstance(type, 0);
        this.delegate = new ArrayDelegate();
        this.useInitial(initial);
    }

    public PyArray(Class<?> type, int n) {
        this(type, Array.newInstance(type, n));
    }

    public PyArray(PyArray toCopy) {
        this(toCopy.type, toCopy.delegate.copyArray());
        this.typecode = toCopy.typecode;
    }

    private void setup(Class<?> type, Object data) {
        this.type = type;
        this.typecode = PyArray.class2char(type);
        this.data = data == null ? Array.newInstance(type, 0) : data;
        this.delegate = new ArrayDelegate();
    }

    private void useInitial(PyObject initial) {
        if (initial != null) {
            if (initial instanceof PyList) {
                this.fromlist(initial);
            } else if (initial instanceof PyString && !(initial instanceof PyUnicode)) {
                this.fromstring(initial.toString());
            } else if ("u".equals(this.typecode)) {
                if (initial instanceof PyUnicode) {
                    this.extendArray(((PyUnicode)initial).toCodePoints());
                } else {
                    this.extendUnicodeIter(initial);
                }
            } else {
                this.extendInternal(initial);
            }
        }
    }

    @ExposedNew
    static final PyObject array_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        Class<?> type;
        String typecode;
        if (new_.for_type != subtype && keywords.length > 0) {
            int argc = args.length - keywords.length;
            PyObject[] justArgs = new PyObject[argc];
            System.arraycopy(args, 0, justArgs, 0, argc);
            args = justArgs;
        }
        ArgParser ap = new ArgParser("array", args, Py.NoKeywords, new String[]{"typecode", "initializer"}, 1);
        ap.noKeywords();
        PyObject obj = ap.getPyObject(0);
        if (obj instanceof PyString && !(obj instanceof PyUnicode)) {
            if (obj.__len__() != 1) {
                throw Py.TypeError("array() argument 1 must be char, not str");
            }
            typecode = obj.toString();
            type = PyArray.char2class(typecode.charAt(0));
        } else if (obj instanceof PyJavaType) {
            type = ((PyJavaType)obj).getProxyType();
            typecode = type.getName();
        } else {
            throw Py.TypeError("array() argument 1 must be char, not " + obj.getType().fastGetName());
        }
        PyArray self = new_.for_type == subtype ? new PyArray(subtype) : new PyArrayDerived(subtype);
        PyArray.class2char(type);
        self.setup(type, Array.newInstance(type, 0));
        self.typecode = typecode;
        self.useInitial(ap.getPyObject(1, null));
        return self;
    }

    public static PyArray zeros(int n, char typecode) {
        PyArray array = PyArray.zeros(n, PyArray.char2class(typecode));
        array.typecode = Character.toString(typecode);
        return array;
    }

    public static PyArray zeros(int n, Class<?> ctype) {
        PyArray array = new PyArray(ctype, n);
        array.typecode = ctype.getName();
        return array;
    }

    public static PyArray array(PyObject seq, char typecode) {
        PyArray array = PyArray.array(seq, PyArray.char2class(typecode));
        array.typecode = Character.toString(typecode);
        return array;
    }

    public static Class<?> array_class(Class<?> type) {
        return Array.newInstance(type, 0).getClass();
    }

    public static PyArray array(PyObject init, Class<?> ctype) {
        PyArray array = new PyArray(ctype, 0);
        array.typecode = ctype.getName();
        array.extendInternal(init);
        return array;
    }

    final PyObject array___ne__(PyObject o) {
        return this.seq___ne__(o);
    }

    final PyObject array___eq__(PyObject o) {
        return this.seq___eq__(o);
    }

    @Override
    public int hashCode() {
        return this.array___hash__();
    }

    final int array___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    final PyObject array___lt__(PyObject o) {
        return this.seq___lt__(o);
    }

    final PyObject array___le__(PyObject o) {
        return this.seq___le__(o);
    }

    final PyObject array___gt__(PyObject o) {
        return this.seq___gt__(o);
    }

    final PyObject array___ge__(PyObject o) {
        return this.seq___ge__(o);
    }

    final boolean array___contains__(PyObject o) {
        return this.object___contains__(o);
    }

    final void array___delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final void array___setitem__(PyObject o, PyObject def) {
        this.seq___setitem__(o, def);
    }

    final PyObject array___getitem__(PyObject o) {
        PyObject ret = this.seq___finditem__(o);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + o);
        }
        return ret;
    }

    final boolean array___nonzero__() {
        return this.seq___nonzero__();
    }

    public PyObject array___iter__() {
        return this.seq___iter__();
    }

    final PyObject array___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final void array___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final void array___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    @Override
    public PyObject __imul__(PyObject o) {
        return this.array___imul__(o);
    }

    final PyObject array___imul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        this.resizeCheck();
        if (this.delegate.getSize() > 0) {
            int count2 = o.asIndex(Py.OverflowError);
            if (count2 <= 0) {
                this.delegate.clear();
                return this;
            }
            Object copy2 = this.delegate.copyArray();
            this.delegate.ensureCapacity(this.delegate.getSize() * count2);
            for (int i = 1; i < count2; ++i) {
                this.delegate.appendArray(copy2);
            }
        }
        return this;
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.array___mul__(o);
    }

    final PyObject array___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.array___rmul__(o);
    }

    final PyObject array___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __iadd__(PyObject other) {
        return this.array___iadd__(other);
    }

    final PyObject array___iadd__(PyObject other) {
        if (!(other instanceof PyArray)) {
            return null;
        }
        PyArray otherArr = (PyArray)other;
        if (!otherArr.typecode.equals(this.typecode)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + otherArr.type);
        }
        this.resizeCheck();
        this.delegate.appendArray(otherArr.delegate.copyArray());
        return this;
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.array___add__(other);
    }

    final PyObject array___add__(PyObject other) {
        if (!(other instanceof PyArray)) {
            return null;
        }
        PyArray otherArr = (PyArray)other;
        if (!otherArr.typecode.equals(this.typecode)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + otherArr.type);
        }
        PyArray ret = new PyArray(this);
        ret.delegate.appendArray(otherArr.delegate.copyArray());
        return ret;
    }

    @Override
    public int __len__() {
        return this.array___len__();
    }

    final int array___len__() {
        return this.delegate.getSize();
    }

    @Override
    public PyObject __reduce__() {
        return this.array___reduce__();
    }

    final PyObject array___reduce__() {
        PyObject dict = this.__findattr__("__dict__");
        if (dict == null) {
            dict = Py.None;
        }
        if (this.__len__() > 0) {
            return new PyTuple(this.getType(), new PyTuple(Py.newString(this.typecode), Py.newString(this.tostring())), dict);
        }
        return new PyTuple(this.getType(), new PyTuple(Py.newString(this.typecode)), dict);
    }

    @Override
    public String toString() {
        if (this.__len__() == 0) {
            return String.format("array(%s)", this.encodeTypecode(this.typecode));
        }
        String value = "c".equals(this.typecode) ? PyString.encode_UnicodeEscape(this.tostring(), true) : ("u".equals(this.typecode) ? new PyUnicode(this.tounicode()).__repr__().toString() : this.tolist().toString());
        return String.format("array(%s, %s)", this.encodeTypecode(this.typecode), value);
    }

    private String encodeTypecode(String typecode) {
        if (typecode.length() > 1) {
            return typecode;
        }
        return "'" + typecode + "'";
    }

    @Override
    public Object __tojava__(Class<?> c) {
        boolean isArray = c.isArray();
        Class<?> componentType = c.getComponentType();
        if (c == Object.class || isArray && componentType.isAssignableFrom(this.type)) {
            if (this.delegate.capacity != this.delegate.size) {
                return this.delegate.copyArray();
            }
            return this.data;
        }
        if (isArray && componentType == Object.class) {
            Object[] boxed = new Object[this.delegate.size];
            for (int i = 0; i < this.delegate.size; ++i) {
                boxed[i] = Array.get(this.data, i);
            }
            return boxed;
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public final void array_append(PyObject value) {
        this.resizeCheck();
        this.appendUnchecked(value);
    }

    private static int getCodePoint(PyObject obj) {
        PyUnicode u;
        int[] codepoints;
        if (obj instanceof PyUnicode && (codepoints = (u = (PyUnicode)obj).toCodePoints()).length == 1) {
            return codepoints[0];
        }
        throw Py.TypeError("array item must be unicode character");
    }

    private static int getCodePointOrInt(PyObject obj) {
        if (obj instanceof PyUnicode) {
            PyUnicode u = (PyUnicode)obj;
            return u.toCodePoints()[0];
        }
        if (obj instanceof PyString) {
            PyString s = (PyString)obj;
            return s.toString().charAt(0);
        }
        if (obj.__nonzero__()) {
            return obj.asInt();
        }
        return -1;
    }

    public void append(PyObject value) {
        this.resizeCheck();
        this.appendUnchecked(value);
    }

    private final void appendUnchecked(PyObject value) {
        int afterLast = this.delegate.getSize();
        if ("u".equals(this.typecode)) {
            int codepoint = PyArray.getCodePoint(value);
            this.delegate.makeInsertSpace(afterLast);
            Array.setInt(this.data, afterLast, codepoint);
        } else {
            this.delegate.makeInsertSpace(afterLast);
            try {
                this.set(afterLast, value);
            }
            catch (PyException e) {
                this.delegate.setSize(afterLast);
                throw new PyException(e.type, e.value);
            }
        }
    }

    public void array_byteswap() {
        this.byteswap();
    }

    public void byteswap() {
        if (this.getStorageSize() == 0 || "u".equals(this.typecode)) {
            throw Py.RuntimeError("don't know how to byteswap this array type");
        }
        ByteSwapper.swap(this.data);
    }

    public Object clone() {
        return new PyArray(this);
    }

    public static Class<?> char2class(char type) throws PyIgnoreMethodTag {
        switch (type) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'B': {
                return Short.TYPE;
            }
            case 'u': {
                return Integer.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'H': {
                return Integer.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'I': {
                return Long.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'L': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("bad typecode (must be c, b, B, u, h, H, i, I, l, L, f or d)");
    }

    private static String class2char(Class<?> cls) {
        if (cls.equals(Boolean.TYPE)) {
            return "z";
        }
        if (cls.equals(Character.TYPE)) {
            return "c";
        }
        if (cls.equals(Byte.TYPE)) {
            return "b";
        }
        if (cls.equals(Short.TYPE)) {
            return "h";
        }
        if (cls.equals(Integer.TYPE)) {
            return "i";
        }
        if (cls.equals(Long.TYPE)) {
            return "l";
        }
        if (cls.equals(Float.TYPE)) {
            return "f";
        }
        if (cls.equals(Double.TYPE)) {
            return "d";
        }
        return cls.getName();
    }

    public final int array_count(PyObject value) {
        int iCount = 0;
        int len = this.delegate.getSize();
        if ("u".equals(this.typecode)) {
            int codepoint = PyArray.getCodePointOrInt(value);
            for (int i = 0; i < len; ++i) {
                if (codepoint != Array.getInt(this.data, i)) continue;
                ++iCount;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!value.equals(Py.java2py(Array.get(this.data, i)))) continue;
                ++iCount;
            }
        }
        return iCount;
    }

    public PyInteger count(PyObject value) {
        return Py.newInteger(this.array_count(value));
    }

    @Override
    protected void del(int i) {
        this.resizeCheck();
        this.delegate.remove(i);
    }

    @Override
    protected void delRange(int start, int stop) {
        this.resizeCheck();
        this.delegate.remove(start, stop);
    }

    public final void array_extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    public void extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void extendInternal(PyObject iterable) {
        if (iterable instanceof PyUnicode) {
            if ("u".equals(this.typecode)) {
                this.extendUnicodeIter(iterable);
                return;
            }
            if (!"c".equals(this.typecode)) throw Py.TypeError("an integer is required");
            throw Py.TypeError("array item must be char");
        }
        if (!(iterable instanceof PyArray)) {
            this.extendInternalIter(iterable);
            return;
        }
        PyArray source = (PyArray)iterable;
        if (!source.typecode.equals(this.typecode)) {
            throw Py.TypeError("can only extend with array of same kind");
        }
        this.resizeCheck();
        this.delegate.appendArray(source.delegate.copyArray());
    }

    private void extendInternalIter(PyObject iterable) {
        this.resizeCheck();
        if (iterable.__findattr__("__len__") != null) {
            int last = this.delegate.getSize();
            this.delegate.ensureCapacity(last + iterable.__len__());
            for (PyObject item : iterable.asIterable()) {
                this.set(last++, item);
                ++this.delegate.size;
            }
        } else {
            for (PyObject item : iterable.asIterable()) {
                this.appendUnchecked(item);
            }
        }
    }

    private void extendUnicodeIter(PyObject iterable) {
        this.resizeCheck();
        try {
            for (PyObject item : iterable.asIterable()) {
                PyUnicode uitem = (PyUnicode)item;
                for (int codepoint : uitem.toCodePoints()) {
                    int afterLast = this.delegate.getSize();
                    this.delegate.makeInsertSpace(afterLast);
                    Array.setInt(this.data, afterLast, codepoint);
                }
            }
        }
        catch (ClassCastException e) {
            throw Py.TypeError("Type not compatible with array type");
        }
    }

    private void extendArray(int[] items) {
        this.resizeCheck();
        int last = this.delegate.getSize();
        this.delegate.ensureCapacity(last + items.length);
        for (int item : items) {
            Array.set(this.data, last++, item);
            ++this.delegate.size;
        }
    }

    public final void array_fromfile(PyObject f, int count2) {
        this.fromfile(f, count2);
    }

    public void fromfile(PyObject f, int count2) {
        this.resizeCheck();
        if (f instanceof PyFile) {
            PyFile file = (PyFile)f;
            if (!file.getClosed()) {
                int readbytes = count2 * this.getStorageSize();
                String buffer = file.read(readbytes).toString();
                this.fromstring(buffer);
                if (buffer.length() < readbytes) {
                    int readcount = buffer.length() / this.getStorageSize();
                    throw Py.EOFError("not enough items in file. " + Integer.toString(count2) + " requested, " + Integer.toString(readcount) + " actually read");
                }
            }
            return;
        }
        throw Py.TypeError("arg1 must be open file");
    }

    public final void array_fromlist(PyObject obj) {
        this.fromlist(obj);
    }

    public void fromlist(PyObject obj) {
        if (!(obj instanceof PyList)) {
            throw Py.TypeError("arg must be list");
        }
        this.resizeCheck();
        int size = this.delegate.getSize();
        try {
            this.extendInternalIter(obj);
        }
        catch (PyException e) {
            this.delegate.setSize(size);
            throw new PyException(e.type, e.value);
        }
    }

    private int fromStream(InputStream is) throws IOException, EOFException {
        return this.fromStream(is, is.available() / this.getStorageSize());
    }

    private int fromStream(InputStream is, int count2) throws IOException, EOFException {
        int origsize = this.delegate.getSize();
        int n = this.fromStream(is, origsize, origsize + count2, true);
        return n - origsize;
    }

    public int fillFromStream(InputStream is) throws IOException {
        return this.fromStream(is, 0, this.delegate.size, false);
    }

    private int fromStream(InputStream is, int index, int limit, boolean eofIsError) throws IOException, EOFException {
        block32: {
            if (limit > this.delegate.getSize()) {
                this.resizeCheck();
                this.delegate.setSize(limit);
            }
            DataInputStream dis2 = new DataInputStream(is);
            try {
                if (this.type.isPrimitive()) {
                    switch (this.typecode.charAt(0)) {
                        case 'z': {
                            while (index < limit) {
                                Array.setBoolean(this.data, index, dis2.readBoolean());
                                ++index;
                            }
                            break;
                        }
                        case 'b': {
                            while (index < limit) {
                                Array.setByte(this.data, index, dis2.readByte());
                                ++index;
                            }
                            break;
                        }
                        case 'B': {
                            while (index < limit) {
                                Array.setShort(this.data, index, PyArray.unsignedByte(dis2.readByte()));
                                ++index;
                            }
                            break;
                        }
                        case 'u': {
                            while (index < limit) {
                                Array.setInt(this.data, index, dis2.readInt());
                                ++index;
                            }
                            break;
                        }
                        case 'c': {
                            while (index < limit) {
                                Array.setChar(this.data, index, (char)(dis2.readByte() & 0xFF));
                                ++index;
                            }
                            break;
                        }
                        case 'h': {
                            while (index < limit) {
                                Array.setShort(this.data, index, dis2.readShort());
                                ++index;
                            }
                            break;
                        }
                        case 'H': {
                            while (index < limit) {
                                Array.setInt(this.data, index, PyArray.unsignedShort(dis2.readShort()));
                                ++index;
                            }
                            break;
                        }
                        case 'i': {
                            while (index < limit) {
                                Array.setInt(this.data, index, dis2.readInt());
                                ++index;
                            }
                            break;
                        }
                        case 'I': {
                            while (index < limit) {
                                Array.setLong(this.data, index, PyArray.unsignedInt(dis2.readInt()));
                                ++index;
                            }
                            break;
                        }
                        case 'l': {
                            while (index < limit) {
                                Array.setLong(this.data, index, dis2.readLong());
                                ++index;
                            }
                            break;
                        }
                        case 'L': {
                            while (index < limit) {
                                Array.setLong(this.data, index, dis2.readLong());
                                ++index;
                            }
                            break;
                        }
                        case 'f': {
                            while (index < limit) {
                                Array.setFloat(this.data, index, dis2.readFloat());
                                ++index;
                            }
                            break;
                        }
                        case 'd': {
                            while (index < limit) {
                                Array.setDouble(this.data, index, dis2.readDouble());
                                ++index;
                            }
                            break;
                        }
                    }
                }
            }
            catch (EOFException eof) {
                if (!eofIsError) break block32;
                throw eof;
            }
        }
        return index;
    }

    public void fromstring(PyObject input) {
        this.array_fromstring(input);
    }

    public void fromstring(String input) {
        this.frombytesInternal(StringUtil.toBytes(input));
    }

    final void array_fromstring(PyObject input) {
        if (input instanceof BufferProtocol) {
            if (input instanceof PyUnicode) {
                String s = ((PyUnicode)input).encode();
                this.frombytesInternal(StringUtil.toBytes(s));
            } else {
                try (PyBuffer pybuf = ((BufferProtocol)((Object)input)).getBuffer(24);){
                    if (pybuf.getNdim() == 1) {
                        if (pybuf.getStrides()[0] == 1) {
                            this.frombytesInternal(pybuf.getNIOByteBuffer());
                        }
                        byte[] copy2 = new byte[pybuf.getLen()];
                        pybuf.copyTo(copy2, 0);
                        this.frombytesInternal(ByteBuffer.wrap(copy2));
                    }
                    throw Py.ValueError("multi-dimensional buffer not supported");
                }
            }
        } else {
            String fmt = "must be string or read-only buffer, not %s";
            throw Py.TypeError(String.format(fmt, input.getType().fastGetName()));
        }
    }

    private final void frombytesInternal(byte[] bytes) {
        this.frombytesInternal(ByteBuffer.wrap(bytes));
    }

    private final void frombytesInternal(ByteBuffer bytes) {
        int origsize = this.delegate.getSize();
        int itemsize = this.getStorageSize();
        int count2 = bytes.remaining();
        if (count2 % itemsize != 0) {
            throw Py.ValueError("string length not a multiple of item size");
        }
        this.resizeCheck();
        try {
            ByteBufferBackedInputStream is = new ByteBufferBackedInputStream(bytes);
            this.fromStream(is);
        }
        catch (EOFException e) {
            throw Py.EOFError("not enough items in string");
        }
        catch (IOException e) {
            this.delegate.setSize(origsize);
            throw Py.IOError(e);
        }
    }

    public void fromunicode(PyUnicode input) {
        this.array_fromunicode(input);
    }

    final void array_fromunicode(PyObject input) {
        if (!(input instanceof PyUnicode)) {
            throw Py.ValueError("fromunicode argument must be an unicode object");
        }
        if (!"u".equals(this.typecode)) {
            throw Py.ValueError("fromunicode() may only be called on type 'u' arrays");
        }
        this.extend(input);
    }

    @Override
    protected PyObject pyget(int i) {
        if ("u".equals(this.typecode)) {
            return new PyUnicode(Array.getInt(this.data, i));
        }
        return Py.java2py(Array.get(this.data, i));
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public int getItemsize() {
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                return 1;
            }
            if (this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE) {
                return 1;
            }
            if (this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE) {
                return 8;
            }
            if (this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Double.TYPE) {
                return 8;
            }
        }
        return 0;
    }

    public int getStorageSize() {
        if (this.type.isPrimitive()) {
            switch (this.typecode.charAt(0)) {
                case 'z': {
                    return 1;
                }
                case 'b': {
                    return 1;
                }
                case 'B': {
                    return 1;
                }
                case 'u': {
                    return 4;
                }
                case 'c': {
                    return 1;
                }
                case 'h': {
                    return 2;
                }
                case 'H': {
                    return 2;
                }
                case 'i': {
                    return 4;
                }
                case 'I': {
                    return 4;
                }
                case 'l': {
                    return 8;
                }
                case 'L': {
                    return 8;
                }
                case 'f': {
                    return 4;
                }
                case 'd': {
                    return 8;
                }
            }
            throw Py.ValueError("bad typecode (must be c, b, B, u, h, H, i, I, l, L, f or d)");
        }
        return 0;
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyArray.sliceLength(start, stop, step);
        PyArray ret = new PyArray(this.type, n);
        ret.typecode = this.typecode;
        if (step == 1) {
            System.arraycopy(this.data, start, ret.data, 0, n);
            return ret;
        }
        int i = start;
        for (int j = 0; j < n; ++j) {
            Array.set(ret.data, j, Array.get(this.data, i));
            i += step;
        }
        return ret;
    }

    public String getTypecode() {
        return this.typecode;
    }

    public final int array_index(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            return index;
        }
        throw Py.ValueError("array.index(" + value + "): " + value + " not found in array");
    }

    public PyObject index(PyObject value) {
        return Py.newInteger(this.array_index(value));
    }

    private int indexInternal(PyObject value) {
        int len = this.delegate.getSize();
        if ("u".equals(this.typecode)) {
            int codepoint = PyArray.getCodePointOrInt(value);
            for (int i = 0; i < len; ++i) {
                if (codepoint != Array.getInt(this.data, i)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (!value.equals(Py.java2py(Array.get(this.data, i)))) continue;
                return i;
            }
        }
        return -1;
    }

    public final void array_insert(int index, PyObject value) {
        this.insert(index, value);
    }

    public void insert(int index, PyObject value) {
        this.resizeCheck();
        index = this.boundToSequence(index);
        if ("u".equals(this.typecode)) {
            int codepoint = PyArray.getCodePoint(value);
            this.delegate.makeInsertSpace(index);
            Array.setInt(this.data, index, codepoint);
        } else {
            this.delegate.makeInsertSpace(index);
            Array.set(this.data, index, Py.tojava(value, this.type));
        }
    }

    public final PyObject array_pop(int i) {
        PyObject val = this.pop(i);
        if ("u".equals(this.typecode)) {
            return new PyUnicode(val.asInt());
        }
        return val;
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int index) {
        if (this.delegate.getSize() == 0) {
            throw Py.IndexError("pop from empty array");
        }
        if ((index = this.delegator.fixindex(index)) == -1) {
            throw Py.IndexError("pop index out of range");
        }
        this.resizeCheck();
        PyObject ret = Py.java2py(Array.get(this.data, index));
        this.delegate.remove(index);
        return ret;
    }

    public final void array_remove(PyObject value) {
        this.remove(value);
    }

    public void remove(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            this.resizeCheck();
            this.delegate.remove(index);
            return;
        }
        throw Py.ValueError("array.remove(" + value + "): " + value + " not found in array");
    }

    @Override
    protected PyObject repeat(int count2) {
        Object arraycopy = this.delegate.copyArray();
        PyArray ret = new PyArray(this.type, 0);
        ret.typecode = this.typecode;
        for (int i = 0; i < count2; ++i) {
            ret.delegate.appendArray(arraycopy);
        }
        return ret;
    }

    public final void array_reverse() {
        this.reverse();
    }

    public void reverse() {
        Object array = Array.newInstance(this.type, Array.getLength(this.data));
        int lastIndex = this.delegate.getSize() - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            Array.set(array, lastIndex - i, Array.get(this.data, i));
        }
        this.data = array;
    }

    public void set(int i, PyObject value) {
        this.pyset(i, value);
    }

    @Override
    protected void pyset(int i, PyObject value) {
        Object o;
        if ("u".equals(this.typecode)) {
            Array.setInt(this.data, i, PyArray.getCodePoint(value));
            return;
        }
        if (this.type == Byte.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < (long)(this.isSigned() ? 0 : -128)) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > 127L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Short.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < (long)(this.isSigned() ? 0 : Short.MIN_VALUE)) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > 32767L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Integer.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < (long)(this.isSigned() ? 0 : Integer.MIN_VALUE)) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > Integer.MAX_VALUE) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Long.TYPE) {
            if (this.isSigned() && value instanceof PyInteger) {
                if (((PyInteger)value).getValue() < 0) {
                    throw Py.OverflowError("value too small for " + this.type.getName());
                }
            } else if (value instanceof PyLong) {
                ((PyLong)value).getLong(this.isSigned() ? 0L : Long.MIN_VALUE, Long.MAX_VALUE);
            } else {
                try {
                    o = value.__tojava__(Long.TYPE);
                }
                catch (ClassCastException e) {
                    throw Py.TypeError("Type not compatible with array type");
                }
                if (o == Py.NoConversion) {
                    throw Py.TypeError("Type not compatible with array type");
                }
            }
        }
        if ((o = Py.tojava(value, this.type)) == Py.NoConversion) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.set(this.data, i, o);
    }

    public void set(int i, int value) {
        if (!"u".equals(this.typecode) && this.type != Integer.TYPE && this.type != Long.TYPE) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.setInt(this.data, i, value);
    }

    public void set(int i, char value) {
        if (!"c".equals(this.typecode) && this.type != Integer.TYPE && this.type != Long.TYPE) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.setChar(this.data, i, value);
    }

    private boolean isSigned() {
        return this.typecode.length() == 1 && this.typecode.equals(this.typecode.toUpperCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (this.type == Character.TYPE && value instanceof PyString) {
            char[] chars = null;
            if (step != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            chars = value.toString().toCharArray();
            if (start + chars.length != stop) {
                this.resizeCheck();
            }
            this.delegate.replaceSubArray(start, stop, chars, 0, chars.length);
            return;
        } else if (value instanceof PyString && this.type == Byte.TYPE) {
            byte[] chars = ((PyString)value).toBytes();
            if (chars.length != stop - start || step != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(chars, 0, this.data, start, chars.length);
            return;
        } else {
            if (!(value instanceof PyArray)) throw Py.TypeError(String.format("can only assign array (not \"%.200s\") to array slice", value.getType().fastGetName()));
            PyArray array = (PyArray)value;
            if (!array.typecode.equals(this.typecode)) {
                throw Py.TypeError("bad argument type for built-in operation|" + array.typecode + "|" + this.typecode);
            }
            if (step == 1) {
                Object arrayDelegate = array == this ? array.delegate.copyArray() : array.delegate.getArray();
                int len = array.delegate.getSize();
                if (start + len != stop) {
                    this.resizeCheck();
                }
                try {
                    this.delegate.replaceSubArray(start, stop, arrayDelegate, 0, len);
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw Py.TypeError("Slice typecode '" + array.typecode + "' is not compatible with this array (typecode '" + this.typecode + "')");
                }
            } else if (step > 1) {
                int len = array.__len__();
                int i = 0;
                int j = 0;
                while (i < len) {
                    Array.set(this.data, j + start, Array.get(array.data, i));
                    ++i;
                    j += step;
                }
                return;
            } else {
                if (step >= 0) return;
                if (array == this) {
                    array = (PyArray)array.clone();
                }
                int len = array.__len__();
                int i = 0;
                int j = start;
                while (i < len) {
                    Array.set(this.data, j, Array.get(array.data, i));
                    ++i;
                    j += step;
                }
            }
        }
    }

    public final void array_tofile(PyObject f) {
        this.tofile(f);
    }

    public void array_write(PyObject f) {
        this.tofile(f);
    }

    public void tofile(PyObject f) {
        if (!(f instanceof PyFile)) {
            throw Py.TypeError("arg must be open file");
        }
        PyFile file = (PyFile)f;
        file.write(this.tostring());
    }

    public final PyObject array_tolist() {
        return this.tolist();
    }

    public PyObject tolist() {
        PyList list = new PyList();
        int len = this.delegate.getSize();
        if ("u".equals(this.typecode)) {
            for (int i = 0; i < len; ++i) {
                list.append(new PyUnicode(Array.getInt(this.data, i)));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                list.append(Py.java2py(Array.get(this.data, i)));
            }
        }
        return list;
    }

    public int toStream(OutputStream os2) throws IOException {
        DataOutputStream dos = new DataOutputStream(os2);
        switch (this.typecode.charAt(0)) {
            case 'z': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeBoolean(Array.getBoolean(this.data, i));
                }
                break;
            }
            case 'b': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeByte(Array.getByte(this.data, i));
                }
                break;
            }
            case 'B': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeByte(PyArray.signedByte(Array.getShort(this.data, i)));
                }
                break;
            }
            case 'u': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeInt(Array.getInt(this.data, i));
                }
                break;
            }
            case 'c': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeByte((byte)Array.getChar(this.data, i));
                }
                break;
            }
            case 'h': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeShort(Array.getShort(this.data, i));
                }
                break;
            }
            case 'H': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeShort(PyArray.signedShort(Array.getInt(this.data, i)));
                }
                break;
            }
            case 'i': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeInt(Array.getInt(this.data, i));
                }
                break;
            }
            case 'I': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeInt(PyArray.signedInt(Array.getLong(this.data, i)));
                }
                break;
            }
            case 'l': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeLong(Array.getLong(this.data, i));
                }
                break;
            }
            case 'L': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeLong(Array.getLong(this.data, i));
                }
                break;
            }
            case 'f': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeFloat(Array.getFloat(this.data, i));
                }
                break;
            }
            case 'd': {
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeDouble(Array.getDouble(this.data, i));
                }
                break;
            }
        }
        return dos.size();
    }

    private static byte signedByte(short x) {
        if (x >= 128 && x < 256) {
            return (byte)(x - 256);
        }
        if (x >= 0) {
            return (byte)x;
        }
        throw Py.ValueError("invalid storage");
    }

    private static short signedShort(int x) {
        if (x >= 32768 && x < 65536) {
            return (short)(x - 65536);
        }
        if (x >= 0) {
            return (short)x;
        }
        throw Py.ValueError("invalid storage");
    }

    private static int signedInt(long x) {
        if (x >= 0x80000000L && x < 0x100000000L) {
            return (int)(x - 0x100000000L);
        }
        if (x >= 0L) {
            return (int)x;
        }
        throw Py.ValueError("invalid storage");
    }

    private static short unsignedByte(byte x) {
        if (x < 0) {
            return (short)(x + 256);
        }
        return x;
    }

    private static int unsignedShort(short x) {
        if (x < 0) {
            return x + 65536;
        }
        return x;
    }

    private static long unsignedInt(int x) {
        if (x < 0) {
            return (long)x + 0x100000000L;
        }
        return x;
    }

    public final PyObject array_tostring() {
        return new PyString(this.tostring());
    }

    public String tostring() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.toStream(bos);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
        return StringUtil.fromBytes(bos.toByteArray());
    }

    public String tounicode() {
        if (!"u".equals(this.typecode)) {
            throw Py.ValueError("tounicode() may only be called on type 'u' arrays");
        }
        int len = this.delegate.getSize();
        int[] codepoints = new int[len];
        for (int i = 0; i < len; ++i) {
            codepoints[i] = Array.getInt(this.data, i);
        }
        return new String(codepoints, 0, codepoints.length);
    }

    public final PyObject array_tounicode() {
        return new PyUnicode(this.tounicode());
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        BaseBuffer pybuf = this.getExistingBuffer(flags);
        if (pybuf == null) {
            if ("b".equals(this.typecode)) {
                byte[] storage = (byte[])this.data;
                int size = this.delegate.getSize();
                pybuf = new SimpleWritableBuffer(flags, this, storage, 0, size);
            } else if ((flags & 1) == 0) {
                pybuf = new SimpleStringBuffer(flags, (BufferProtocol)this, this.tostring());
            } else {
                throw Py.NotImplementedError("only array('b') can export a writable buffer");
            }
            this.export = new WeakReference<BaseBuffer>(pybuf);
        }
        return pybuf;
    }

    private BaseBuffer getExistingBuffer(int flags) throws PyException {
        BaseBuffer pybuf = null;
        if (this.export != null && (pybuf = (BaseBuffer)this.export.get()) != null) {
            pybuf = pybuf.getBufferAgain(flags);
        }
        return pybuf;
    }

    private void resizeCheck() throws PyException {
        if (this.export != null) {
            PyBuffer pybuf = (PyBuffer)this.export.get();
            if (pybuf != null && !pybuf.isReleased()) {
                throw Py.BufferError("cannot resize an array that is exporting buffers");
            }
            this.export = null;
        }
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        if (this.data == null || !gc.canLinkToPyObject(this.data.getClass(), true)) {
            return 0;
        }
        return gc.traverseByReflection(this.data, visit, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) throws UnsupportedOperationException {
        if (this.data == null || !gc.canLinkToPyObject(this.data.getClass(), true)) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    static {
        PyType.addBuilder(PyArray.class, new PyArray$PyExposer());
        TYPE = PyType.fromClass(PyArray.class);
    }

    private class ByteBufferBackedInputStream
    extends InputStream {
        ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int available() throws IOException {
            return this.buf.remaining();
        }

        @Override
        public int read() {
            return this.buf.hasRemaining() ? this.buf.get() & 0xFF : -1;
        }

        @Override
        public int read(byte[] bytes, int off, int len) {
            int n = this.buf.remaining();
            if (n >= len) {
                this.buf.get(bytes, off, len);
                return len;
            }
            if (n > 0) {
                this.buf.get(bytes, off, n);
                return n;
            }
            return -1;
        }
    }

    private class ArrayDelegate
    extends AbstractArray {
        private ArrayDelegate() {
            super(PyArray.this.data == null ? 0 : Array.getLength(PyArray.this.data));
        }

        @Override
        protected Object getArray() {
            return PyArray.this.data;
        }

        @Override
        protected void setArray(Object array) {
            PyArray.this.data = array;
        }

        @Override
        protected Object createArray(int size) {
            Class<?> baseType = PyArray.this.data.getClass().getComponentType();
            return Array.newInstance(baseType, size);
        }
    }

    public class PyArray$array___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___ne___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyArray$array___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___eq___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyArray$array___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___contains___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___contains___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyArray$array___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array___contains___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyArray)this.self).array___contains__(pyObject));
        }
    }

    public class PyArray$array___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___getitem___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyArray$array___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyArray)this.self).array___getitem__(pyObject);
        }
    }

    public class PyArray$array___rmul___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___rmul___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyArray$array___rmul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array___rmul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyArray)this.self).array___rmul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyArray$array___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array___len___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyArray$array___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyArray)this.self).array___len__());
        }
    }

    public class PyArray$array_append_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_append_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyArray$array_append_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array_append_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array_append(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_count_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyArray$array_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyArray)this.self).array_count(pyObject));
        }
    }

    public class PyArray$array_fromlist_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_fromlist_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyArray$array_fromlist_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array_fromlist_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyArray)this.self).array_fromlist(pyObject);
            return Py.None;
        }
    }

    public class PyArray$array_insert_exposer
    extends PyBuiltinMethodNarrow {
        public PyArray$array_insert_exposer(String string2) {
            super(string2, 3, 3);
            this.doc = "";
        }

        public PyArray$array_insert_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyArray$array_insert_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyArray)this.self).array_insert(Py.py2int(pyObject), pyObject2);
            return Py.None;
        }
    }

    public class PyArray$itemsize_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyArray$itemsize_descriptor() {
            super("itemsize", Integer.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newInteger(((PyArray)pyObject).getItemsize());
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyArray$PyExposer
    extends BaseTypeBuilder {
        public PyArray$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyArray$array___ne___exposer("__ne__"), new PyArray$array___eq___exposer("__eq__"), new PyArray$array___hash___exposer("__hash__"), new PyArray$array___lt___exposer("__lt__"), new PyArray$array___le___exposer("__le__"), new PyArray$array___gt___exposer("__gt__"), new PyArray$array___ge___exposer("__ge__"), new PyArray$array___contains___exposer("__contains__"), new PyArray$array___delitem___exposer("__delitem__"), new PyArray$array___setitem___exposer("__setitem__"), new PyArray$array___getitem___exposer("__getitem__"), new PyArray$array___nonzero___exposer("__nonzero__"), new PyArray$array___iter___exposer("__iter__"), new PyArray$array___getslice___exposer("__getslice__"), new PyArray$array___setslice___exposer("__setslice__"), new PyArray$array___delslice___exposer("__delslice__"), new PyArray$array___imul___exposer("__imul__"), new PyArray$array___mul___exposer("__mul__"), new PyArray$array___rmul___exposer("__rmul__"), new PyArray$array___iadd___exposer("__iadd__"), new PyArray$array___add___exposer("__add__"), new PyArray$array___len___exposer("__len__"), new PyArray$array___reduce___exposer("__reduce__"), new PyArray$array_append_exposer("append"), new PyArray$array_byteswap_exposer("byteswap"), new PyArray$array_count_exposer("count"), new PyArray$array_extend_exposer("extend"), new PyArray$array_fromfile_exposer("fromfile"), new PyArray$array_fromlist_exposer("fromlist"), new PyArray$array_fromstring_exposer("fromstring"), new PyArray$array_fromunicode_exposer("fromunicode"), new PyArray$array_index_exposer("index"), new PyArray$array_insert_exposer("insert"), new PyArray$array_pop_exposer("pop"), new PyArray$array_remove_exposer("remove"), new PyArray$array_reverse_exposer("reverse"), new PyArray$array_tofile_exposer("tofile"), new PyArray$array_write_exposer("write"), new PyArray$array_tolist_exposer("tolist"), new PyArray$array_tostring_exposer("tostring"), new PyArray$array_tounicode_exposer("tounicode")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyArray$typecode_descriptor(), new PyArray$itemsize_descriptor()};
            super("array.array", PyArray.class, PyObject.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new PyArray$exposed___new__());
        }
    }
}

