/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyByteArray;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger$exposed___new__;
import org.python.core.PyInteger$int___add___exposer;
import org.python.core.PyInteger$int___and___exposer;
import org.python.core.PyInteger$int___div___exposer;
import org.python.core.PyInteger$int___floordiv___exposer;
import org.python.core.PyInteger$int___index___exposer;
import org.python.core.PyInteger$int___mul___exposer;
import org.python.core.PyInteger$int___or___exposer;
import org.python.core.PyInteger$int___rdiv___exposer;
import org.python.core.PyInteger$int___rdivmod___exposer;
import org.python.core.PyInteger$int___rmul___exposer;
import org.python.core.PyInteger$int___ror___exposer;
import org.python.core.PyInteger$int___rsub___exposer;
import org.python.core.PyInteger$int___rtruediv___exposer;
import org.python.core.PyInteger$int___trunc___exposer;
import org.python.core.PyInteger$int_hashCode_exposer;
import org.python.core.PyIntegerDerived;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.stringlib.FloatFormatter;
import org.python.core.stringlib.IntegerFormatter;
import org.python.core.stringlib.InternalFormat;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="int", doc="int(x[, base]) -> integer\n\nConvert a string or number to an integer, if possible.  A floating point\nargument will be truncated towards zero (this does not include a string\nrepresentation of a floating point number!)  When converting a string, use\nthe optional base.  It is an error to supply a base when converting a\nnon-string.  If base is zero, the proper base is guessed based on the\nstring content.  If the argument is outside the integer range a\nlong object will be returned instead.")
public class PyInteger
extends PyObject {
    public static final PyType TYPE;
    public static final BigInteger MIN_INT;
    public static final BigInteger MAX_INT;
    @Deprecated
    public static final BigInteger minInt;
    @Deprecated
    public static final BigInteger maxInt;
    private static final String LOOKUP = "0123456789abcdef";
    private final int value;

    public PyInteger(PyType subType, int v) {
        super(subType);
        this.value = v;
    }

    public PyInteger(int v) {
        this(TYPE, v);
    }

    @ExposedNew
    public static PyObject int_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("int", args, keywords, new String[]{"x", "base"}, 0);
        PyObject x = ap.getPyObject(0, null);
        int base2 = ap.getInt(1, -909);
        if (new_.for_type == subtype) {
            if (x == null) {
                return Py.Zero;
            }
            if (base2 == -909) {
                if (x instanceof PyBoolean) {
                    return PyInteger.coerce(x) == 0 ? Py.Zero : Py.One;
                }
                if (x instanceof PyByteArray) {
                    PyString xs = new PyString(x.asString());
                    return PyInteger.asPyInteger(xs);
                }
                return PyInteger.asPyInteger(x);
            }
            if (!(x instanceof PyString)) {
                throw Py.TypeError("int: can't convert non-string with explicit base");
            }
            try {
                return Py.newInteger(((PyString)x).atoi(base2));
            }
            catch (PyException pye) {
                if (pye.match(Py.OverflowError)) {
                    return ((PyString)x).atol(base2);
                }
                throw pye;
            }
        }
        if (x == null) {
            return new PyIntegerDerived(subtype, 0);
        }
        if (base2 == -909) {
            PyObject intOrLong = PyInteger.asPyInteger(x);
            if (intOrLong instanceof PyInteger) {
                return new PyIntegerDerived(subtype, ((PyInteger)intOrLong).getValue());
            }
            throw Py.OverflowError("long int too large to convert to int");
        }
        if (!(x instanceof PyString)) {
            throw Py.TypeError("int: can't convert non-string with explicit base");
        }
        return new PyIntegerDerived(subtype, ((PyString)x).atoi(base2));
    }

    private static PyObject asPyInteger(PyObject x) throws PyException {
        try {
            return x.__int__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.AttributeError)) {
                throw pye;
            }
            try {
                PyObject integral = x.invoke("__trunc__");
                return PyInteger.convertIntegralToInt(integral);
            }
            catch (PyException pye2) {
                if (!pye2.match(Py.AttributeError)) {
                    throw pye2;
                }
                String fmt = "int() argument must be a string or a number, not '%.200s'";
                throw Py.TypeError(String.format(fmt, x));
            }
        }
    }

    private static PyObject convertIntegralToInt(PyObject integral) {
        if (!(integral instanceof PyInteger) && !(integral instanceof PyLong)) {
            PyObject i = integral.invoke("__int__");
            if (!(i instanceof PyInteger) && !(i instanceof PyLong)) {
                throw Py.TypeError(String.format("__trunc__ returned non-Integral (type %.200s)", integral.getType().fastGetName()));
            }
            return i;
        }
        return integral;
    }

    public PyObject getReal() {
        return this.int___int__();
    }

    public PyObject getImag() {
        return Py.newInteger(0);
    }

    public PyObject getNumerator() {
        return this.int___int__();
    }

    public PyObject getDenominator() {
        return Py.newInteger(1);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.int_toString();
    }

    final String int_toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public int hashCode() {
        return this.int_hashCode();
    }

    final int int_hashCode() {
        return this.getValue();
    }

    @Override
    public boolean __nonzero__() {
        return this.int___nonzero__();
    }

    final boolean int___nonzero__() {
        return this.getValue() != 0;
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c == Integer.TYPE || c == Number.class || c == Object.class || c == Integer.class || c == Serializable.class) {
            return new Integer(this.getValue());
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return new Boolean(this.getValue() != 0);
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return new Byte((byte)this.getValue());
        }
        if (c == Short.TYPE || c == Short.class) {
            return new Short((short)this.getValue());
        }
        if (c == Long.TYPE || c == Long.class) {
            return new Long(this.getValue());
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(this.getValue());
        }
        if (c == Double.TYPE || c == Double.class) {
            return new Double(this.getValue());
        }
        return super.__tojava__(c);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.int___cmp__(other);
    }

    final int int___cmp__(PyObject other) {
        if (!PyInteger.canCoerce(other)) {
            return -2;
        }
        int v = PyInteger.coerce(other);
        return this.getValue() < v ? -1 : (this.getValue() > v ? 1 : 0);
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        return this.int___coerce_ex__(other);
    }

    final PyObject int___coerce__(PyObject other) {
        return this.adaptToCoerceTuple(this.int___coerce_ex__(other));
    }

    final Object int___coerce_ex__(PyObject other) {
        return other instanceof PyInteger ? other : Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyInteger;
    }

    private static final int coerce(PyObject other) {
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        return this.int___add__(right);
    }

    final PyObject int___add__(PyObject right) {
        int b;
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int a = this.getValue();
        int x = a + (b = rightv);
        if ((x ^ a) >= 0 || (x ^ b) >= 0) {
            return Py.newInteger(x);
        }
        return new PyLong((long)a + (long)b);
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.int___radd__(left);
    }

    final PyObject int___radd__(PyObject left) {
        return this.__add__(left);
    }

    private static PyObject _sub(int a, int b) {
        int x = a - b;
        if ((x ^ a) >= 0 || (x ^ ~b) >= 0) {
            return Py.newInteger(x);
        }
        return new PyLong((long)a - (long)b);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        return this.int___sub__(right);
    }

    final PyObject int___sub__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return PyInteger._sub(this.getValue(), PyInteger.coerce(right));
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        return this.int___rsub__(left);
    }

    final PyObject int___rsub__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return PyInteger._sub(PyInteger.coerce(left), this.getValue());
    }

    @Override
    public PyObject __mul__(PyObject right) {
        return this.int___mul__(right);
    }

    final PyObject int___mul__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        double x = this.getValue();
        if ((x *= (double)rightv) <= 2.147483647E9 && x >= -2.147483648E9) {
            return Py.newInteger((int)x);
        }
        return this.__long__().__mul__(right);
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        return this.int___rmul__(left);
    }

    final PyObject int___rmul__(PyObject left) {
        return this.__mul__(left);
    }

    private static long divide(long x, long y) {
        if (y == 0L) {
            throw Py.ZeroDivisionError("integer division or modulo by zero");
        }
        long xdivy = x / y;
        long xmody = x - xdivy * y;
        if (xmody != 0L && (y < 0L && xmody > 0L || y > 0L && xmody < 0L)) {
            xmody += y;
            --xdivy;
        }
        return xdivy;
    }

    @Override
    public PyObject __div__(PyObject right) {
        return this.int___div__(right);
    }

    final PyObject int___div__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        if (Options.division_warning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(right)));
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        return this.int___rdiv__(left);
    }

    final PyObject int___rdiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        if (Options.division_warning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.getValue()));
    }

    @Override
    public PyObject __floordiv__(PyObject right) {
        return this.int___floordiv__(right);
    }

    final PyObject int___floordiv__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(right)));
    }

    @Override
    public PyObject __rfloordiv__(PyObject left) {
        return this.int___rfloordiv__(left);
    }

    final PyObject int___rfloordiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.getValue()));
    }

    @Override
    public PyObject __truediv__(PyObject right) {
        return this.int___truediv__(right);
    }

    final PyObject int___truediv__(PyObject right) {
        if (right instanceof PyInteger) {
            return this.__float__().__truediv__(right);
        }
        if (right instanceof PyLong) {
            return this.int___long__().__truediv__(right);
        }
        return null;
    }

    @Override
    public PyObject __rtruediv__(PyObject left) {
        return this.int___rtruediv__(left);
    }

    final PyObject int___rtruediv__(PyObject left) {
        if (left instanceof PyInteger) {
            return left.__float__().__truediv__(this);
        }
        if (left instanceof PyLong) {
            return left.__truediv__(this.int___long__());
        }
        return null;
    }

    private static long modulo(long x, long y, long xdivy) {
        return x - xdivy * y;
    }

    @Override
    public PyObject __mod__(PyObject right) {
        return this.int___mod__(right);
    }

    final PyObject int___mod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int v = this.getValue();
        return Py.newInteger(PyInteger.modulo(v, rightv, PyInteger.divide(v, rightv)));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        return this.int___rmod__(left);
    }

    final PyObject int___rmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        int v = this.getValue();
        return Py.newInteger(PyInteger.modulo(leftv, v, PyInteger.divide(leftv, v)));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        return this.int___divmod__(right);
    }

    final PyObject int___divmod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int v = this.getValue();
        long xdivy = PyInteger.divide(v, rightv);
        return new PyTuple(Py.newInteger(xdivy), Py.newInteger(PyInteger.modulo(v, rightv, xdivy)));
    }

    final PyObject int___rdivmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        int v = this.getValue();
        long xdivy = PyInteger.divide(leftv, v);
        return new PyTuple(Py.newInteger(xdivy), Py.newInteger(PyInteger.modulo(leftv, v, xdivy)));
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.int___pow__(right, modulo);
    }

    final PyObject int___pow__(PyObject right, PyObject modulo) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        PyObject pyObject = modulo = modulo == Py.None ? null : modulo;
        if (modulo != null && !PyInteger.canCoerce(modulo)) {
            return null;
        }
        return PyInteger._pow(this.getValue(), PyInteger.coerce(right), modulo, this, right);
    }

    @Override
    public PyObject __rpow__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return PyInteger._pow(PyInteger.coerce(left), this.getValue(), null, left, this);
    }

    final PyObject int___rpow__(PyObject left) {
        return this.__rpow__(left);
    }

    private static PyObject _pow(int value, int pow, PyObject modulo, PyObject left, PyObject right) {
        int mod2 = 0;
        long tmp = value;
        boolean neg = false;
        if (tmp < 0L) {
            tmp = -tmp;
            neg = (pow & 1) != 0;
        }
        long result2 = 1L;
        if (pow < 0) {
            if (value != 0) {
                return left.__float__().__pow__(right, modulo);
            }
            throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
        }
        if (modulo != null && (mod2 = PyInteger.coerce(modulo)) == 0) {
            throw Py.ValueError("pow(x, y, z) with z==0");
        }
        while (pow > 0) {
            if ((pow & 1) != 0) {
                result2 *= tmp;
                if (mod2 != 0) {
                    result2 %= (long)mod2;
                }
                if (result2 > Integer.MAX_VALUE) {
                    return left.__long__().__pow__(right, modulo);
                }
            }
            if ((pow >>= 1) == 0) break;
            tmp *= tmp;
            if (mod2 != 0) {
                tmp %= (long)mod2;
            }
            if (tmp <= Integer.MAX_VALUE) continue;
            return left.__long__().__pow__(right, modulo);
        }
        if (neg) {
            result2 = -result2;
        }
        if (mod2 != 0) {
            result2 = PyInteger.modulo(result2, mod2, PyInteger.divide(result2, mod2));
        }
        return Py.newInteger(result2);
    }

    @Override
    public PyObject __lshift__(PyObject right) {
        return this.int___lshift__(right);
    }

    final PyObject int___lshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__lshift__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        if (rightv >= 32) {
            return this.__long__().__lshift__(right);
        }
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        int result2 = this.getValue() << rightv;
        if (this.getValue() != result2 >> rightv) {
            return this.__long__().__lshift__(right);
        }
        return Py.newInteger(result2);
    }

    final PyObject int___rlshift__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rlshift__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        if (this.getValue() >= 32) {
            return left.__long__().__lshift__(this);
        }
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        int result2 = leftv << this.getValue();
        if (leftv != result2 >> this.getValue()) {
            return left.__long__().__lshift__(this);
        }
        return Py.newInteger(result2);
    }

    @Override
    public PyObject __rshift__(PyObject right) {
        return this.int___rshift__(right);
    }

    final PyObject int___rshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__rshift__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        if (rightv >= 32) {
            return Py.newInteger(this.getValue() < 0 ? -1 : 0);
        }
        return Py.newInteger(this.getValue() >> rightv);
    }

    final PyObject int___rrshift__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rshift__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        if (this.getValue() >= 32) {
            return Py.newInteger(leftv < 0 ? -1 : 0);
        }
        return Py.newInteger(leftv >> this.getValue());
    }

    @Override
    public PyObject __and__(PyObject right) {
        return this.int___and__(right);
    }

    final PyObject int___and__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__and__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() & rightv);
    }

    final PyObject int___rand__(PyObject left) {
        return this.int___and__(left);
    }

    @Override
    public PyObject __xor__(PyObject right) {
        return this.int___xor__(right);
    }

    final PyObject int___xor__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__xor__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() ^ rightv);
    }

    final PyObject int___rxor__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rxor__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        return Py.newInteger(leftv ^ this.getValue());
    }

    @Override
    public PyObject __or__(PyObject right) {
        return this.int___or__(right);
    }

    final PyObject int___or__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__or__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() | rightv);
    }

    final PyObject int___ror__(PyObject left) {
        return this.int___or__(left);
    }

    @Override
    public PyObject __neg__() {
        return this.int___neg__();
    }

    final PyObject int___neg__() {
        long x = this.getValue();
        long result2 = -x;
        if (x < 0L && result2 == x) {
            return new PyLong(x).__neg__();
        }
        return Py.newInteger(result2);
    }

    @Override
    public PyObject __pos__() {
        return this.int___pos__();
    }

    final PyObject int___pos__() {
        return this.int___int__();
    }

    @Override
    public PyObject __abs__() {
        return this.int___abs__();
    }

    final PyObject int___abs__() {
        if (this.getValue() < 0) {
            return this.int___neg__();
        }
        return this.int___int__();
    }

    @Override
    public PyObject __invert__() {
        return this.int___invert__();
    }

    final PyObject int___invert__() {
        return Py.newInteger(~this.getValue());
    }

    @Override
    public PyObject __int__() {
        return this.int___int__();
    }

    final PyInteger int___int__() {
        return this.getType() == TYPE ? this : Py.newInteger(this.getValue());
    }

    @Override
    public PyObject __long__() {
        return this.int___long__();
    }

    final PyObject int___long__() {
        return new PyLong(this.getValue());
    }

    @Override
    public PyFloat __float__() {
        return this.int___float__();
    }

    final PyFloat int___float__() {
        return new PyFloat((double)this.getValue());
    }

    @Override
    public PyObject __trunc__() {
        return this.int___trunc__();
    }

    final PyObject int___trunc__() {
        return this;
    }

    @Override
    public PyObject conjugate() {
        return this.int_conjugate();
    }

    final PyObject int_conjugate() {
        return this;
    }

    @Override
    public PyComplex __complex__() {
        return new PyComplex(this.getValue(), 0.0);
    }

    @Override
    public PyString __oct__() {
        return this.int___oct__();
    }

    final PyString int___oct__() {
        return this.formatImpl(IntegerFormatter.OCT);
    }

    @Override
    public PyString __hex__() {
        return this.int___hex__();
    }

    final PyString int___hex__() {
        return this.formatImpl(IntegerFormatter.HEX);
    }

    private PyString formatImpl(InternalFormat.Spec spec) {
        IntegerFormatter.Traditional f = new IntegerFormatter.Traditional(spec);
        f.format(this.value);
        return new PyString(f.getResult());
    }

    final PyTuple int___getnewargs__() {
        return new PyTuple(new PyInteger(this.getValue()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.int___getnewargs__();
    }

    @Override
    public PyObject __index__() {
        return this.int___index__();
    }

    final PyObject int___index__() {
        return this;
    }

    @Override
    public int bit_length() {
        return this.int_bit_length();
    }

    final int int_bit_length() {
        int v = this.value;
        if (v < 0) {
            v = -v;
        }
        return BigInteger.valueOf(v).bitLength();
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.int___format__(formatSpec);
    }

    final PyObject int___format__(PyObject formatSpec) {
        InternalFormat.Formatter f;
        InternalFormat.Spec spec = InternalFormat.fromText(formatSpec, "__format__");
        IntegerFormatter fi = PyInteger.prepareFormatter(spec);
        if (fi != null) {
            fi.setBytes(!(formatSpec instanceof PyUnicode));
            fi.format(this.value);
            f = fi;
        } else {
            FloatFormatter ff = PyFloat.prepareFormatter(spec);
            if (ff != null) {
                ff.setBytes(!(formatSpec instanceof PyUnicode));
                ff.format(this.value);
                f = ff;
            } else {
                throw InternalFormat.Formatter.unknownFormat(spec.type, "integer");
            }
        }
        return f.pad().getPyResult();
    }

    static IntegerFormatter prepareFormatter(InternalFormat.Spec spec) throws PyException {
        switch (spec.type) {
            case 'c': {
                if (InternalFormat.Spec.specified(spec.sign)) {
                    throw IntegerFormatter.signNotAllowed("integer", spec.type);
                }
                if (spec.alternate) {
                    throw IntegerFormatter.alternateFormNotAllowed("integer", spec.type);
                }
            }
            case 'X': 
            case 'b': 
            case 'n': 
            case 'o': 
            case 'x': {
                if (spec.grouping) {
                    throw IntegerFormatter.notAllowed("Grouping", "integer", spec.type);
                }
            }
            case 'd': 
            case '\uffff': {
                if (InternalFormat.Spec.specified(spec.precision)) {
                    throw IntegerFormatter.precisionNotAllowed("integer");
                }
                spec = spec.withDefaults(InternalFormat.Spec.NUMERIC);
                return new IntegerFormatter(spec);
            }
        }
        return null;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    @Override
    public int asIndex(PyObject err) {
        return this.getValue();
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    public long asLong(int index) {
        return this.getValue();
    }

    @Override
    public int asInt(int index) {
        return this.getValue();
    }

    @Override
    public int asInt() {
        return this.getValue();
    }

    @Override
    public long asLong() {
        return this.getValue();
    }

    static {
        PyType.addBuilder(PyInteger.class, new PyInteger$PyExposer());
        TYPE = PyType.fromClass(PyInteger.class);
        MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
        MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
        minInt = MIN_INT;
        maxInt = MAX_INT;
    }

    public class PyInteger$int_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int_toString_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyInteger$int_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            String string2 = ((PyInteger)this.self).int_toString();
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyInteger$int___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___nonzero___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__nonzero__() <==> x != 0";
        }

        public PyInteger$int___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__nonzero__() <==> x != 0";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyInteger)this.self).int___nonzero__());
        }
    }

    public class PyInteger$int___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___cmp___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__cmp__(y) <==> cmp(x,y)";
        }

        public PyInteger$int___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__cmp__(y) <==> cmp(x,y)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyInteger)this.self).int___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("int.__cmp__(x,y) requires y to be 'int', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyInteger$int___coerce___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___coerce___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__coerce__(y) <==> coerce(x, y)";
        }

        public PyInteger$int___coerce___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__coerce__(y) <==> coerce(x, y)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___coerce___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyInteger)this.self).int___coerce__(pyObject);
        }
    }

    public class PyInteger$int___radd___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___radd___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__radd__(y) <==> y+x";
        }

        public PyInteger$int___radd___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__radd__(y) <==> y+x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___radd___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___radd__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___sub___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___sub___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__sub__(y) <==> x-y";
        }

        public PyInteger$int___sub___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__sub__(y) <==> x-y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___sub___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___sub__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rfloordiv___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rfloordiv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rfloordiv__(y) <==> y//x";
        }

        public PyInteger$int___rfloordiv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rfloordiv__(y) <==> y//x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___rfloordiv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rfloordiv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___truediv___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___truediv___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__truediv__(y) <==> x/y";
        }

        public PyInteger$int___truediv___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__truediv__(y) <==> x/y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___truediv___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___truediv__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___mod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyInteger$int___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___mod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rmod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rmod__(y) <==> y%x";
        }

        public PyInteger$int___rmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rmod__(y) <==> y%x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___rmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___divmod___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___divmod___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__divmod__(y) <==> divmod(x, y)";
        }

        public PyInteger$int___divmod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__divmod__(y) <==> divmod(x, y)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___divmod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___divmod__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___pow___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___pow___exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "x.__pow__(y[, z]) <==> pow(x, y[, z])";
        }

        public PyInteger$int___pow___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__pow__(y[, z]) <==> pow(x, y[, z])";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___pow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            PyObject pyObject3 = ((PyInteger)this.self).int___pow__(pyObject, pyObject2);
            if (pyObject3 == null) {
                return Py.NotImplemented;
            }
            return pyObject3;
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___pow__(pyObject, null);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rpow___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rpow___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "y.__rpow__(x[, z]) <==> pow(x, y[, z])";
        }

        public PyInteger$int___rpow___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "y.__rpow__(x[, z]) <==> pow(x, y[, z])";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___rpow___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rpow__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___lshift___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___lshift___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__lshift__(y) <==> x<<y";
        }

        public PyInteger$int___lshift___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__lshift__(y) <==> x<<y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___lshift___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___lshift__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rlshift___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rlshift___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rlshift__(y) <==> y<<x";
        }

        public PyInteger$int___rlshift___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rlshift__(y) <==> y<<x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___rlshift___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rlshift__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rshift___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rshift___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rshift__(y) <==> x>>y";
        }

        public PyInteger$int___rshift___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rshift__(y) <==> x>>y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___rshift___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rshift__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rrshift___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rrshift___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rrshift__(y) <==> y>>x";
        }

        public PyInteger$int___rrshift___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rrshift__(y) <==> y>>x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___rrshift___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rrshift__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rand___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rand___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rand__(y) <==> y&x";
        }

        public PyInteger$int___rand___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rand__(y) <==> y&x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___rand___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rand__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___xor___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___xor___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__xor__(y) <==> x^y";
        }

        public PyInteger$int___xor___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__xor__(y) <==> x^y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___xor___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___xor__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___rxor___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___rxor___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__rxor__(y) <==> y^x";
        }

        public PyInteger$int___rxor___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__rxor__(y) <==> y^x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___rxor___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyInteger)this.self).int___rxor__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyInteger$int___neg___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___neg___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__neg__() <==> -x";
        }

        public PyInteger$int___neg___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__neg__() <==> -x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___neg___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___neg__();
        }
    }

    public class PyInteger$int___pos___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___pos___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__pos__() <==> +x";
        }

        public PyInteger$int___pos___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__pos__() <==> +x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___pos___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___pos__();
        }
    }

    public class PyInteger$int___abs___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___abs___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__abs__() <==> abs(x)";
        }

        public PyInteger$int___abs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__abs__() <==> abs(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___abs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___abs__();
        }
    }

    public class PyInteger$int___invert___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___invert___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__invert__() <==> ~x";
        }

        public PyInteger$int___invert___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__invert__() <==> ~x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___invert___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___invert__();
        }
    }

    public class PyInteger$int___int___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___int___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__int__() <==> int(x)";
        }

        public PyInteger$int___int___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__int__() <==> int(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___int___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___int__();
        }
    }

    public class PyInteger$int___long___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___long___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__long__() <==> long(x)";
        }

        public PyInteger$int___long___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__long__() <==> long(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___long___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___long__();
        }
    }

    public class PyInteger$int___float___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___float___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__float__() <==> float(x)";
        }

        public PyInteger$int___float___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__float__() <==> float(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___float___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___float__();
        }
    }

    public class PyInteger$int_conjugate_exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int_conjugate_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Returns self, the complex conjugate of any int.";
        }

        public PyInteger$int_conjugate_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Returns self, the complex conjugate of any int.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int_conjugate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int_conjugate();
        }
    }

    public class PyInteger$int___oct___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___oct___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__oct__() <==> oct(x)";
        }

        public PyInteger$int___oct___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__oct__() <==> oct(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___oct___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___oct__();
        }
    }

    public class PyInteger$int___hex___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___hex___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__hex__() <==> hex(x)";
        }

        public PyInteger$int___hex___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__hex__() <==> hex(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___hex___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___hex__();
        }
    }

    public class PyInteger$int___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___getnewargs___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyInteger$int___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyInteger)this.self).int___getnewargs__();
        }
    }

    public class PyInteger$int_bit_length_exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int_bit_length_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "int.bit_length() -> int\n\nNumber of bits necessary to represent self in binary.\n>>> bin(37)\n'0b100101'\n>>> (37).bit_length()\n6";
        }

        public PyInteger$int_bit_length_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "int.bit_length() -> int\n\nNumber of bits necessary to represent self in binary.\n>>> bin(37)\n'0b100101'\n>>> (37).bit_length()\n6";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int_bit_length_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyInteger)this.self).int_bit_length());
        }
    }

    public class PyInteger$int___format___exposer
    extends PyBuiltinMethodNarrow {
        public PyInteger$int___format___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyInteger$int___format___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyInteger$int___format___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyInteger)this.self).int___format__(pyObject);
        }
    }

    public class PyInteger$real_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyInteger$real_descriptor() {
            super("real", PyObject.class, "the real part of a complex number");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyInteger)pyObject).getReal();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyInteger$imag_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyInteger$imag_descriptor() {
            super("imag", PyObject.class, "the imaginary part of a complex number");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyInteger)pyObject).getImag();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyInteger$numerator_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyInteger$numerator_descriptor() {
            super("numerator", PyObject.class, "the numerator of a rational number in lowest terms");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyInteger)pyObject).getNumerator();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyInteger$denominator_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyInteger$denominator_descriptor() {
            super("denominator", PyObject.class, "the denominator of a rational number in lowest terms");
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyInteger)pyObject).getDenominator();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyInteger$PyExposer
    extends BaseTypeBuilder {
        public PyInteger$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyInteger$int_toString_exposer("__str__"), new PyInteger$int_toString_exposer("__repr__"), new PyInteger$int_hashCode_exposer("__hash__"), new PyInteger$int___nonzero___exposer("__nonzero__"), new PyInteger$int___cmp___exposer("__cmp__"), new PyInteger$int___coerce___exposer("__coerce__"), new PyInteger$int___add___exposer("__add__"), new PyInteger$int___radd___exposer("__radd__"), new PyInteger$int___sub___exposer("__sub__"), new PyInteger$int___rsub___exposer("__rsub__"), new PyInteger$int___mul___exposer("__mul__"), new PyInteger$int___rmul___exposer("__rmul__"), new PyInteger$int___div___exposer("__div__"), new PyInteger$int___rdiv___exposer("__rdiv__"), new PyInteger$int___floordiv___exposer("__floordiv__"), new PyInteger$int___rfloordiv___exposer("__rfloordiv__"), new PyInteger$int___truediv___exposer("__truediv__"), new PyInteger$int___rtruediv___exposer("__rtruediv__"), new PyInteger$int___mod___exposer("__mod__"), new PyInteger$int___rmod___exposer("__rmod__"), new PyInteger$int___divmod___exposer("__divmod__"), new PyInteger$int___rdivmod___exposer("__rdivmod__"), new PyInteger$int___pow___exposer("__pow__"), new PyInteger$int___rpow___exposer("__rpow__"), new PyInteger$int___lshift___exposer("__lshift__"), new PyInteger$int___rlshift___exposer("__rlshift__"), new PyInteger$int___rshift___exposer("__rshift__"), new PyInteger$int___rrshift___exposer("__rrshift__"), new PyInteger$int___and___exposer("__and__"), new PyInteger$int___rand___exposer("__rand__"), new PyInteger$int___xor___exposer("__xor__"), new PyInteger$int___rxor___exposer("__rxor__"), new PyInteger$int___or___exposer("__or__"), new PyInteger$int___ror___exposer("__ror__"), new PyInteger$int___neg___exposer("__neg__"), new PyInteger$int___pos___exposer("__pos__"), new PyInteger$int___abs___exposer("__abs__"), new PyInteger$int___invert___exposer("__invert__"), new PyInteger$int___int___exposer("__int__"), new PyInteger$int___long___exposer("__long__"), new PyInteger$int___float___exposer("__float__"), new PyInteger$int___trunc___exposer("__trunc__"), new PyInteger$int_conjugate_exposer("conjugate"), new PyInteger$int___oct___exposer("__oct__"), new PyInteger$int___hex___exposer("__hex__"), new PyInteger$int___getnewargs___exposer("__getnewargs__"), new PyInteger$int___index___exposer("__index__"), new PyInteger$int_bit_length_exposer("bit_length"), new PyInteger$int___format___exposer("__format__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyInteger$real_descriptor(), new PyInteger$imag_descriptor(), new PyInteger$numerator_descriptor(), new PyInteger$denominator_descriptor()};
            super("int", PyInteger.class, Object.class, true, "int(x[, base]) -> integer\n\nConvert a string or number to an integer, if possible.  A floating point\nargument will be truncated towards zero (this does not include a string\nrepresentation of a floating point number!)  When converting a string, use\nthe optional base.  It is an error to supply a base when converting a\nnon-string.  If base is zero, the proper base is guessed based on the\nstring content.  If the argument is outside the integer range a\nlong object will be returned instead.", pyBuiltinMethodArray, pyDataDescrArray, new PyInteger$exposed___new__());
        }
    }
}

