/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.itertools;
import org.python.modules.itertools.izipLongestDerived;

@ExposedType(name="itertools.izip_longest", base=PyObject.class, doc="izip_longest(iter1 [,iter2 [...]], [fillvalue=None]) --> izip_longest object\n\nReturn an izip_longest object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the longest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  When the shorter iterables\nare exhausted, the fillvalue is substituted in their place.  The fillvalue\ndefaults to None or can be specified by a keyword argument.")
public class izipLongest
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    public static final String izip_longest_doc = "izip_longest(iter1 [,iter2 [...]], [fillvalue=None]) --> izip_longest object\n\nReturn an izip_longest object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the longest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  When the shorter iterables\nare exhausted, the fillvalue is substituted in their place.  The fillvalue\ndefaults to None or can be specified by a keyword argument.";

    public izipLongest() {
    }

    public izipLongest(PyType subType) {
        super(subType);
    }

    public izipLongest(PyObject[] iterables, PyObject fillvalue) {
        this.izipLongest___init__(iterables, fillvalue);
    }

    @ExposedNew
    final void izipLongest___init__(PyObject[] args, String[] kwds) {
        PyObject[] iterables;
        PyObject fillvalue;
        if (kwds.length == 1 && kwds[0] == "fillvalue") {
            fillvalue = args[args.length - 1];
            iterables = new PyObject[args.length - 1];
            System.arraycopy(args, 0, iterables, 0, args.length - 1);
        } else {
            fillvalue = Py.None;
            iterables = args;
        }
        this.izipLongest___init__(iterables, fillvalue);
    }

    private void izipLongest___init__(final PyObject[] iterables, final PyObject fillvalue) {
        final PyObject[] iterators2 = new PyObject[iterables.length];
        final boolean[] exhausted = new boolean[iterables.length];
        for (int i = 0; i < iterables.length; ++i) {
            iterators2[i] = iterables[i].__iter__();
            exhausted[i] = false;
        }
        this.iter = new itertools.ItertoolsIterator(){
            int unexhausted;
            {
                this.unexhausted = iterables.length;
            }

            @Override
            public PyObject __iternext__() {
                PyObject[] item = new PyObject[iterables.length];
                for (int i = 0; i < iterables.length; ++i) {
                    if (exhausted[i]) {
                        item[i] = fillvalue;
                        continue;
                    }
                    PyObject elem = iterators2[i].__iternext__();
                    if (elem == null) {
                        --this.unexhausted;
                        exhausted[i] = true;
                        item[i] = fillvalue;
                        continue;
                    }
                    item[i] = elem;
                }
                if (this.unexhausted == 0) {
                    return null;
                }
                return new PyTuple(item);
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(izipLongest.class, new izipLongest$PyExposer());
        TYPE = PyType.fromClass(izipLongest.class);
    }

    public class izipLongest$izipLongest___init___exposer
    extends PyBuiltinMethod {
        public izipLongest$izipLongest___init___exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public izipLongest$izipLongest___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new izipLongest$izipLongest___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((izipLongest)this.self).izipLongest___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class izipLongest$next_exposer
    extends PyBuiltinMethodNarrow {
        public izipLongest$next_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public izipLongest$next_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new izipLongest$next_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((izipLongest)this.self).next();
        }
    }

    public class izipLongest$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            izipLongest izipLongest2 = new izipLongest(this.for_type);
            if (bl) {
                izipLongest2.izipLongest___init__(pyObjectArray, stringArray);
            }
            return izipLongest2;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new izipLongestDerived(pyType);
        }
    }

    public class izipLongest$PyExposer
    extends BaseTypeBuilder {
        public izipLongest$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new izipLongest$izipLongest___init___exposer("izipLongest___init__"), new izipLongest$next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.izip_longest", izipLongest.class, PyObject.class, true, "izip_longest(iter1 [,iter2 [...]], [fillvalue=None]) --> izip_longest object\n\nReturn an izip_longest object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the longest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  When the shorter iterables\nare exhausted, the fillvalue is substituted in their place.  The fillvalue\ndefaults to None or can be specified by a keyword argument.", pyBuiltinMethodArray, pyDataDescrArray, new izipLongest$exposed___new__());
        }
    }
}

