/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum HistoricalDataType {
    PROCESSED(0),
    RAW(1),
    BOTH(2);

    private int value;
    private static Map<Integer, HistoricalDataType> lookupTable;

    private HistoricalDataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static HistoricalDataType getByValue(int value) {
        HistoricalDataType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning(HistoricalDataType.class.getName(), "Unknown element " + value);
            return PROCESSED;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, HistoricalDataType>();
        for (HistoricalDataType element : HistoricalDataType.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

