/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Date;
import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.DataCollectionTarget;

public class MobileDevice
extends DataCollectionTarget {
    private String deviceId;
    private String vendor;
    private String model;
    private String serialNumber;
    private String osName;
    private String osVersion;
    private String userId;
    private int batteryLevel;
    private Date lastReportTime;

    public MobileDevice(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.deviceId = msg.getFieldAsString(433L);
        this.vendor = msg.getFieldAsString(428L);
        this.model = msg.getFieldAsString(429L);
        this.serialNumber = msg.getFieldAsString(432L);
        this.osName = msg.getFieldAsString(430L);
        this.osVersion = msg.getFieldAsString(431L);
        this.userId = msg.getFieldAsString(35L);
        this.batteryLevel = msg.getFieldAsInt32(427L);
        this.lastReportTime = msg.getFieldAsDate(241L);
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public final String getDeviceId() {
        return this.deviceId;
    }

    public final String getVendor() {
        return this.vendor;
    }

    public final String getModel() {
        return this.model;
    }

    public final String getSerialNumber() {
        return this.serialNumber;
    }

    public final String getOsName() {
        return this.osName;
    }

    public final String getOsVersion() {
        return this.osVersion;
    }

    public final String getUserId() {
        return this.userId;
    }

    public final int getBatteryLevel() {
        return this.batteryLevel;
    }

    @Override
    public String getObjectClassName() {
        return "MobileDevice";
    }

    public final Date getLastReportTime() {
        return this.lastReportTime;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        MobileDevice.addString(strings, this.deviceId);
        MobileDevice.addString(strings, this.model);
        MobileDevice.addString(strings, this.osName);
        MobileDevice.addString(strings, this.osVersion);
        MobileDevice.addString(strings, this.serialNumber);
        MobileDevice.addString(strings, this.userId);
        MobileDevice.addString(strings, this.vendor);
        return strings;
    }
}

