/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.renderers.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementIconConverter
extends ElementConverter {
    private static final Log log = LogFactory.getLog(ElementIconConverter.class);
    private final String iconLocation;

    public ElementIconConverter(String iconLocation) {
        this.iconLocation = iconLocation;
    }

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        this.copyElement(reportConverter, element, printImage);
        printImage.getLineBox().setPadding((Integer)3);
        printImage.setScaleImage(ScaleImageEnum.CLIP);
        printImage.setRenderer(ResourceRenderer.getInstance(this.iconLocation, false));
        return printImage;
    }

    protected Renderable getRenderer(JasperReportsContext jasperReportsContext) {
        try {
            return RenderableUtil.getInstance(jasperReportsContext).getRenderable(this.iconLocation, OnErrorTypeEnum.ERROR);
        }
        catch (JRException e) {
            log.warn((Object)"Error creating component design preview icon", (Throwable)e);
            return null;
        }
    }
}

