/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableRow;
import org.netxms.client.constants.AggregationFunction;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.client.objects.AbstractObject;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.json.JsonTools;
import org.netxms.websvc.json.ResponseContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryTableAdHoc
extends AbstractHandler {
    private Logger log = LoggerFactory.getLogger(AbstractHandler.class);

    protected Object create(JSONObject data) throws Exception {
        long baseObjectId;
        NXCSession session = this.getSession();
        if (!session.isObjectsSynchronized()) {
            session.syncObjects();
        }
        String objectFilter = JsonTools.getStringFromJson((JSONObject)data, (String)"baseObject", null);
        this.log.debug("POST adhoc summaryTable: baseObject = " + objectFilter);
        JSONArray columnFilter = JsonTools.getJsonArrayFromJson((JSONObject)data, (String)"columns", null);
        if (objectFilter == null || objectFilter.isEmpty() || columnFilter == null) {
            this.log.warn("POST adhoc summaryTable: no DciSummaryTableColumn table or no value for BaseObject");
            return this.createErrorResponse(12);
        }
        try {
            baseObjectId = Long.parseLong(objectFilter);
        }
        catch (NumberFormatException ex) {
            AbstractObject obj = session.findObjectByName(objectFilter);
            baseObjectId = obj != null ? obj.getObjectId() : 0L;
        }
        ArrayList<DciSummaryTableColumn> columns = new ArrayList<DciSummaryTableColumn>();
        for (int i = 0; i < columnFilter.length(); ++i) {
            JSONObject obj = columnFilter.getJSONObject(i);
            columns.add(new DciSummaryTableColumn(JsonTools.getStringFromJson((JSONObject)obj, (String)"columnName", (String)""), JsonTools.getStringFromJson((JSONObject)obj, (String)"dciName", (String)""), JsonTools.getBooleanFromJson((JSONObject)obj, (String)"isRegexp", (boolean)false) ? DciSummaryTableColumn.REGEXP_MATCH : 0));
        }
        AggregationFunction agrFunc = (AggregationFunction)JsonTools.getEnumFromJson((JSONObject)data, AggregationFunction.class, (String)"aggregationFunction", null);
        long date = JsonTools.getLongFromJson((JSONObject)data, (String)"startDate", (long)-1L);
        Date startDate = date > 0L ? new Date(date * 1000L) : null;
        date = JsonTools.getLongFromJson((JSONObject)data, (String)"endDate", (long)-1L);
        Date endDate = date > 0L ? new Date(date * 1000L) : null;
        boolean multiInstance = JsonTools.getBooleanFromJson((JSONObject)data, (String)"multiInstance", (boolean)true);
        Table table = session.queryAdHocDciSummaryTable(baseObjectId, columns, agrFunc, startDate, endDate, multiInstance);
        JSONObject root = new JSONObject();
        JSONArray columnList = new JSONArray();
        JSONArray rowList = new JSONArray();
        String[] names = table.getColumnDisplayNames();
        for (int i = 0; i < names.length; ++i) {
            columnList.put((Object)names[i]);
        }
        root.put("columns", (Object)columnList);
        TableRow[] rows = table.getAllRows();
        for (int i = 0; i < rows.length; ++i) {
            JSONArray row = new JSONArray();
            for (int j = 0; j < rows[i].size(); ++j) {
                row.put((Object)rows[i].get(j).getValue());
            }
            rowList.put((Object)row);
        }
        root.put("rows", (Object)rowList);
        return new ResponseContainer("table", (Object)root);
    }
}

