/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.UserAgentNotification;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Activator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.UserAgentNotificationComparator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.UserAgentNotificationFilter;
import org.netxms.ui.eclipse.agentmanager.views.helpers.UserAgentNotificationLabelProvider;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class UserAgentNotificationView
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.UserAgentNotificationView";
    public static final int COL_ID = 0;
    public static final int COL_OBJECTS = 1;
    public static final int COL_MESSAGE = 2;
    public static final int COL_IS_RECALLED = 3;
    public static final int COL_START_TIME = 4;
    public static final int COL_END_TIME = 5;
    private SortableTableViewer viewer;
    private UserAgentNotificationFilter filter;
    private boolean initShowfilter = true;
    private FilterText filterText;
    private Action actionShowFilter;
    private Action actionRefresh;
    private Action actionRecall;
    private NXCSession session;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.session = ConsoleSharedData.getSession();
        this.filterText = new FilterText(parent, 0, null, true);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserAgentNotificationView.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                UserAgentNotificationView.this.enableFilter(false);
                UserAgentNotificationView.this.actionShowFilter.setChecked(false);
            }
        });
        String[] names = new String[]{"ID", "Objects", "Message", "Is recalled", "Start time", "End time"};
        int[] widths = new int[]{80, 300, 300, 80, 100, 100};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new UserAgentNotificationLabelProvider());
        this.viewer.setComparator((ViewerComparator)new UserAgentNotificationComparator());
        this.filter = new UserAgentNotificationFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowfilter = settings.getBoolean("org.netxms.ui.eclipse.agentmanager.views.UserAgentNotificationViewinitShowFilter");
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"UserAgentNotification");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)UserAgentNotificationView.this.viewer, (IDialogSettings)settings, (String)"UserAgentNotification");
                settings.put("org.netxms.ui.eclipse.agentmanager.views.UserAgentNotificationViewinitShowFilter", UserAgentNotificationView.this.initShowfilter);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        if (this.initShowfilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.agentmanager.context.UserAgentNotificationView");
        }
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                UserAgentNotificationView.this.refresh();
            }
        };
        this.actionRecall = new Action("Recall notification"){

            public void run() {
                UserAgentNotificationView.this.recallMessage();
            }
        };
        this.actionShowFilter = new Action("&Show filter"){

            public void run() {
                UserAgentNotificationView.this.enableFilter(UserAgentNotificationView.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowfilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.agentmanager.commands.show_filter");
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void recallMessage() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() >= 1) {
            for (Object o : selection.toList()) {
                final UserAgentNotification msg = (UserAgentNotification)o;
                new ConsoleJob("Recall user agent notification", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        UserAgentNotificationView.this.session.userAgentNotificationRecall(msg.getId());
                    }

                    protected String getErrorMessage() {
                        return "Cannot recall user agent notification";
                    }
                }.start();
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionShowFilter);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionShowFilter);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                UserAgentNotificationView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() >= 1) {
            boolean recallIsActive = true;
            for (Object o : selection.toList()) {
                if (!((UserAgentNotification)o).isRecalled() && ((UserAgentNotification)o).getStartTime().getTime() != 0L) continue;
                recallIsActive = false;
                break;
            }
            if (recallIsActive) {
                manager.add((IAction)this.actionRecall);
            }
        }
    }

    private void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get list of user agent notifications", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List messages = session.getUserAgentNotifications();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        UserAgentNotificationView.this.viewer.setInput((Object)messages);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of user agent notifications";
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void enableFilter(boolean enable) {
        this.initShowfilter = enable;
        this.filterText.setVisible(this.initShowfilter);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.viewer.getTable().getParent().layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    private void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1041: {
                this.refresh();
            }
        }
    }
}

