/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Arrays;
import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;

public class UserAgentNotification {
    private long id;
    private String message;
    private long[] objectList;
    private String objNames;
    private Date startTime;
    private Date endTime;
    private boolean recalled;

    public UserAgentNotification(NXCPMessage response, long base, NXCSession session) {
        this.id = response.getFieldAsInt32(base);
        this.message = response.getFieldAsString(base + 1L);
        this.startTime = response.getFieldAsDate(base + 2L);
        this.endTime = response.getFieldAsDate(base + 3L);
        this.objectList = response.getFieldAsUInt32Array(base + 4L);
        Arrays.sort(this.objectList);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.objectList.length) {
            sb.append(session.findObjectById(this.objectList[i]).getObjectName());
            if (i + 1 < this.objectList.length) {
                sb.append(", ");
            }
            ++i;
        }
        this.objNames = sb.toString();
        this.recalled = response.getFieldAsBoolean(base + 5L);
    }

    public long getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public long[] getObjectList() {
        return this.objectList;
    }

    public String getObjectNamesAsString() {
        return this.objNames;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isRecalled() {
        return this.recalled;
    }
}

