/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dynabeans;

import java.util.Arrays;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.jxpath.JXPathTypeConversionException;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.apache.commons.jxpath.util.ValueUtils;

public class DynaBeanPropertyPointer
extends PropertyPointer {
    private DynaBean dynaBean;
    private String name;
    private String[] names;
    private static final long serialVersionUID = 2094421509141267239L;

    public DynaBeanPropertyPointer(NodePointer parent, DynaBean dynaBean) {
        super(parent);
        this.dynaBean = dynaBean;
    }

    public Object getBaseValue() {
        return this.dynaBean.get(this.getPropertyName());
    }

    public boolean isContainer() {
        return true;
    }

    public int getPropertyCount() {
        return this.getPropertyNames().length;
    }

    public String[] getPropertyNames() {
        if (this.names == null) {
            boolean hasClass;
            DynaClass dynaClass = this.dynaBean.getDynaClass();
            DynaProperty[] properties = dynaClass.getDynaProperties();
            int count = properties.length;
            boolean bl = hasClass = dynaClass.getDynaProperty("class") != null;
            if (hasClass) {
                --count;
            }
            this.names = new String[count];
            int j = 0;
            for (int i = 0; i < properties.length; ++i) {
                String name = properties[i].getName();
                if (hasClass && name.equals("class")) continue;
                this.names[j++] = name;
            }
            Arrays.sort(this.names);
        }
        return this.names;
    }

    public String getPropertyName() {
        if (this.name == null) {
            String[] names = this.getPropertyNames();
            this.name = this.propertyIndex >= 0 && this.propertyIndex < names.length ? names[this.propertyIndex] : "*";
        }
        return this.name;
    }

    public void setPropertyName(String propertyName) {
        this.setPropertyIndex(Integer.MIN_VALUE);
        this.name = propertyName;
    }

    public int getPropertyIndex() {
        if (this.propertyIndex == Integer.MIN_VALUE) {
            String[] names = this.getPropertyNames();
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(this.name)) continue;
                this.propertyIndex = i;
                this.name = null;
                break;
            }
        }
        return super.getPropertyIndex();
    }

    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            super.setPropertyIndex(index);
            this.name = null;
        }
    }

    public Object getImmediateNode() {
        Object value;
        String name = this.getPropertyName();
        if (name.equals("*")) {
            return null;
        }
        if (this.index == Integer.MIN_VALUE) {
            value = ValueUtils.getValue(this.dynaBean.get(name));
        } else if (this.isIndexedProperty()) {
            try {
                value = ValueUtils.getValue(this.dynaBean.get(name, this.index));
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                value = null;
            }
            catch (IllegalArgumentException ex) {
                value = this.dynaBean.get(name);
                value = ValueUtils.getValue(value, this.index);
            }
        } else {
            value = this.dynaBean.get(name);
            if (ValueUtils.isCollection(value)) {
                value = ValueUtils.getValue(value, this.index);
            } else if (this.index != 0) {
                value = null;
            }
        }
        return value;
    }

    protected boolean isActualProperty() {
        DynaClass dynaClass = this.dynaBean.getDynaClass();
        return dynaClass.getDynaProperty(this.getPropertyName()) != null;
    }

    protected boolean isIndexedProperty() {
        DynaClass dynaClass = this.dynaBean.getDynaClass();
        DynaProperty property = dynaClass.getDynaProperty(this.name);
        return property.isIndexed();
    }

    public void setValue(Object value) {
        this.setValue(this.index, value);
    }

    public void remove() {
        if (this.index == Integer.MIN_VALUE) {
            this.dynaBean.set(this.getPropertyName(), null);
        } else if (this.isIndexedProperty()) {
            this.dynaBean.set(this.getPropertyName(), this.index, null);
        } else if (this.isCollection()) {
            Object collection = ValueUtils.remove(this.getBaseValue(), this.index);
            this.dynaBean.set(this.getPropertyName(), collection);
        } else if (this.index == 0) {
            this.dynaBean.set(this.getPropertyName(), null);
        }
    }

    private void setValue(int index, Object value) {
        if (index == Integer.MIN_VALUE) {
            this.dynaBean.set(this.getPropertyName(), this.convert(value, false));
        } else if (this.isIndexedProperty()) {
            this.dynaBean.set(this.getPropertyName(), index, this.convert(value, true));
        } else {
            Object baseValue = this.dynaBean.get(this.getPropertyName());
            ValueUtils.setValue(baseValue, index, value);
        }
    }

    private Object convert(Object value, boolean element) {
        DynaClass dynaClass = this.dynaBean.getDynaClass();
        DynaProperty property = dynaClass.getDynaProperty(this.getPropertyName());
        Class<?> type = property.getType();
        if (element) {
            if (type.isArray()) {
                type = type.getComponentType();
            } else {
                return value;
            }
        }
        try {
            return TypeUtils.convert(value, type);
        }
        catch (Exception ex) {
            String string = value == null ? "null" : value.getClass().getName();
            throw new JXPathTypeConversionException("Cannot convert value of class " + string + " to type " + type, ex);
        }
    }
}

