/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;

public class ObjectPopupDialog
extends PopupDialog {
    private AbstractObject object;
    private Point location;
    private CLabel statusLabel = null;
    private Font boldFont = null;
    private WorkbenchLabelProvider labelProvider;

    public ObjectPopupDialog(Shell parent, AbstractObject object, Point location) {
        super(parent, 540676, true, false, false, false, false, object.getObjectName(), null);
        this.object = object;
        this.location = location != null ? location : Display.getCurrent().getCursorLocation();
        this.labelProvider = new WorkbenchLabelProvider();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ObjectPopupDialog.this.boldFont != null) {
                    ObjectPopupDialog.this.boldFont.dispose();
                }
                ObjectPopupDialog.this.labelProvider.dispose();
            }
        });
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.location;
    }

    protected Control createTitleControl(Composite parent) {
        CLabel title = new CLabel(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)title);
        title.setImage(this.labelProvider.getImage((Object)this.object));
        title.setText(this.object.getObjectName());
        FontData fd = title.getFont().getFontData()[0];
        fd.setStyle(1);
        this.boldFont = new Font((Device)title.getDisplay(), fd);
        title.setFont(this.boldFont);
        return title;
    }

    protected Control createDialogArea(Composite parent) {
        List values;
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.statusLabel = new CLabel(dialogArea, 0);
        this.statusLabel.setText(StatusDisplayInfo.getStatusText((ObjectStatus)this.object.getStatus()).toUpperCase());
        this.statusLabel.setForeground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        this.statusLabel.setFont(this.boldFont);
        StringBuilder sb = new StringBuilder();
        if (this.object instanceof AbstractNode) {
            ObjectPopupDialog.appendText(sb, ((AbstractNode)this.object).getPrimaryIP().getHostAddress());
            ObjectPopupDialog.appendText(sb, ((AbstractNode)this.object).getPlatformName());
            String sd = ((AbstractNode)this.object).getSystemDescription();
            if (sd.length() > 127) {
                sd = String.valueOf(sd.substring(0, 127)) + "...";
            }
            ObjectPopupDialog.appendText(sb, sd);
            ObjectPopupDialog.appendText(sb, ((AbstractNode)this.object).getSnmpSysName());
            ObjectPopupDialog.appendText(sb, ((AbstractNode)this.object).getSnmpSysContact());
        } else if (this.object instanceof Interface) {
            ObjectPopupDialog.appendText(sb, ((Interface)this.object).getDescription());
            ObjectPopupDialog.appendText(sb, ((Interface)this.object).getAlias());
            if (!((Interface)this.object).getMacAddress().isNull()) {
                ObjectPopupDialog.appendText(sb, ((Interface)this.object).getMacAddress().toString());
            }
            ObjectPopupDialog.appendText(sb, String.valueOf(((Interface)this.object).getAdminStateAsText()) + " / " + ((Interface)this.object).getOperStateAsText());
        }
        if (sb.length() > 0) {
            ObjectPopupDialog.createSeparator(dialogArea);
            if (sb.charAt(sb.length() - 1) == '\n') {
                sb.deleteCharAt(sb.length() - 1);
            }
            CLabel infoText = new CLabel(dialogArea, 2);
            infoText.setText(sb.toString());
        }
        if (this.object instanceof DataCollectionTarget && !(values = ((DataCollectionTarget)this.object).getTooltipDciData()).isEmpty()) {
            ObjectPopupDialog.createSeparator(dialogArea);
            Composite group = new Composite(dialogArea, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            StringBuilder leftColumn = new StringBuilder();
            StringBuilder rightColumn = new StringBuilder();
            for (DciValue v : values) {
                if (leftColumn.length() > 0) {
                    leftColumn.append('\n');
                    rightColumn.append('\n');
                }
                leftColumn.append(v.getDescription());
                rightColumn.append(v.getValue());
            }
            new CLabel(group, 2).setText(leftColumn.toString());
            new CLabel(group, 2).setText(rightColumn.toString());
        }
        if (!this.object.getComments().isEmpty()) {
            ObjectPopupDialog.createSeparator(dialogArea);
            new CLabel(dialogArea, 2).setText(this.object.getComments());
        }
        return dialogArea;
    }

    protected List<Control> getForegroundColorExclusions() {
        List e = super.getForegroundColorExclusions();
        e.add(this.statusLabel);
        return e;
    }

    private static void createSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)separator);
    }

    private static void appendText(StringBuilder sb, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        sb.append(text);
        sb.append('\n');
    }
}

