/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.datacollection.ChartConfig;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.datacollection.GraphSettingsChangeListener;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.HistoricalDataChart;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.dialogs.SaveGraphDlg;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class HistoricalGraphView
extends ViewPart
implements GraphSettingsChangeListener {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.HistoryGraph";
    public static final String PREDEFINED_GRAPH_SUBID = "org.netxms.ui.eclipse.charts.predefinedGraph";
    private static final int[] presetUnits;
    private static final int[] presetRanges;
    private static final String[] presetNames;
    private NXCSession session;
    private HistoricalDataChart chart = null;
    private boolean updateInProgress = false;
    private ViewRefreshController refreshController;
    private Composite chartParent = null;
    private GraphSettings settings = new GraphSettings();
    private boolean multipleSourceNodes = false;
    private Action actionRefresh;
    private Action actionAutoRefresh;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action actionLogScale;
    private Action actionStacked;
    private Action actionAreaChart;
    private Action actionTranslucent;
    private Action actionShowLegend;
    private Action actionExtendedLegend;
    private Action actionLegendLeft;
    private Action actionLegendRight;
    private Action actionLegendTop;
    private Action actionLegendBottom;
    private Action actionProperties;
    private Action actionSave;
    private Action actionSaveAs;
    private Action actionSaveAsTemplate;
    private Action[] presetActions;
    private Action actionCopyImage;
    private Action actionSaveAsImage;

    static {
        int[] nArray = new int[12];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        presetUnits = nArray;
        presetRanges = new int[]{10, 30, 1, 2, 4, 12, 1, 2, 5, 7, 31, 365};
        String[] stringArray = new String[12];
        Messages.get();
        stringArray[0] = Messages.HistoricalGraphView_Preset10min;
        Messages.get();
        stringArray[1] = Messages.HistoricalGraphView_Preset30min;
        Messages.get();
        stringArray[2] = Messages.HistoricalGraphView_Preset1hour;
        Messages.get();
        stringArray[3] = Messages.HistoricalGraphView_Preset2hours;
        Messages.get();
        stringArray[4] = Messages.HistoricalGraphView_Preset4hours;
        Messages.get();
        stringArray[5] = Messages.HistoricalGraphView_Preset12hours;
        Messages.get();
        stringArray[6] = Messages.HistoricalGraphView_Preset1day;
        Messages.get();
        stringArray[7] = Messages.HistoricalGraphView_Preset2days;
        Messages.get();
        stringArray[8] = Messages.HistoricalGraphView_Preset5days;
        Messages.get();
        stringArray[9] = Messages.HistoricalGraphView_PresetWeek;
        Messages.get();
        stringArray[10] = Messages.HistoricalGraphView_PresetMonth;
        Messages.get();
        stringArray[11] = Messages.HistoricalGraphView_PresetYear;
        presetNames = stringArray;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.refreshController = new ViewRefreshController((IViewPart)this, -1, new Runnable(){

            @Override
            public void run() {
                if (((Widget)HistoricalGraphView.this.chart).isDisposed()) {
                    return;
                }
                HistoricalGraphView.this.updateChart();
            }
        });
        this.session = ConsoleSharedData.getSession();
        this.settings.setTimeFrom(new Date(System.currentTimeMillis() - this.settings.getTimeRangeMillis()));
        this.settings.setTimeTo(new Date(System.currentTimeMillis()));
        String id = site.getSecondaryId();
        String[] fields = id.split("&");
        if (!fields[0].equals(PREDEFINED_GRAPH_SUBID)) {
            ArrayList<ChartDciConfig> items = new ArrayList<ChartDciConfig>();
            int i = 1;
            while (i < fields.length) {
                String[] subfields = fields[i].split("\\@");
                if (subfields.length != 0) {
                    ChartDciConfig dci;
                    if (Integer.parseInt(subfields[0]) == 1) {
                        try {
                            dci = new ChartDciConfig();
                            dci.type = Integer.parseInt(subfields[0]);
                            dci.nodeId = Long.parseLong(subfields[1], 10);
                            dci.dciId = Long.parseLong(subfields[2], 10);
                            dci.name = URLDecoder.decode(subfields[3], "UTF-8");
                            dci.dciDescription = URLDecoder.decode(subfields[3], "UTF-8");
                            dci.dciName = URLDecoder.decode(subfields[4], "UTF-8");
                            if (subfields.length >= 6) {
                                dci.useRawValues = Boolean.parseBoolean(subfields[5]);
                            }
                            if (subfields.length >= 7) {
                                boolean bl = dci.invertValues = (Integer.parseInt(subfields[6]) & 8) > 0;
                            }
                            if (subfields.length >= 8) {
                                boolean bl = dci.area = Integer.parseInt(subfields[7]) == 1;
                            }
                            if (subfields.length >= 9) {
                                dci.color = "0x" + Integer.toHexString(Integer.parseInt(subfields[8]));
                            }
                            items.add(dci);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    } else if (Integer.parseInt(subfields[0]) == 2) {
                        try {
                            dci = new ChartDciConfig();
                            dci.type = Integer.parseInt(subfields[0]);
                            dci.nodeId = Long.parseLong(subfields[1], 10);
                            dci.dciId = Long.parseLong(subfields[2], 10);
                            dci.name = URLDecoder.decode(subfields[3], "UTF-8");
                            dci.dciName = URLDecoder.decode(subfields[3], "UTF-8");
                            dci.instance = URLDecoder.decode(subfields[4], "UTF-8");
                            dci.column = URLDecoder.decode(subfields[5], "UTF-8");
                            items.add(dci);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            if (items.size() == 1) {
                ChartDciConfig item = (ChartDciConfig)items.get(0);
                AbstractObject object = this.session.findObjectById(item.nodeId);
                if (object != null) {
                    this.setPartName(String.valueOf(object.getObjectName()) + ": " + item.name);
                }
            } else if (items.size() > 1) {
                AbstractObject object;
                long nodeId = ((ChartDciConfig)items.get((int)0)).nodeId;
                for (ChartDciConfig item : items) {
                    if (item.nodeId == nodeId) continue;
                    nodeId = -1L;
                    break;
                }
                if (nodeId != -1L && (object = this.session.findObjectById(nodeId)) != null) {
                    Messages.get();
                    this.setPartName(String.format(Messages.HistoricalGraphView_PartName, object.getObjectName()));
                }
            }
            this.settings.setTitle(this.getPartName());
            this.settings.setDciList(items.toArray(new ChartDciConfig[items.size()]));
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (memento != null) {
            long id;
            try {
                id = Long.parseLong(memento.getTextData());
                if (id == 0L) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Messages.get();
            ConsoleJob job = new ConsoleJob(Messages.HistoricalGraphView_JobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final GraphSettings s = HistoricalGraphView.this.session.getPredefinedGraph(id);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            HistoricalGraphView.this.settings = s;
                            HistoricalGraphView.this.configureGraphFromSettings();
                            HistoricalGraphView.this.settings.addChangeListener((GraphSettingsChangeListener)HistoricalGraphView.this);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return null;
                }
            };
            job.setUser(false);
            job.start();
        }
    }

    public void saveState(IMemento memento) {
        try {
            memento.putTextData(Long.toString(this.settings.getId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initPredefinedGraph(GraphSettings gs) {
        this.settings = new GraphSettings(gs);
        this.settings.addChangeListener((GraphSettingsChangeListener)this);
        this.configureGraphFromSettings();
    }

    private void configureGraphFromSettings() {
        if (this.chart != null) {
            ((Widget)this.chart).dispose();
        }
        this.chart = ChartFactory.createLineChart((Composite)this.chartParent, (int)0);
        this.createPopupMenu();
        this.setPartName(this.settings.getTitle());
        this.chart.setChartTitle(this.settings.getTitle());
        this.chart.setLogScaleEnabled(this.settings.isLogScale());
        this.chart.setGridVisible(this.settings.isShowGrid());
        this.chart.setLegendVisible(this.settings.isShowLegend());
        this.chart.setLegendPosition(this.settings.getLegendPosition());
        this.chart.setExtendedLegend(this.settings.isExtendedLegend());
        this.chart.setStacked(this.settings.isStacked());
        this.chart.setTranslucent(this.settings.isTranslucent());
        this.chart.setLineWidth(this.settings.getLineWidth());
        this.chart.setUseMultipliers(this.settings.isUseMultipliers());
        if (!this.settings.isAutoScale()) {
            this.chart.setYAxisRange(this.settings.getMinYScaleValue(), this.settings.getMaxYScaleValue());
        } else {
            this.chart.modifyYBase(this.settings.modifyYBase());
        }
        ArrayList<GraphItemStyle> styles = new ArrayList<GraphItemStyle>(this.settings.getDciList().length);
        int index = 0;
        int nodeId = 0;
        ChartDciConfig[] chartDciConfigArray = this.settings.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            nodeId = (int)((long)nodeId | dci.nodeId);
            String name = this.settings.isShowHostNames() ? String.valueOf(this.session.getObjectName(dci.nodeId)) + " - " + dci.getName() : dci.getName();
            this.chart.addParameter(new GraphItem(dci.nodeId, dci.dciId, 0, DataType.INT32, Long.toString(dci.dciId), name, dci.getDisplayFormat()));
            int color = dci.getColorAsInt();
            if (color == -1) {
                color = ChartColor.getDefaultColor((int)index).getRGB();
            }
            styles.add(new GraphItemStyle(this.getDisplayType(dci), color, 2, dci.invertValues ? 8 : 0));
            ++index;
            ++n2;
        }
        if (index > 0) {
            this.multipleSourceNodes = (long)nodeId != this.settings.getDciList()[0].nodeId;
        }
        this.chart.setItemStyles(styles);
        if (this.settings.getTimeFrameType() == 1) {
            this.settings.setTimeFrom(new Date(System.currentTimeMillis() - this.settings.getTimeRangeMillis()));
            this.settings.setTimeTo(new Date(System.currentTimeMillis()));
        }
        this.getDataFromServer();
        this.actionAutoRefresh.setChecked(this.settings.isAutoRefresh());
        this.refreshMenuSelection();
        this.refreshController.setInterval(this.settings.isAutoRefresh() ? this.settings.getRefreshRate() : -1);
    }

    private int getDisplayType(ChartDciConfig dci) {
        int type = dci.getDisplayType();
        switch (type) {
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return this.settings.isArea() ? 1 : 0;
    }

    public void createPartControl(Composite parent) {
        this.chartParent = parent;
        this.createActions();
        this.contributeToActionBars();
        this.configureGraphFromSettings();
        this.settings.addChangeListener((GraphSettingsChangeListener)this);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                HistoricalGraphView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.chart);
        ((Control)this.chart).setMenu(menu);
        Control[] controlArray = ((Composite)this.chart).getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ch = controlArray[n2];
            ch.setMenu(menu);
            ++n2;
        }
    }

    private void getDataFromServer() {
        final ChartDciConfig[] dciList = this.settings.getDciList();
        if (dciList.length == 0) {
            this.updateInProgress = false;
            return;
        }
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.HistoricalGraphView_JobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", "org.netxms.ui.eclipse.perfview"){
            private ChartDciConfig currentItem;

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(this.getName(), dciList.length);
                final DciData[] data = new DciData[dciList.length];
                Threshold[][] thresholds = new Threshold[dciList.length][];
                int i = 0;
                while (i < dciList.length) {
                    this.currentItem = dciList[i];
                    if (this.currentItem.type == 1) {
                        data[i] = HistoricalGraphView.this.session.getCollectedData(this.currentItem.nodeId, this.currentItem.dciId, HistoricalGraphView.this.settings.getTimeFrom(), HistoricalGraphView.this.settings.getTimeTo(), 0, this.currentItem.useRawValues ? HistoricalDataType.RAW : HistoricalDataType.PROCESSED);
                        thresholds[i] = HistoricalGraphView.this.session.getThresholds(this.currentItem.nodeId, this.currentItem.dciId);
                    } else {
                        data[i] = HistoricalGraphView.this.session.getCollectedTableData(this.currentItem.nodeId, this.currentItem.dciId, this.currentItem.instance, this.currentItem.column, HistoricalGraphView.this.settings.getTimeFrom(), HistoricalGraphView.this.settings.getTimeTo(), 0);
                        thresholds[i] = null;
                    }
                    monitor.worked(1);
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!((Widget)HistoricalGraphView.this.chart).isDisposed()) {
                            HistoricalGraphView.this.chart.setTimeRange(HistoricalGraphView.this.settings.getTimeFrom(), HistoricalGraphView.this.settings.getTimeTo());
                            HistoricalGraphView.this.setChartData(data);
                            HistoricalGraphView.this.chart.clearErrors();
                        }
                        HistoricalGraphView.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.HistoricalGraphView_JobError, HistoricalGraphView.this.session.getObjectName(this.currentItem.nodeId), this.currentItem.name);
            }

            protected void jobFailureHandler() {
                HistoricalGraphView.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        HistoricalGraphView.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setFocus() {
        ((Composite)this.chart).setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                HistoricalGraphView.this.updateChart();
            }
        };
        Messages.get();
        this.actionProperties = new Action(Messages.HistoricalGraphView_Properties){

            public void run() {
                PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)HistoricalGraphView.this.getSite().getShell(), null, (Object)HistoricalGraphView.this.settings);
                if (dlg != null) {
                    dlg.open();
                    HistoricalGraphView.this.configureGraphFromSettings();
                    HistoricalGraphView.this.refreshMenuSelection();
                }
            }
        };
        Messages.get();
        this.actionAutoRefresh = new Action(Messages.HistoricalGraphView_Autorefresh){

            public void run() {
                HistoricalGraphView.this.settings.setAutoRefresh(!HistoricalGraphView.this.settings.isAutoRefresh());
                this.setChecked(HistoricalGraphView.this.settings.isAutoRefresh());
                HistoricalGraphView.this.refreshController.setInterval(HistoricalGraphView.this.settings.isAutoRefresh() ? HistoricalGraphView.this.settings.getRefreshRate() : -1);
            }
        };
        this.actionAutoRefresh.setChecked(this.settings.isAutoRefresh());
        Messages.get();
        this.actionLogScale = new Action(Messages.HistoricalGraphView_LogScale){

            public void run() {
                try {
                    HistoricalGraphView.this.chart.setLogScaleEnabled(!HistoricalGraphView.this.settings.isLogScale());
                    HistoricalGraphView.this.settings.setLogScale(!HistoricalGraphView.this.settings.isLogScale());
                }
                catch (IllegalStateException e) {
                    Shell shell = HistoricalGraphView.this.getSite().getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.HistoricalGraphView_Error, (String)String.format(Messages.HistoricalGraphView_LogScaleSwitchError, e.getLocalizedMessage()));
                    Activator.logError("Cannot change log scale mode", e);
                }
                this.setChecked(HistoricalGraphView.this.settings.isLogScale());
            }
        };
        this.actionLogScale.setChecked(this.settings.isLogScale());
        Messages.get();
        this.actionZoomIn = new Action(Messages.HistoricalGraphView_ZoomIn){

            public void run() {
                HistoricalGraphView.this.chart.zoomIn();
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        Messages.get();
        this.actionZoomOut = new Action(Messages.HistoricalGraphView_ZoomOut){

            public void run() {
                HistoricalGraphView.this.chart.zoomOut();
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
        HistoricalChartOwner chartOwner = new HistoricalChartOwner(){

            @Override
            public HistoricalDataChart getChart() {
                return HistoricalGraphView.this.chart;
            }
        };
        this.actionAdjustX = HistoricalGraphView.createAction(ChartActionType.ADJUST_X, chartOwner);
        this.actionAdjustY = HistoricalGraphView.createAction(ChartActionType.ADJUST_Y, chartOwner);
        this.actionAdjustBoth = HistoricalGraphView.createAction(ChartActionType.ADJUST_BOTH, chartOwner);
        Messages.get();
        this.actionShowLegend = new Action(Messages.HistoricalGraphView_ShowLegend){

            public void run() {
                HistoricalGraphView.this.settings.setShowLegend(HistoricalGraphView.this.actionShowLegend.isChecked());
                HistoricalGraphView.this.chart.setLegendVisible(HistoricalGraphView.this.settings.isShowLegend());
            }
        };
        this.actionShowLegend.setChecked(this.settings.isShowLegend());
        Messages.get();
        this.actionExtendedLegend = new Action(Messages.HistoricalGraphView_ExtendedLegend){

            public void run() {
                HistoricalGraphView.this.settings.setExtendedLegend(HistoricalGraphView.this.actionExtendedLegend.isChecked());
                HistoricalGraphView.this.chart.setExtendedLegend(HistoricalGraphView.this.settings.isExtendedLegend());
            }
        };
        this.actionExtendedLegend.setChecked(this.settings.isExtendedLegend());
        Messages.get();
        this.actionLegendLeft = new Action(Messages.HistoricalGraphView_PlaceOnLeft, 8){

            public void run() {
                HistoricalGraphView.this.settings.setLegendPosition(1);
                HistoricalGraphView.this.chart.setLegendPosition(HistoricalGraphView.this.settings.getLegendPosition());
            }
        };
        this.actionLegendLeft.setChecked(this.settings.getLegendPosition() == 1);
        Messages.get();
        this.actionLegendRight = new Action(Messages.HistoricalGraphView_PlaceOnRight, 8){

            public void run() {
                HistoricalGraphView.this.settings.setLegendPosition(2);
                HistoricalGraphView.this.chart.setLegendPosition(HistoricalGraphView.this.settings.getLegendPosition());
            }
        };
        this.actionLegendRight.setChecked(this.settings.getLegendPosition() == 2);
        Messages.get();
        this.actionLegendTop = new Action(Messages.HistoricalGraphView_PlaceOnTop, 8){

            public void run() {
                HistoricalGraphView.this.settings.setLegendPosition(4);
                HistoricalGraphView.this.chart.setLegendPosition(HistoricalGraphView.this.settings.getLegendPosition());
            }
        };
        this.actionLegendTop.setChecked(this.settings.getLegendPosition() == 4);
        Messages.get();
        this.actionLegendBottom = new Action(Messages.HistoricalGraphView_PlaceOnBottom, 8){

            public void run() {
                HistoricalGraphView.this.settings.setLegendPosition(8);
                HistoricalGraphView.this.chart.setLegendPosition(HistoricalGraphView.this.settings.getLegendPosition());
            }
        };
        this.actionLegendBottom.setChecked(this.settings.getLegendPosition() == 8);
        this.actionSave = new Action("Save", SharedIcons.SAVE){

            public void run() {
                if (HistoricalGraphView.this.settings.getId() == 0L) {
                    String initalName = HistoricalGraphView.this.settings.getName().compareTo("noname") == 0 ? HistoricalGraphView.this.settings.getTitle() : HistoricalGraphView.this.settings.getName();
                    HistoricalGraphView.this.saveGraph(initalName, null, false, false, true);
                } else {
                    HistoricalGraphView.this.saveGraph(HistoricalGraphView.this.settings.getName(), null, false, false, false);
                }
            }
        };
        this.actionSaveAs = new Action("Save as...", SharedIcons.SAVE_AS){

            public void run() {
                String initalName = HistoricalGraphView.this.settings.getName().compareTo("noname") == 0 ? HistoricalGraphView.this.settings.getTitle() : HistoricalGraphView.this.settings.getName();
                HistoricalGraphView.this.saveGraph(initalName, null, false, false, true);
            }
        };
        this.actionSaveAsTemplate = new Action("Save as template"){

            public void run() {
                String initalName = HistoricalGraphView.this.settings.getName().compareTo("noname") == 0 ? HistoricalGraphView.this.settings.getTitle() : HistoricalGraphView.this.settings.getName();
                HistoricalGraphView.this.saveGraph(initalName, null, false, true, true);
            }
        };
        Messages.get();
        this.actionStacked = new Action(Messages.HistoricalGraphView_Stacked, 2){

            public void run() {
                HistoricalGraphView.this.settings.setStacked(HistoricalGraphView.this.actionStacked.isChecked());
                HistoricalGraphView.this.configureGraphFromSettings();
            }
        };
        this.actionStacked.setChecked(this.settings.isStacked());
        Messages.get();
        this.actionTranslucent = new Action(Messages.HistoricalGraphView_Translucent, 2){

            public void run() {
                HistoricalGraphView.this.settings.setTranslucent(HistoricalGraphView.this.actionTranslucent.isChecked());
                HistoricalGraphView.this.configureGraphFromSettings();
            }
        };
        this.actionTranslucent.setChecked(this.settings.isTranslucent());
        this.actionAreaChart = new Action("Area chart", 2){

            public void run() {
                HistoricalGraphView.this.settings.setArea(HistoricalGraphView.this.actionAreaChart.isChecked());
                HistoricalGraphView.this.configureGraphFromSettings();
            }
        };
        this.actionAreaChart.setChecked(this.settings.isArea());
        this.presetActions = HistoricalGraphView.createPresetActions(new PresetHandler(){

            @Override
            public void onPresetSelected(int units, int range) {
                HistoricalGraphView.this.settings.setTimeUnits(units);
                HistoricalGraphView.this.settings.setTimeRange(range);
                HistoricalGraphView.this.updateChart();
            }
        });
        if (!System.getProperty("os.name").toLowerCase().contains("linux")) {
            Messages.get();
            this.actionCopyImage = new Action(Messages.HistoricalGraphView_CopyToClipboard, SharedIcons.COPY){

                public void run() {
                    Image image = HistoricalGraphView.this.chart.takeSnapshot();
                    ImageTransfer imageTransfer = ImageTransfer.getInstance();
                    Clipboard clipboard = new Clipboard(HistoricalGraphView.this.getSite().getShell().getDisplay());
                    clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{imageTransfer});
                }
            };
        }
        this.actionSaveAsImage = new Action("Save as image...", SharedIcons.SAVE_AS_IMAGE){

            public void run() {
                HistoricalGraphView.this.saveAsImage();
            }
        };
    }

    protected void refreshMenuSelection() {
        this.actionAutoRefresh.setChecked(this.settings.isAutoRefresh());
        this.actionLogScale.setChecked(this.settings.isLogScale());
        this.actionShowLegend.setChecked(this.settings.isShowLegend());
        this.actionExtendedLegend.setChecked(this.settings.isExtendedLegend());
        this.actionStacked.setChecked(this.settings.isStacked());
        this.actionTranslucent.setChecked(this.settings.isTranslucent());
        this.actionAreaChart.setChecked(this.settings.isArea());
        this.actionLegendLeft.setChecked(this.settings.getLegendPosition() == 1);
        this.actionLegendRight.setChecked(this.settings.getLegendPosition() == 2);
        this.actionLegendTop.setChecked(this.settings.getLegendPosition() == 4);
        this.actionLegendBottom.setChecked(this.settings.getLegendPosition() == 8);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        Messages.get();
        MenuManager presets = new MenuManager(Messages.HistoricalGraphView_Presets);
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        Messages.get();
        MenuManager legend = new MenuManager(Messages.HistoricalGraphView_Legend);
        legend.add((IAction)this.actionShowLegend);
        legend.add((IAction)this.actionExtendedLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAreaChart);
        manager.add((IAction)this.actionStacked);
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionTranslucent);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionSaveAsTemplate);
        manager.add((IAction)this.actionProperties);
    }

    private void fillContextMenu(IMenuManager manager) {
        Messages.get();
        MenuManager presets = new MenuManager(Messages.HistoricalGraphView_Presets);
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        Messages.get();
        MenuManager legend = new MenuManager(Messages.HistoricalGraphView_Legend);
        legend.add((IAction)this.actionShowLegend);
        legend.add((IAction)this.actionExtendedLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAreaChart);
        manager.add((IAction)this.actionStacked);
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionTranslucent);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperties);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        if (this.actionCopyImage != null) {
            manager.add((IAction)this.actionCopyImage);
        }
        manager.add((IAction)this.actionSaveAsImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void setChartData(DciData[] data) {
        int i = 0;
        while (i < data.length) {
            this.chart.updateParameter(i, data[i], false);
            ++i;
        }
        this.chart.refresh();
    }

    private void updateChart() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        this.settings.setTimeFrom(new Date(System.currentTimeMillis() - this.settings.getTimeRangeMillis()));
        this.settings.setTimeTo(new Date(System.currentTimeMillis()));
        this.getDataFromServer();
    }

    private void saveAsImage() {
        Image image = this.chart.takeSnapshot();
        FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
        fd.setText("Save graph as image");
        String[] filterExtensions = new String[]{"*.*"};
        fd.setFilterExtensions(filterExtensions);
        String[] filterNames = new String[]{".png"};
        fd.setFilterNames(filterNames);
        fd.setFileName("graph.png");
        String selected = fd.open();
        if (selected == null) {
            return;
        }
        ImageLoader saver = new ImageLoader();
        saver.data = new ImageData[]{image.getImageData()};
        saver.save(selected, 5);
        image.dispose();
    }

    public void dispose() {
        this.refreshController.dispose();
        super.dispose();
    }

    public void onGraphSettingsChange(ChartConfig settings) {
        if (this.settings == settings) {
            this.configureGraphFromSettings();
        }
    }

    private void saveGraph(String graphName, String errorMessage, final boolean canBeOverwritten, final boolean asTemplate, boolean showNameDialog) {
        GraphSettings gs;
        SaveGraphDlg dlg;
        if (asTemplate && this.multipleSourceNodes) {
            String templateError = "More than one node is used for template creation.\nThis may cause undefined behaviour.";
            errorMessage = errorMessage == null ? templateError : String.valueOf(errorMessage) + "\n\n" + templateError;
        }
        int result = 0;
        GraphSettings tamplateGs = null;
        final long oldGraphId = this.settings.getId();
        if (asTemplate) {
            tamplateGs = new GraphSettings(0L, (long)this.session.getUserId(), 0, new ArrayList(0));
            dlg = new SaveGraphDlg(this.getSite().getShell(), graphName, errorMessage, canBeOverwritten);
            result = dlg.open();
            if (result == 1) {
                return;
            }
            tamplateGs.setName(dlg.getName());
            tamplateGs.setConfig((ChartConfig)this.settings);
            tamplateGs.setFlags(1);
        } else if (showNameDialog) {
            dlg = new SaveGraphDlg(this.getSite().getShell(), graphName, errorMessage, canBeOverwritten);
            result = dlg.open();
            if (result == 1) {
                return;
            }
            this.settings.setName(dlg.getName());
            if (!canBeOverwritten) {
                this.settings.setId(0L);
            }
        } else {
            this.settings.setName(graphName);
        }
        GraphSettings graphSettings = gs = asTemplate ? tamplateGs : this.settings;
        if (result == 101) {
            Messages.get();
            new ConsoleJob(Messages.HistoricalGraphView_SaveSettings, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long id = HistoricalGraphView.this.session.saveGraph(gs, canBeOverwritten);
                    if (!asTemplate) {
                        HistoricalGraphView.this.settings.setId(id);
                    }
                }

                protected String getErrorMessage() {
                    HistoricalGraphView.this.settings.setId(oldGraphId);
                    Messages.get();
                    return Messages.HistoricalGraphView_SaveSettingsError;
                }
            }.start();
        } else {
            Messages.get();
            new ConsoleJob(Messages.HistoricalGraphView_SaveSettings, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    try {
                        long id = HistoricalGraphView.this.session.saveGraph(gs, canBeOverwritten);
                        if (!asTemplate) {
                            HistoricalGraphView.this.settings.setId(id);
                        }
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 107) {
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    HistoricalGraphView.this.settings.setId(oldGraphId);
                                    HistoricalGraphView historicalGraphView = HistoricalGraphView.this;
                                    String string = gs.getName();
                                    Messages.get();
                                    historicalGraphView.saveGraph(string, Messages.HistoricalGraphView_NameAlreadyExist, true, asTemplate, true);
                                }
                            });
                        }
                        if (e.getErrorCode() == 2) {
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    HistoricalGraphView.this.settings.setId(oldGraphId);
                                    HistoricalGraphView historicalGraphView = HistoricalGraphView.this;
                                    String string = gs.getName();
                                    Messages.get();
                                    historicalGraphView.saveGraph(string, Messages.HistoricalGraphView_NameAlreadyExistNoOverwrite, false, asTemplate, true);
                                }
                            });
                        }
                        HistoricalGraphView.this.settings.setId(oldGraphId);
                        throw e;
                    }
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.HistoricalGraphView_SaveError;
                }
            }.start();
        }
        this.updateChart();
    }

    public static Action[] createPresetActions(final PresetHandler handler) {
        Action[] actions = new Action[presetRanges.length];
        int i = 0;
        while (i < presetRanges.length) {
            final Integer presetIndex = i;
            Messages.get();
            actions[i] = new Action(String.format(Messages.HistoricalGraphView_Last, presetNames[i])){

                public void run() {
                    handler.onPresetSelected(presetUnits[presetIndex], presetRanges[presetIndex]);
                }
            };
            ++i;
        }
        return actions;
    }

    public static Action createAction(ChartActionType type, final HistoricalChartOwner chartOwner) {
        Action action = null;
        switch (type) {
            case ADJUST_BOTH: {
                action = new Action(){

                    public void run() {
                        chartOwner.getChart().adjustXAxis(false);
                        chartOwner.getChart().adjustYAxis(true);
                    }
                };
                Messages.get();
                action.setText(Messages.HistoricalGraphView_Adjust);
                action.setImageDescriptor(Activator.getImageDescriptor("icons/adjust.png"));
                break;
            }
            case ADJUST_X: {
                action = new Action(){

                    public void run() {
                        chartOwner.getChart().adjustXAxis(true);
                    }
                };
                Messages.get();
                action.setText(Messages.HistoricalGraphView_AdjustX);
                action.setImageDescriptor(Activator.getImageDescriptor("icons/adjust_x.png"));
                break;
            }
            case ADJUST_Y: {
                action = new Action(){

                    public void run() {
                        chartOwner.getChart().adjustYAxis(true);
                    }
                };
                Messages.get();
                action.setText(Messages.HistoricalGraphView_AdjustY);
                action.setImageDescriptor(Activator.getImageDescriptor("icons/adjust_y.png"));
            }
        }
        return action;
    }

    public static enum ChartActionType {
        ADJUST_X,
        ADJUST_Y,
        ADJUST_BOTH;

    }

    public static interface HistoricalChartOwner {
        public HistoricalDataChart getChart();
    }

    public static interface PresetHandler {
        public void onPresetSelected(int var1, int var2);
    }
}

