/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.reporting.ReportDefinition;
import org.netxms.ui.eclipse.reporter.views.ReportNavigator;
import org.netxms.ui.eclipse.reporter.widgets.ReportExecutionForm;

public class ReportView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.reporter.views.ReportView";
    private ReportExecutionForm executionForm;
    private ISelectionListener selectionListener;
    private ISelectionService selectionService;
    private Composite parentComposite;

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof ReportNavigator && selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    ReportDefinition object = (ReportDefinition)((IStructuredSelection)selection).getFirstElement();
                    ReportView.this.setObject(object);
                }
            }
        };
        this.selectionService.addSelectionListener(this.selectionListener);
    }

    public void dispose() {
        if (this.selectionService != null && this.selectionListener != null) {
            this.selectionService.removeSelectionListener(this.selectionListener);
        }
        super.dispose();
    }

    public void setFocus() {
        if (this.executionForm != null) {
            this.executionForm.setFocus();
        }
    }

    protected void setObject(ReportDefinition definition) {
        if (this.executionForm != null) {
            this.executionForm.dispose();
        }
        this.executionForm = new ReportExecutionForm(this.parentComposite, 0, definition, (IWorkbenchPart)this);
        this.parentComposite.layout();
        this.setPartName(definition.getName());
    }
}

