/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.views;

import java.util.Date;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.constants.NodePollType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.PollingTarget;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class NodePollerView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectmanager.views.NodePollerView";
    private static final String[] POLL_NAME;
    private static final Color COLOR_ERROR;
    private static final Color COLOR_WARNING;
    private static final Color COLOR_INFO;
    private static final Color COLOR_LOCAL;
    private NXCSession session;
    private PollingTarget target;
    private NodePollType pollType;
    private Display display;
    private StyledText textArea;
    private boolean pollActive = false;
    private Action actionRestart;
    private Action actionClearOutput;

    static {
        String[] stringArray = new String[7];
        stringArray[0] = "";
        Messages.get();
        stringArray[1] = Messages.NodePollerView_StatusPoll;
        Messages.get();
        stringArray[2] = Messages.NodePollerView_FullConfigPoll;
        Messages.get();
        stringArray[3] = Messages.NodePollerView_InterfacePoll;
        Messages.get();
        stringArray[4] = Messages.NodePollerView_TopologyPoll;
        Messages.get();
        stringArray[5] = Messages.NodePollerView_ConfigPoll;
        Messages.get();
        stringArray[6] = Messages.NodePollerView_InstanceDiscovery;
        POLL_NAME = stringArray;
        COLOR_ERROR = new Color((Device)Display.getCurrent(), 192, 0, 0);
        COLOR_WARNING = new Color((Device)Display.getCurrent(), 255, 128, 0);
        COLOR_INFO = new Color((Device)Display.getCurrent(), 0, 128, 0);
        COLOR_LOCAL = new Color((Device)Display.getCurrent(), 0, 0, 192);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.display = Display.getCurrent();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        AbstractObject obj = this.session.findObjectById(Long.parseLong(parts[0]));
        PollingTarget pollingTarget = this.target = obj != null && obj instanceof PollingTarget ? (PollingTarget)obj : null;
        if (this.target == null) {
            Messages.get();
            throw new PartInitException(Messages.NodePollerView_InvalidObjectID);
        }
        this.pollType = NodePollType.valueOf((String)parts[1]);
        this.setPartName(String.valueOf(POLL_NAME[this.pollType.getValue()]) + " - " + this.target.getObjectName());
    }

    public void createPartControl(Composite parent) {
        this.textArea = new StyledText(parent, 770);
        this.textArea.setEditable(false);
        this.textArea.setFont(JFaceResources.getTextFont());
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objectmanager.contexts.NodePollerView");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionRestart = new Action(Messages.NodePollerView_ActionRestart, SharedIcons.RESTART){

            public void run() {
                NodePollerView.this.startPoll();
            }
        };
        this.actionRestart.setActionDefinitionId("org.netxms.ui.eclipse.objectmanager.commands.restart_poller");
        handlerService.activateHandler(this.actionRestart.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionRestart));
        Messages.get();
        this.actionClearOutput = new Action(Messages.NodePollerView_ActionClear, SharedIcons.CLEAR_LOG){

            public void run() {
                NodePollerView.this.textArea.setText("");
            }
        };
        this.actionClearOutput.setActionDefinitionId("org.netxms.ui.eclipse.objectmanager.commands.clear_output");
        handlerService.activateHandler(this.actionClearOutput.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionClearOutput));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionClearOutput);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionClearOutput);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                NodePollerView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.textArea);
        this.textArea.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        WidgetHelper.addStyledTextEditorActions((IMenuManager)manager, (StyledText)this.textArea, (boolean)true);
        manager.add((IAction)this.actionClearOutput);
    }

    private void addPollerMessage(String message) {
        Date now = new Date();
        this.textArea.append("[" + RegionalSettings.getDateTimeFormat().format(now) + "] ");
        int index = message.indexOf(127);
        if (index != -1) {
            this.textArea.append(message.substring(0, index));
            char code = message.charAt(index + 1);
            int lastPos = this.textArea.getCharCount();
            String msgPart = message.substring(index + 2);
            this.textArea.append(msgPart);
            StyleRange style = new StyleRange();
            style.start = lastPos;
            style.length = msgPart.length();
            style.foreground = this.getTextColor(code);
            this.textArea.setStyleRange(style);
        } else {
            this.textArea.append(message);
        }
        this.textArea.setCaretOffset(this.textArea.getCharCount());
        this.textArea.setTopIndex(this.textArea.getLineCount() - 1);
    }

    private Color getTextColor(char code) {
        switch (code) {
            case 'e': {
                return COLOR_ERROR;
            }
            case 'w': {
                return COLOR_WARNING;
            }
            case 'i': {
                return COLOR_INFO;
            }
            case 'l': {
                return COLOR_LOCAL;
            }
        }
        return null;
    }

    public void setFocus() {
        this.textArea.setFocus();
    }

    public void startPoll() {
        if (this.pollActive) {
            return;
        }
        this.pollActive = true;
        this.actionRestart.setEnabled(false);
        this.addPollerMessage("\u007fl**** Poll request sent to server ****\r\n");
        final TextOutputListener listener = new TextOutputListener(){

            public void messageReceived(final String message) {
                NodePollerView.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!NodePollerView.this.textArea.isDisposed()) {
                            NodePollerView.this.addPollerMessage(message);
                        }
                    }
                });
            }

            public void setStreamId(long streamId) {
            }
        };
        Messages.get();
        Job job = new Job(String.format(Messages.NodePollerView_JobName, this.target.getObjectName(), this.target.getObjectId())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    NodePollerView.this.session.pollNode(NodePollerView.this.target.getObjectId(), NodePollerView.this.pollType, listener);
                    NodePollerView.this.onPollComplete(true, null);
                }
                catch (Exception e) {
                    NodePollerView.this.onPollComplete(false, e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void onPollComplete(final boolean success, final String errorMessage) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (NodePollerView.this.textArea.isDisposed()) {
                    return;
                }
                if (success) {
                    NodePollerView.this.addPollerMessage("\u007fl**** Poll completed successfully ****\r\n\r\n");
                } else {
                    NodePollerView.this.addPollerMessage(String.format("\u007fePOLL ERROR: %s\r\n", errorMessage));
                    NodePollerView.this.addPollerMessage("\u007fl**** Poll failed ****\r\n\r\n");
                }
                NodePollerView.this.pollActive = false;
                NodePollerView.this.actionRestart.setEnabled(true);
            }
        });
    }
}

