/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.io.IOException;
import java.util.HashMap;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.DCOStatusHolder;
import org.netxms.client.datacollection.DataCollectionConfigurationChangeListener;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;

public class DataCollectionConfiguration {
    private NXCSession session;
    private long nodeId;
    private HashMap<Long, DataCollectionObject> items;
    private boolean isOpen = false;
    private Object userData = null;
    private SessionListener listener;
    private DataCollectionConfigurationChangeListener changeListener;

    public DataCollectionConfiguration(NXCSession session, long nodeId) {
        this.session = session;
        this.nodeId = nodeId;
        this.items = new HashMap(0);
    }

    public void open(DataCollectionConfigurationChangeListener changeListener) throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.session.newMessage(41);
        msg.setFieldInt32(3L, (int)this.nodeId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.changeListener = changeListener;
        while (!(response = this.session.waitForMessage(42, msg.getMessageId())).isEndOfSequence()) {
            DataCollectionObject dco;
            int type = response.getFieldAsInt32(411L);
            switch (type) {
                case 1: {
                    dco = new DataCollectionItem(this, response);
                    break;
                }
                case 2: {
                    dco = new DataCollectionTable(this, response);
                    break;
                }
                default: {
                    dco = null;
                }
            }
            if (dco == null) continue;
            this.items.put(dco.getId(), dco);
        }
        this.listener = new SessionListener(){

            @Override
            public void notificationHandler(SessionNotification n) {
                if (n.getSubCode() != DataCollectionConfiguration.this.nodeId) {
                    return;
                }
                if (n.getCode() == 1035) {
                    DataCollectionObject dco = (DataCollectionObject)n.getObject();
                    DataCollectionConfiguration.this.updateItemFromNotification(dco);
                    if (DataCollectionConfiguration.this.changeListener != null) {
                        DataCollectionConfiguration.this.changeListener.onUpdate(dco);
                    }
                } else if (n.getCode() == 1036) {
                    long id = (Long)n.getObject();
                    DataCollectionConfiguration.this.removeItemFromNotification(id);
                    if (DataCollectionConfiguration.this.changeListener != null) {
                        DataCollectionConfiguration.this.changeListener.onDelete(id);
                    }
                } else if (n.getCode() == 1037) {
                    DCOStatusHolder stHolder = (DCOStatusHolder)n.getObject();
                    DataCollectionConfiguration.this.updateItemStatusFromNotification(stHolder.getDciIdArray(), stHolder.getStatus());
                    if (DataCollectionConfiguration.this.changeListener != null) {
                        long[] lArray = stHolder.getDciIdArray();
                        int n2 = lArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            long id = lArray[n3];
                            DataCollectionConfiguration.this.changeListener.onStatusChange(id, stHolder.getStatus());
                            ++n3;
                        }
                    }
                }
            }
        };
        this.session.addListener(this.listener);
        this.isOpen = true;
    }

    public void close() throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(46);
        msg.setFieldInt32(3L, (int)this.nodeId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.items.clear();
        this.session.removeListener(this.listener);
        this.isOpen = false;
        this.changeListener = null;
    }

    public DataCollectionObject[] getItems() {
        return this.items.values().toArray(new DataCollectionObject[this.items.size()]);
    }

    public DataCollectionObject findItem(long id) {
        return this.items.get(id);
    }

    private void removeItemFromNotification(long id) {
        this.items.remove(id);
    }

    private void updateItemFromNotification(DataCollectionObject dco) {
        DataCollectionObject newDco = null;
        if (dco instanceof DataCollectionItem) {
            newDco = new DataCollectionItem(this, (DataCollectionItem)dco);
        } else if (dco instanceof DataCollectionTable) {
            newDco = new DataCollectionTable(this, (DataCollectionTable)dco);
        }
        this.items.put(newDco.getId(), newDco);
    }

    private void updateItemStatusFromNotification(long[] idList, int status) {
        int i = 0;
        while (i < idList.length) {
            DataCollectionObject o = this.items.get(idList[i]);
            if (o != null) {
                o.setStatus(status);
            }
            ++i;
        }
    }

    public DataCollectionObject findItem(long id, Class<? extends DataCollectionObject> classFilter) {
        DataCollectionObject o = this.items.get(id);
        if (o == null) {
            return null;
        }
        return classFilter.isInstance(o) ? o : null;
    }

    @Deprecated
    public long createItem(DataCollectionObject object) throws IOException, NXCException {
        if (object != null) {
            return this.modifyObject(object);
        }
        return this.modifyObject(new DataCollectionItem(this, 0L));
    }

    @Deprecated
    public long createTable(DataCollectionObject object) throws IOException, NXCException {
        if (object != null) {
            return this.modifyObject(object);
        }
        return this.modifyObject(new DataCollectionTable(this, 0L));
    }

    public void modifyObject(long dcObjectId) throws IOException, NXCException {
        DataCollectionObject dco = this.items.get(dcObjectId);
        if (dco == null) {
            throw new NXCException(14);
        }
        this.modifyObject(dco);
    }

    public long modifyObject(DataCollectionObject dco) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(45);
        msg.setFieldInt32(3L, (int)this.nodeId);
        if (dco != null) {
            dco.fillMessage(msg);
        }
        this.session.sendMessage(msg);
        return this.session.waitForRCC(msg.getMessageId()).getFieldAsInt64(43L);
    }

    private void copyObjectsInternal(long destNodeId, long[] items, boolean move) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(91);
        msg.setFieldInt32(109L, (int)this.nodeId);
        msg.setFieldInt32(110L, (int)destNodeId);
        msg.setFieldInt16(220L, move ? 1 : 0);
        msg.setFieldInt32(111L, items.length);
        msg.setField(112L, items);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void copyObjects(long destNodeId, long[] items) throws IOException, NXCException {
        this.copyObjectsInternal(destNodeId, items, false);
    }

    public void moveObjects(long destNodeId, long[] items) throws IOException, NXCException {
        this.copyObjectsInternal(destNodeId, items, true);
    }

    public void clearCollectedData(long itemId) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(228);
        msg.setFieldInt32(3L, (int)this.nodeId);
        msg.setFieldInt32(43L, (int)itemId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void setObjectStatus(long[] items, int status) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(104);
        msg.setFieldInt32(3L, (int)this.nodeId);
        msg.setFieldInt16(48L, status);
        msg.setFieldInt32(111L, items.length);
        msg.setField(112L, items);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void deleteObject(long itemId) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(44);
        msg.setFieldInt32(3L, (int)this.nodeId);
        msg.setFieldInt32(43L, (int)itemId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.items.remove(itemId);
    }

    protected void finalize() throws Throwable {
        if (this.isOpen) {
            this.close();
        }
        super.finalize();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    protected final NXCSession getSession() {
        return this.session;
    }
}

